/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.omniconfig.backing;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.github.cruciblemc.omniconfig.backing.Configuration;
import io.github.cruciblemc.omniconfig.backing.Property;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ConfigCategory
implements Map<String, Property> {
    private final String name;
    private String comment;
    private String languagekey;
    private final ArrayList<ConfigCategory> children = new ArrayList();
    private final Map<String, Property> properties = new TreeMap<String, Property>();
    private final int propNumber = 0;
    public final ConfigCategory parent;
    private boolean changed = false;
    private boolean requiresWorldRestart = false;
    private boolean showInGui = true;
    private boolean requiresMcRestart = false;
    private List<String> propertyOrder = null;
    public boolean initialized = false;

    public ConfigCategory(String name) {
        this(name, null);
    }

    public ConfigCategory(String name, ConfigCategory parent) {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConfigCategory) {
            ConfigCategory cat = (ConfigCategory)obj;
            return this.name.equals(cat.name) && this.children.equals(cat.children);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return ConfigCategory.getQualifiedName(this.name, this.parent);
    }

    public static String getQualifiedName(String name, ConfigCategory parent) {
        return parent == null ? name : parent.getQualifiedName() + "$" + name;
    }

    public ConfigCategory getFirstParent() {
        return this.parent == null ? this : this.parent.getFirstParent();
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public Map<String, Property> getValues() {
        return Collections.unmodifiableMap(this.properties);
    }

    public List<Property> getOrderedValues() {
        if (this.propertyOrder != null) {
            ArrayList<Property> set = new ArrayList<Property>();
            for (String key : this.propertyOrder) {
                if (!this.properties.containsKey(key)) continue;
                set.add(this.properties.get(key));
            }
            return ImmutableList.copyOf(set);
        }
        return ImmutableList.copyOf(this.properties.values());
    }

    public ConfigCategory setLanguageKey(String languagekey) {
        this.languagekey = languagekey;
        return this;
    }

    public String getLanguagekey() {
        if (this.languagekey != null) {
            return this.languagekey;
        }
        return this.getQualifiedName();
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public ConfigCategory setRequiresWorldRestart(boolean requiresWorldRestart) {
        this.requiresWorldRestart = requiresWorldRestart;
        return this;
    }

    public boolean requiresWorldRestart() {
        return this.requiresWorldRestart;
    }

    public ConfigCategory setShowInGui(boolean showInGui) {
        this.showInGui = showInGui;
        return this;
    }

    public boolean showInGui() {
        return this.showInGui;
    }

    public ConfigCategory setRequiresMcRestart(boolean requiresMcRestart) {
        this.requiresMcRestart = this.requiresWorldRestart = requiresMcRestart;
        return this;
    }

    public boolean requiresMcRestart() {
        return this.requiresMcRestart;
    }

    public ConfigCategory setPropertyOrder(List<String> propertyOrder) {
        this.propertyOrder = propertyOrder;
        for (String s : this.properties.keySet()) {
            if (propertyOrder.contains(s)) continue;
            propertyOrder.add(s);
        }
        return this;
    }

    public List<String> getPropertyOrder() {
        if (this.propertyOrder != null) {
            return ImmutableList.copyOf(this.propertyOrder);
        }
        return ImmutableList.copyOf(this.properties.keySet());
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Property get(String key) {
        return this.properties.get(key);
    }

    private void write(BufferedWriter out, String ... data) throws IOException {
        this.write(out, true, data);
    }

    private void write(BufferedWriter out, boolean new_line, String ... data) throws IOException {
        for (String element : data) {
            out.write(element);
        }
        if (new_line) {
            out.write(Configuration.NEW_LINE);
        }
    }

    public void write(BufferedWriter out, int indent, boolean forceDefaultValues, Configuration owner) throws IOException {
        String pad0 = this.getIndent(indent);
        String pad1 = this.getIndent(indent + 1);
        String pad2 = this.getIndent(indent + 2);
        if (this.comment != null && !this.comment.isEmpty()) {
            this.write(out, pad0, "##########################################################################################################");
            this.write(out, pad0, "# ", this.name);
            this.write(out, pad0, "#--------------------------------------------------------------------------------------------------------#");
            Splitter splitter = Splitter.onPattern((String)"\r?\n");
            for (String line : splitter.split((CharSequence)this.comment)) {
                this.write(out, pad0, "# ", line);
            }
            this.write(out, pad0, "##########################################################################################################", Configuration.NEW_LINE);
        }
        String displayName = '\"' + this.name + '\"';
        this.write(out, pad0, displayName, " {");
        ArrayList orderedValues = new ArrayList();
        this.getOrderedValues().forEach((? super T value) -> {
            if (value.initialized || !owner.terminateNonInvokedKeys()) {
                orderedValues.add(value);
            }
        });
        Property[] props = orderedValues.toArray(new Property[0]);
        for (int x = 0; x < props.length; ++x) {
            String propName;
            Property prop = props[x];
            if (prop.comment != null && !prop.comment.isEmpty()) {
                if (x != 0) {
                    out.newLine();
                }
                Splitter splitter = Splitter.onPattern((String)"\r?\n");
                for (String commentLine : splitter.split((CharSequence)prop.comment)) {
                    this.write(out, pad1, "# ", commentLine);
                }
            }
            if (!Configuration.allowedProperties.matchesAllOf((CharSequence)(propName = prop.getName()))) {
                propName = '\"' + propName + '\"';
            }
            if (prop.isList()) {
                char type = prop.getType().getID();
                this.write(out, pad1, String.valueOf(type), ":", propName, " <");
                for (String line : prop.getRawValues(forceDefaultValues)) {
                    this.write(out, pad2, line);
                }
                this.write(out, pad1, " >");
                continue;
            }
            if (prop.getType() == null) {
                this.write(out, pad1, propName, "=", prop.getRawValue(forceDefaultValues));
                continue;
            }
            char type = prop.getType().getID();
            this.write(out, pad1, String.valueOf(type), ":", propName, "=", prop.getRawValue(forceDefaultValues));
        }
        this.children.removeIf(child -> !child.initialized && owner.terminateNonInvokedKeys());
        if (this.children.size() > 0) {
            out.newLine();
        }
        for (ConfigCategory child2 : this.children) {
            if (!child2.initialized && owner.terminateNonInvokedKeys()) continue;
            child2.write(out, indent + 1, forceDefaultValues, owner);
        }
        this.write(out, pad0, "}", Configuration.NEW_LINE);
    }

    private String getIndent(int indent) {
        StringBuilder buf = new StringBuilder();
        for (int x = 0; x < indent; ++x) {
            buf.append("    ");
        }
        return buf.toString();
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (Property prop : this.properties.values()) {
            if (!prop.hasChanged()) continue;
            return true;
        }
        return false;
    }

    void resetChangedState() {
        this.changed = false;
        for (Property prop : this.properties.values()) {
            prop.resetChangedState();
        }
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Property get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Property put(String key, Property value) {
        this.changed = true;
        if (this.propertyOrder != null && !this.propertyOrder.contains(key)) {
            this.propertyOrder.add(key);
        }
        return this.properties.put(key, value);
    }

    @Override
    public Property remove(Object key) {
        this.changed = true;
        return this.properties.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Property> m) {
        this.changed = true;
        if (this.propertyOrder != null) {
            for (String string : m.keySet()) {
                if (this.propertyOrder.contains(string)) continue;
                this.propertyOrder.add(string);
            }
        }
        this.properties.putAll(m);
    }

    @Override
    public void clear() {
        this.changed = true;
        this.properties.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Collection<Property> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<String, Property>> entrySet() {
        return ImmutableSet.copyOf(this.properties.entrySet());
    }

    public Set<ConfigCategory> getChildren() {
        return ImmutableSet.copyOf(this.children);
    }

    public void removeChild(ConfigCategory child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
            this.changed = true;
        }
    }
}

