/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.api.blocks.IKeystoneLockable;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.blocks.BlocksCommonProxy;
import am2.spell.SpellUtils;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntitySpellSealedDoor
extends TileEntity
implements IInventory,
IKeystoneLockable {
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private int lastAppliedTime = -1;
    private int closeTime = -1;
    private int curTime = 0;
    private int opentime = 40;
    private ArrayList<ISpellComponent> appliedParts = new ArrayList();
    private ArrayList<ISpellComponent> key = new ArrayList();

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.inventory[0], this.inventory[1], this.inventory[2]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Spell Sealed Door";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
        this.analyzeSpellForKey();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("SpellSealedDoorInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("SpellSealedDoorInventory", (NBTBase)nbttaglist);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            ++this.curTime;
            if (this.closeTime == -1 && this.lastAppliedTime != -1) {
                if (this.curTime > this.lastAppliedTime + 10) {
                    this.clearAppliedParts();
                    return;
                }
                if (this.checkKey()) {
                    this.clearAppliedParts();
                    this.setOpenState(true);
                    this.closeTime = this.curTime + this.opentime;
                }
            }
            if (this.closeTime != -1 && this.curTime > this.closeTime) {
                this.clearAppliedParts();
                this.setOpenState(false);
                this.closeTime = -1;
            }
        }
    }

    private void setOpenState(boolean open) {
        BlocksCommonProxy.spellSealedDoor.setDoorState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, null, open);
    }

    public void addPartToCurrentKey(ISpellComponent component) {
        this.appliedParts.add(component);
        this.lastAppliedTime = this.curTime;
    }

    private boolean checkKey() {
        if (this.key.size() != this.appliedParts.size()) {
            return false;
        }
        return this.key.equals(this.appliedParts);
    }

    private void clearAppliedParts() {
        this.appliedParts.clear();
        this.lastAppliedTime = -1;
    }

    public void analyzeSpellForKey() {
        ItemStack spell = this.inventory[3];
        if (spell == null) {
            return;
        }
        this.key.clear();
        int stages = SpellUtils.instance.numStages(spell);
        for (int i = 0; i < stages; ++i) {
            ISpellComponent[] components;
            for (ISpellComponent comp : components = SpellUtils.instance.getComponentsForStage(spell, i)) {
                this.key.add(comp);
            }
        }
    }
}

