/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.api.flickers.IFlickerController;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.power.PowerTypes;
import am2.api.spell.enums.Affinity;
import am2.blocks.tileentities.TileEntityAMPower;
import am2.blocks.tileentities.TileEntityFlickerHabitat;
import am2.blocks.tileentities.flickers.FlickerOperatorRegistry;
import am2.items.ItemsCommonProxy;
import am2.power.PowerNodeRegistry;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFlickerControllerBase
extends TileEntityAMPower
implements IFlickerController {
    private HashMap<Integer, byte[]> sigilMetadata;
    private IFlickerFunctionality operator;
    private int tickCounter;
    Affinity[] nearbyList = new Affinity[6];
    private boolean lastOpWasPowered = false;
    private boolean firstOp = true;

    public TileEntityFlickerControllerBase() {
        super(500);
        this.sigilMetadata = new HashMap();
    }

    protected void setOperator(IFlickerFunctionality operator) {
        if (this.operator != null) {
            this.operator.RemoveOperator(this.field_145850_b, this, PowerNodeRegistry.For(this.field_145850_b).checkPower(this, this.operator.PowerPerOperation()), this.nearbyList);
        }
        this.operator = operator;
        this.tickCounter = 0;
    }

    public void updateOperator(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != ItemsCommonProxy.flickerFocus) {
            return;
        }
        this.operator = FlickerOperatorRegistry.instance.getOperatorForMask(stack.func_77960_j());
    }

    public void scanForNearbyUpgrades() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (te == null || !(te instanceof TileEntityFlickerHabitat)) continue;
            this.nearbyList[direction.ordinal()] = ((TileEntityFlickerHabitat)te).getSelectedAffinity();
        }
    }

    public void notifyOfNearbyUpgradeChange(TileEntity neighbor) {
        ForgeDirection direction;
        if (neighbor instanceof TileEntityFlickerHabitat && (direction = this.getNeighboringForgeDirection(neighbor)) != ForgeDirection.UNKNOWN) {
            this.nearbyList[direction.ordinal()] = ((TileEntityFlickerHabitat)neighbor).getSelectedAffinity();
        }
    }

    private ForgeDirection getNeighboringForgeDirection(TileEntity neighbor) {
        if (neighbor.field_145851_c == this.field_145851_c && neighbor.field_145848_d == this.field_145848_d && neighbor.field_145849_e == this.field_145849_e + 1) {
            return ForgeDirection.SOUTH;
        }
        if (neighbor.field_145851_c == this.field_145851_c && neighbor.field_145848_d == this.field_145848_d && neighbor.field_145849_e == this.field_145849_e - 1) {
            return ForgeDirection.NORTH;
        }
        if (neighbor.field_145851_c == this.field_145851_c + 1 && neighbor.field_145848_d == this.field_145848_d && neighbor.field_145849_e == this.field_145849_e) {
            return ForgeDirection.EAST;
        }
        if (neighbor.field_145851_c == this.field_145851_c - 1 && neighbor.field_145848_d == this.field_145848_d && neighbor.field_145849_e == this.field_145849_e) {
            return ForgeDirection.WEST;
        }
        if (neighbor.field_145851_c == this.field_145851_c && neighbor.field_145848_d == this.field_145848_d + 1 && neighbor.field_145849_e == this.field_145849_e) {
            return ForgeDirection.UP;
        }
        if (neighbor.field_145851_c == this.field_145851_c && neighbor.field_145848_d == this.field_145848_d - 1 && neighbor.field_145849_e == this.field_145849_e) {
            return ForgeDirection.DOWN;
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public void func_145845_h() {
        Affinity[] unpoweredNeighbors;
        boolean powered;
        super.func_145845_h();
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            ++this.tickCounter;
            return;
        }
        if (this.operator != null && this.tickCounter++ >= this.operator.TimeBetweenOperation(powered = PowerNodeRegistry.For(this.field_145850_b).checkPower(this, this.operator.PowerPerOperation()), unpoweredNeighbors = this.getUnpoweredNeighbors())) {
            this.tickCounter = 0;
            if (powered && this.operator.RequiresPower() || !this.operator.RequiresPower()) {
                boolean success;
                if (this.firstOp) {
                    this.scanForNearbyUpgrades();
                    this.firstOp = false;
                }
                if ((success = this.operator.DoOperation(this.field_145850_b, this, powered, unpoweredNeighbors)) || this.operator.RequiresPower()) {
                    PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), this.operator.PowerPerOperation());
                }
                this.lastOpWasPowered = true;
            } else if (this.lastOpWasPowered && this.operator.RequiresPower() && !powered) {
                this.operator.RemoveOperator(this.field_145850_b, this, powered, unpoweredNeighbors);
                this.lastOpWasPowered = false;
            }
        }
    }

    private Affinity[] getUnpoweredNeighbors() {
        Affinity[] aff = new Affinity[ForgeDirection.values().length];
        for (int i = 0; i < this.nearbyList.length; ++i) {
            ForgeDirection dir = ForgeDirection.values()[i];
            aff[i] = this.nearbyList[i] == null || this.field_145850_b.func_72864_z(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) ? null : this.nearbyList[i];
        }
        return aff;
    }

    private Integer getFlagForOperator(IFlickerFunctionality operator) {
        return FlickerOperatorRegistry.instance.getMaskForOperator(operator);
    }

    @Override
    public void setMetadata(IFlickerFunctionality operator, byte[] meta) {
        this.sigilMetadata.put(this.getFlagForOperator(operator), meta);
    }

    @Override
    public byte[] getMetadata(IFlickerFunctionality operator) {
        byte[] arr = this.sigilMetadata.get(this.getFlagForOperator(operator));
        return arr != null ? arr : new byte[]{};
    }

    @Override
    public void removeMetadata(IFlickerFunctionality operator) {
        this.sigilMetadata.remove(this.getFlagForOperator(operator));
    }

    @Override
    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        NBTTagList sigilMetaStore = new NBTTagList();
        for (Integer i : this.sigilMetadata.keySet()) {
            NBTTagCompound sigilMetaEntry = new NBTTagCompound();
            sigilMetaEntry.func_74768_a("sigil_mask", i.intValue());
            sigilMetaEntry.func_74773_a("sigil_meta", this.sigilMetadata.get(i));
            sigilMetaStore.func_74742_a((NBTBase)sigilMetaEntry);
        }
        par1nbtTagCompound.func_74782_a("sigil_metadata_collection", (NBTBase)sigilMetaStore);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.sigilMetadata = new HashMap();
        NBTTagList sigilMetaStore = par1nbtTagCompound.func_150295_c("sigil_metadata_collection", 10);
        for (int i = 0; i < sigilMetaStore.func_74745_c(); ++i) {
            NBTTagCompound sigilMetaEntry = sigilMetaStore.func_150305_b(i);
            Integer mask = sigilMetaEntry.func_74762_e("sigil_mask");
            byte[] meta = sigilMetaEntry.func_74770_j("sigil_meta");
            this.sigilMetadata.put(mask, meta);
        }
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public boolean canRequestPower() {
        return true;
    }

    @Override
    public boolean isSource() {
        return false;
    }

    @Override
    public int getChargeRate() {
        return 100;
    }

    @Override
    public PowerTypes[] getValidPowerTypes() {
        return PowerTypes.all();
    }

    @Override
    public float particleOffset(int axis) {
        return 0.5f;
    }

    public Affinity[] getNearbyUpgrades() {
        return this.getUnpoweredNeighbors();
    }
}

