/*
 * Decompiled with CFR 0.152.
 */
package am2.buffs;

import am2.AMCore;
import am2.LogHelper;
import am2.api.potion.IBuffHelper;
import am2.buffs.ArsMagicaPotion;
import am2.buffs.BuffEffect;
import am2.buffs.BuffEffectAgility;
import am2.buffs.BuffEffectAstralDistortion;
import am2.buffs.BuffEffectBurnoutReduction;
import am2.buffs.BuffEffectCharmed;
import am2.buffs.BuffEffectClarity;
import am2.buffs.BuffEffectEntangled;
import am2.buffs.BuffEffectFlight;
import am2.buffs.BuffEffectFrostSlowed;
import am2.buffs.BuffEffectFury;
import am2.buffs.BuffEffectGravityWell;
import am2.buffs.BuffEffectHaste;
import am2.buffs.BuffEffectIllumination;
import am2.buffs.BuffEffectLeap;
import am2.buffs.BuffEffectLevitation;
import am2.buffs.BuffEffectMagicShield;
import am2.buffs.BuffEffectManaRegen;
import am2.buffs.BuffEffectManaShield;
import am2.buffs.BuffEffectRegeneration;
import am2.buffs.BuffEffectScrambleSynapses;
import am2.buffs.BuffEffectShrink;
import am2.buffs.BuffEffectSilence;
import am2.buffs.BuffEffectSlowfall;
import am2.buffs.BuffEffectSpellReflect;
import am2.buffs.BuffEffectSwiftSwim;
import am2.buffs.BuffEffectTemporalAnchor;
import am2.buffs.BuffEffectTrueSight;
import am2.buffs.BuffEffectWaterBreathing;
import am2.buffs.BuffEffectWateryGrave;
import am2.buffs.BuffMaxManaIncrease;
import am2.buffs.ManaPotion;
import am2.particles.AMParticle;
import am2.particles.ParticleLiveForBuffDuration;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.potion.Potion;

public class BuffList
implements IBuffHelper {
    public static ArsMagicaPotion waterBreathing;
    public static ArsMagicaPotion flight;
    public static ArsMagicaPotion slowfall;
    public static ArsMagicaPotion haste;
    public static ArsMagicaPotion trueSight;
    public static ArsMagicaPotion regeneration;
    public static ArsMagicaPotion magicShield;
    public static ArsMagicaPotion charmed;
    public static ArsMagicaPotion frostSlowed;
    public static ArsMagicaPotion temporalAnchor;
    public static ArsMagicaPotion manaRegen;
    public static ArsMagicaPotion entangled;
    public static ArsMagicaPotion wateryGrave;
    public static ArsMagicaPotion spellReflect;
    public static ArsMagicaPotion silence;
    public static ArsMagicaPotion swiftSwim;
    public static ArsMagicaPotion agility;
    public static ArsMagicaPotion leap;
    public static ArsMagicaPotion gravityWell;
    public static ArsMagicaPotion astralDistortion;
    public static ArsMagicaPotion levitation;
    public static ArsMagicaPotion clarity;
    public static ArsMagicaPotion illumination;
    public static ArsMagicaPotion manaBoost;
    public static ArsMagicaPotion manaShield;
    public static ArsMagicaPotion fury;
    public static ArsMagicaPotion scrambleSynapses;
    public static ArsMagicaPotion shrink;
    public static ArsMagicaPotion burnoutReduction;
    public static ArsMagicaPotion greaterManaPotion;
    public static ArsMagicaPotion epicManaPotion;
    public static ArsMagicaPotion legendaryManaPotion;
    private static final int maxParticlesPerBuff = 100;
    public static final int default_buff_duration = 600;
    private static int potionDefaultOffset;
    public static HashMap<Integer, Integer> particlesForBuffID;
    private static HashMap<Integer, Class> classesForBuffID;
    private static final HashMap<Integer, BuffEffect> utilityBuffs;
    private static final ArrayList<ArsMagicaPotion> arsMagicaPotions;
    private static ArrayList<Integer> dispelBlacklist;
    public static final BuffList instance;
    private static HashMap<Integer, Potion> ourInitialPotionAllocations;

    private BuffList() {
    }

    private static ArsMagicaPotion createAMPotion(int index, String name, int IIconRow, int iconCol, boolean isBadEffect, Class buffEffectClass) {
        String configID = name.replace(" ", "").toLowerCase().trim();
        index = AMCore.config.getConfigurablePotionID(configID, index);
        LogHelper.info("Potion %s is ID %d", name, index);
        if (Potion.field_76425_a[index] != null) {
            LogHelper.error("Warning: Potion index %d is already occupied by potion %s. Check your config files for clashes.", index, Potion.field_76425_a[index].func_76393_a());
        }
        ArsMagicaPotion potion = new ArsMagicaPotion(index, isBadEffect, 0);
        potion.func_76390_b(name);
        potion._setIconIndex(iconCol, IIconRow);
        classesForBuffID.put(index, buffEffectClass);
        arsMagicaPotions.add(potion);
        ourInitialPotionAllocations.put(index, potion);
        return potion;
    }

    private static ManaPotion createManaPotion(int index, String name, int IIconRow, int iconCol, boolean isBadEffect, int colour) {
        String configID = name.replace(" ", "").toLowerCase().trim();
        index = AMCore.config.getConfigurablePotionID(configID, index);
        LogHelper.info("Potion %s is ID %d", name, index);
        if (Potion.field_76425_a[index] != null) {
            LogHelper.warn("Warning: Potion index %d is already occupied by potion %s. Check your config files for clashes.", index, Potion.field_76425_a[index].func_76393_a());
        }
        ManaPotion potion = new ManaPotion(index, isBadEffect, colour);
        potion.func_76390_b(name);
        potion._setIconIndex(iconCol, IIconRow);
        ourInitialPotionAllocations.put(index, potion);
        return potion;
    }

    private static void createDummyBuff(Class buffEffectClass, int potionID) {
        try {
            Constructor ctor = buffEffectClass.getConstructor(Integer.TYPE, Integer.TYPE);
            BuffEffect utilityBuff = (BuffEffect)((Object)ctor.newInstance(0, 0));
            utilityBuffs.put(potionID, utilityBuff);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void Init() {
        dispelBlacklist = new ArrayList();
        particlesForBuffID = new HashMap();
        classesForBuffID = new HashMap();
        ourInitialPotionAllocations = new HashMap();
        try {
            BuffList.extendPotionsArray();
            int numBuffs = Potion.field_76425_a.length;
            for (int i = 0; i < numBuffs; ++i) {
                particlesForBuffID.put(i, 0);
            }
        }
        catch (Throwable t) {
            LogHelper.error("Buffs failed to initialize!  This will make the game very unstable!", new Object[0]);
            t.printStackTrace();
        }
    }

    public static void postInit() {
        for (Map.Entry<Integer, Potion> entry : ourInitialPotionAllocations.entrySet()) {
            if (Potion.field_76425_a[entry.getKey()] == entry.getValue()) continue;
            LogHelper.warn("My potion, %s, at index %d has been over-written by another potion, %s. You have a conflict in your configuration files.", entry.getValue().func_76393_a(), entry.getKey(), Potion.field_76425_a[entry.getKey()].func_76393_a());
        }
    }

    public static void Instantiate() {
        waterBreathing = BuffList.createAMPotion(potionDefaultOffset + 0, "Water Breathing", 0, 0, false, BuffEffectWaterBreathing.class);
        flight = BuffList.createAMPotion(potionDefaultOffset + 1, "Flight", 0, 1, false, BuffEffectFlight.class);
        slowfall = BuffList.createAMPotion(potionDefaultOffset + 2, "Feather Fall", 0, 2, false, BuffEffectSlowfall.class);
        haste = BuffList.createAMPotion(potionDefaultOffset + 3, "Haste", 0, 3, false, BuffEffectHaste.class);
        trueSight = BuffList.createAMPotion(potionDefaultOffset + 4, "True Sight", 0, 4, false, BuffEffectTrueSight.class);
        regeneration = BuffList.createAMPotion(potionDefaultOffset + 5, "Regeneration", 0, 6, false, BuffEffectRegeneration.class);
        magicShield = BuffList.createAMPotion(potionDefaultOffset + 6, "Magic Shield", 1, 1, false, BuffEffectMagicShield.class);
        charmed = BuffList.createAMPotion(potionDefaultOffset + 7, "Charmed", 1, 2, true, BuffEffectCharmed.class);
        frostSlowed = BuffList.createAMPotion(potionDefaultOffset + 8, "Frost Slow", 1, 3, true, BuffEffectFrostSlowed.class);
        temporalAnchor = BuffList.createAMPotion(potionDefaultOffset + 9, "Chrono Anchor", 1, 4, false, BuffEffectTemporalAnchor.class);
        manaRegen = BuffList.createAMPotion(potionDefaultOffset + 10, "Mana Regen", 1, 5, false, BuffEffectManaRegen.class);
        entangled = BuffList.createAMPotion(potionDefaultOffset + 11, "Entangled", 1, 7, true, BuffEffectEntangled.class);
        wateryGrave = BuffList.createAMPotion(potionDefaultOffset + 12, "Watery Grave", 2, 0, true, BuffEffectWateryGrave.class);
        spellReflect = BuffList.createAMPotion(potionDefaultOffset + 13, "Spell Reflect", 2, 3, false, BuffEffectSpellReflect.class);
        silence = BuffList.createAMPotion(potionDefaultOffset + 14, "Silence", 2, 6, true, BuffEffectSilence.class);
        swiftSwim = BuffList.createAMPotion(potionDefaultOffset + 15, "Swift Swim", 2, 7, false, BuffEffectSwiftSwim.class);
        agility = BuffList.createAMPotion(potionDefaultOffset + 16, "Agility", 0, 0, false, BuffEffectAgility.class);
        leap = BuffList.createAMPotion(potionDefaultOffset + 17, "Leap", 0, 2, false, BuffEffectLeap.class);
        manaBoost = BuffList.createAMPotion(potionDefaultOffset + 18, "Mana Boost", 1, 0, false, BuffMaxManaIncrease.class);
        astralDistortion = BuffList.createAMPotion(potionDefaultOffset + 19, "Astral Distortion", 0, 4, true, BuffEffectAstralDistortion.class);
        manaShield = BuffList.createAMPotion(potionDefaultOffset + 20, "Mana Shield", 0, 7, false, BuffEffectManaShield.class);
        fury = BuffList.createAMPotion(potionDefaultOffset + 21, "Fury", 1, 6, false, BuffEffectFury.class);
        scrambleSynapses = BuffList.createAMPotion(potionDefaultOffset + 22, "Scramble Synapses", 1, 7, true, BuffEffectScrambleSynapses.class);
        illumination = BuffList.createAMPotion(potionDefaultOffset + 23, "Illuminated", 1, 0, false, BuffEffectIllumination.class);
        greaterManaPotion = BuffList.createManaPotion(potionDefaultOffset + 24, "Greater Mana Restoration", 0, 1, false, 4245182);
        epicManaPotion = BuffList.createManaPotion(potionDefaultOffset + 25, "Epic Mana Restoration", 0, 1, false, 0xFF00FF);
        legendaryManaPotion = BuffList.createManaPotion(potionDefaultOffset + 26, "Legendary Mana Restoration", 0, 1, false, 0xFFFF00);
        gravityWell = BuffList.createAMPotion(potionDefaultOffset + 27, "Gravity Well", 0, 6, true, BuffEffectGravityWell.class);
        levitation = BuffList.createAMPotion(potionDefaultOffset + 28, "Levitation", 0, 7, false, BuffEffectLevitation.class);
        clarity = BuffList.createAMPotion(potionDefaultOffset + 29, "Clarity", 0, 5, false, BuffEffectClarity.class);
        shrink = BuffList.createAMPotion(potionDefaultOffset + 30, "Shrunken", 0, 5, false, BuffEffectShrink.class);
        burnoutReduction = BuffList.createAMPotion(potionDefaultOffset + 31, "Burnout Redux", 1, 1, false, BuffEffectBurnoutReduction.class);
        for (int i : classesForBuffID.keySet()) {
            BuffList.createDummyBuff(classesForBuffID.get(i), i);
        }
    }

    public static void setupTextureOverrides() {
        waterBreathing.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        flight.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        slowfall.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        haste.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        trueSight.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        regeneration.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        magicShield.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        charmed.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        frostSlowed.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        temporalAnchor.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        manaRegen.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        entangled.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        wateryGrave.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        spellReflect.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        silence.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        swiftSwim.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        clarity.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        manaShield.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        manaBoost.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        fury.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_1.png"));
        agility.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_2.png"));
        leap.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_2.png"));
        astralDistortion.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_2.png"));
        gravityWell.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_2.png"));
        levitation.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_2.png"));
        illumination.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_2.png"));
        scrambleSynapses.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_2.png"));
        shrink.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_2.png"));
        burnoutReduction.setTextureSheet(ResourceManager.GetGuiTexturePath("buffs_2.png"));
    }

    private static void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }

    private static void extendPotionsArray() throws Exception {
        LogHelper.info("Extending potions array", new Object[0]);
        LogHelper.info("Injecting potions starting from index " + Potion.field_76425_a.length, new Object[0]);
        potionDefaultOffset = Potion.field_76425_a.length;
        BuffList.setPotionArrayLength(255);
    }

    private static void setPotionArrayLength(int length) throws Exception {
        Field[] fields;
        if (length <= Potion.field_76425_a.length) {
            return;
        }
        Potion[] potions = new Potion[length];
        for (int i = 0; i < Potion.field_76425_a.length; ++i) {
            potions[i] = Potion.field_76425_a[i];
        }
        Field field = null;
        for (Field f : fields = Potion.class.getDeclaredFields()) {
            if (!f.getType().equals(Potion[].class)) continue;
            field = f;
            break;
        }
        BuffList.setFinalStatic(field, potions);
    }

    public static boolean IDIsAMBuff(int potionID) {
        for (ArsMagicaPotion i : arsMagicaPotions) {
            if (i.field_76415_H != potionID) continue;
            return true;
        }
        return false;
    }

    public static boolean addParticleToBuff(AMParticle particle, EntityLiving ent, int priority, boolean exclusive, int buffID) {
        if (particlesForBuffID.get(buffID) >= 100) {
            return false;
        }
        int count = particlesForBuffID.get(buffID);
        particlesForBuffID.put(buffID, ++count);
        particle.AddParticleController(new ParticleLiveForBuffDuration(particle, ent, buffID, priority, exclusive));
        return true;
    }

    public static BuffEffect buffEffectFromPotionID(int potionID, int duration, int amplifier) {
        Class _class = classesForBuffID.get(potionID);
        if (_class == null) {
            return null;
        }
        Constructor<?> buffMaker = _class.getDeclaredConstructors()[0];
        try {
            buffMaker.setAccessible(true);
            BuffEffect p = (BuffEffect)((Object)buffMaker.newInstance(duration, amplifier));
            return p;
        }
        catch (InstantiationException e) {
            LogHelper.error("Could not create potion: " + e.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException e) {
            LogHelper.error("Could not create potion: " + e.getMessage(), new Object[0]);
        }
        catch (IllegalArgumentException e) {
            LogHelper.error("Could not create potion: " + e.getMessage(), new Object[0]);
        }
        catch (InvocationTargetException e) {
            LogHelper.error("Could not create potion: " + e.getMessage(), new Object[0]);
        }
        return null;
    }

    public static void buffEnding(int buffID) {
        particlesForBuffID.put(buffID, 0);
    }

    @Override
    public int getPotionID(String name) {
        Field potionField = ReflectionHelper.findField(BuffList.class, (String[])new String[]{name});
        if (potionField != null && potionField.getType() == ArsMagicaPotion.class) {
            try {
                return ((ArsMagicaPotion)((Object)potionField.get(null))).func_76396_c();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    @Override
    public void addDispelExclusion(int id) {
        if (dispelBlacklist.contains(id)) {
            LogHelper.info("Id %d was already on the dispel blacklist; skipping.", id);
        } else {
            LogHelper.info("Added %d to the dispel blacklist.", id);
            dispelBlacklist.add(id);
        }
    }

    public static boolean isDispelBlacklisted(int id) {
        return dispelBlacklist.contains(id);
    }

    static {
        potionDefaultOffset = 0;
        utilityBuffs = new HashMap();
        arsMagicaPotions = new ArrayList();
        instance = new BuffList();
    }
}

