/*
 * Decompiled with CFR 0.152.
 */
package am2.entities;

import am2.entities.EntityLightMage;
import am2.entities.EntityManaVortex;
import am2.entities.SpawnBlacklists;
import am2.entities.ai.EntityAIRangedAttackSpell;
import am2.entities.ai.selectors.DarkMageEntitySelector;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import am2.texture.ResourceManager;
import am2.utility.NPCSpells;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityDarkMage
extends EntityMob {
    private static ItemStack diminishedHeldItem = new ItemStack((Item)ItemsCommonProxy.bookAffinity, 1, 6);
    private static ItemStack normalHeldItem = new ItemStack((Item)ItemsCommonProxy.bookAffinity, 1, 3);
    private static ItemStack augmentedHeldItem = new ItemStack((Item)ItemsCommonProxy.bookAffinity, 1, 0);
    private boolean hasUpdated = false;
    public static final int DW_MAGE_SKIN = 20;
    public static final int DW_MAGE_BOOK = 21;

    public EntityDarkMage(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.0f);
        ExtendedProperties.For((EntityLivingBase)this).setMagicLevelWithMana(10 + this.field_70146_Z.nextInt(20));
        this.initAI();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)(this.field_70146_Z.nextInt(10) + 1));
    }

    public ItemStack func_70694_bm() {
        int cm = this.field_70180_af.func_75679_c(21);
        if (cm == 0) {
            return diminishedHeldItem;
        }
        if (cm == 1) {
            return normalHeldItem;
        }
        return augmentedHeldItem;
    }

    private void initAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLightMage.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)this.MovementSpeed()));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityManaVortex.class, 10.0f, (double)this.MovementSpeed(), (double)this.ActionSpeed()));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRangedAttackSpell((EntityCreature)this, this.MovementSpeed(), 40, NPCSpells.instance.darkMage_DiminishedAttack));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLightMage.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, (IEntitySelector)DarkMageEntitySelector.instance));
    }

    public int func_70658_aO() {
        return 5;
    }

    protected float MovementSpeed() {
        return 0.4f;
    }

    protected float ActionSpeed() {
        return 0.5f;
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1 && this.func_70681_au().nextDouble() < 0.2) {
            for (int j = 0; j < this.func_70681_au().nextInt(3); ++j) {
                this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.rune, 1, this.func_70681_au().nextInt(16)), 0.0f);
            }
        }
        if (par1 && this.func_70681_au().nextDouble() < 0.2) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.spellParchment, 1, 0), 0.0f);
        }
        if (par1 && this.func_70681_au().nextDouble() < 0.05) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.spellBook, 1, 0), 0.0f);
        }
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.hasUpdated = true;
        ExtendedProperties.For((EntityLivingBase)this).forceSync();
        this.field_70180_af.func_75692_b(20, (Object)par1nbtTagCompound.func_74762_e("am2_dm_skin"));
        this.field_70180_af.func_75692_b(21, (Object)par1nbtTagCompound.func_74762_e("am2_dm_book"));
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("am2_dm_skin", this.field_70180_af.func_75679_c(20));
        par1nbtTagCompound.func_74768_a("am2_dm_book", this.field_70180_af.func_75679_c(21));
    }

    private int getAverageNearbyPlayerMagicLevel() {
        if (this.field_70170_p == null) {
            return 0;
        }
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 250.0), (double)0.0, (double)(this.field_70161_v - 250.0), (double)(this.field_70165_t + 250.0), (double)250.0, (double)(this.field_70161_v + 250.0)));
        if (players.size() == 0) {
            return 0;
        }
        int avgLvl = 0;
        for (EntityPlayer player : players) {
            avgLvl += ExtendedProperties.For((EntityLivingBase)player).getMagicLevel();
        }
        return (int)Math.ceil(avgLvl / players.size());
    }

    public boolean func_70601_bi() {
        if (!SpawnBlacklists.entityCanSpawnHere(this.field_70165_t, this.field_70161_v, this.field_70170_p, (EntityLivingBase)this)) {
            return false;
        }
        if (this.getAverageNearbyPlayerMagicLevel() < 8) {
            return false;
        }
        ExtendedProperties.For((EntityLivingBase)this).setMagicLevelWithMana(5);
        int avgLevel = this.getAverageNearbyPlayerMagicLevel();
        if (avgLevel == 0) {
            if (this.field_70146_Z.nextInt(100) < 10) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRangedAttackSpell((EntityCreature)this, this.MovementSpeed(), 80, NPCSpells.instance.darkMage_NormalAttack));
                this.field_70180_af.func_75692_b(21, (Object)1);
            }
        } else {
            int levelRand = this.field_70146_Z.nextInt(avgLevel * 2);
            if (levelRand > 60) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRangedAttackSpell((EntityCreature)this, this.MovementSpeed(), 160, NPCSpells.instance.darkMage_AugmentedAttack));
                this.field_70180_af.func_75692_b(21, (Object)2);
            } else if (levelRand > 30) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRangedAttackSpell((EntityCreature)this, this.MovementSpeed(), 80, NPCSpells.instance.darkMage_NormalAttack));
                this.field_70180_af.func_75692_b(21, (Object)1);
            }
        }
        ExtendedProperties.For((EntityLivingBase)this).setFullSync();
        this.hasUpdated = true;
        return super.func_70601_bi();
    }

    protected void func_70600_l(int par1) {
    }

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        return ResourceManager.getMobTexturePath(String.format("dark_mages/dark_mage_%d.png", this.field_70180_af.func_75679_c(20)));
    }
}

