/*
 * Decompiled with CFR 0.152.
 */
package am2.lore;

import am2.AMCore;
import am2.LogHelper;
import am2.api.ILoreHelper;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.items.ItemsCommonProxy;
import am2.lore.CompendiumEntry;
import am2.lore.CompendiumEntryBlock;
import am2.lore.CompendiumEntryItem;
import am2.lore.CompendiumEntryMob;
import am2.lore.CompendiumEntrySpellComponent;
import am2.lore.CompendiumEntrySpellModifier;
import am2.lore.CompendiumEntrySpellShape;
import am2.lore.CompendiumEntryType;
import am2.lore.CompendiumEntryTypes;
import am2.playerextensions.ExtendedProperties;
import am2.proxy.tick.ClientTickHandler;
import am2.utility.WebRequestUtils;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.MissingResourceException;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.Language;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SideOnly(value=Side.CLIENT)
public class ArcaneCompendium
implements ILoreHelper {
    public static final ArcaneCompendium instance = new ArcaneCompendium();
    public static final String KEYWORD_NEWPAGE = "!p";
    public static final String KEYWORD_NEWLINE = "!l";
    public static final String KEYWORD_DOUBLENEWLINE = "!d";
    public static Achievement compendiumData = new Achievement("am2_ach_data", "compendiumData", 0, 0, (Item)ItemsCommonProxy.arcaneCompendium, null);
    public static Achievement componentUnlock = new Achievement("am2_ach_unlock", "componentUnlock", 0, 0, (Item)ItemsCommonProxy.spellParchment, null);
    private final TreeMap<String, CompendiumEntry> compendium = new TreeMap();
    private final TreeMap<String, String> aliases = new TreeMap();
    private final TreeMap<String, String> zeroItemTexts = new TreeMap();
    private String saveFileLocation;
    private String updatesFolderLocation;
    private boolean hasLoaded = false;
    private boolean forcePackagedCompendium = false;
    private String languageCode = "";
    private String MCVersion = "";
    private String modVersion = "";
    private String compendiumVersion = "";
    private String latestModVersion = "";
    private String latestDownloadLink = "";
    private String latestPatchNotesLink = "";
    private boolean modUpdateAvailable = false;

    private ArcaneCompendium() {
    }

    public void setSaveLocation(String saveFileLocation) {
        this.saveFileLocation = saveFileLocation + File.separatorChar + "compendiumunlocks";
        this.updatesFolderLocation = saveFileLocation + File.separatorChar + "compendiumUpdates";
        try {
            File file = new File(this.saveFileLocation);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!(file = new File(this.updatesFolderLocation)).exists()) {
                file.mkdirs();
            }
        }
        catch (Throwable t) {
            LogHelper.error("Could not create save location!", new Object[0]);
            t.printStackTrace();
        }
    }

    private String getWorldName() {
        if (ClientTickHandler.worldName == null) {
            return null;
        }
        return ClientTickHandler.worldName.replaceAll("[^\\x00-\\x7F]", "");
    }

    public void saveUnlockData() {
        if (!this.hasLoaded) {
            return;
        }
        if (this.saveFileLocation != null && this.getWorldName() != null) {
            try {
                File file = new File(this.saveFileLocation + File.separatorChar + this.getWorldName() + ".txt");
                if (!file.exists()) {
                    file.createNewFile();
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                for (CompendiumEntry entry : this.compendium.values()) {
                    String id = entry.getID() + "|U";
                    if (entry.isLocked) {
                        id = id + "L";
                    }
                    if (entry.isNew) {
                        id = id + "N";
                    }
                    writer.write(id + "\n");
                }
                writer.close();
            }
            catch (IOException e) {
                LogHelper.error("Compendium unlock state failed to save!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void loadUnlockData() {
        if (!AMCore.config.stagedCompendium()) {
            for (CompendiumEntry entry : this.compendium.values()) {
                entry.isLocked = false;
                entry.isNew = false;
            }
            return;
        }
        if (this.saveFileLocation != null && this.getWorldName() != null) {
            try {
                String s;
                this.hasLoaded = true;
                File file = new File(this.saveFileLocation + File.separatorChar + this.getWorldName() + ".txt");
                if (!file.exists()) {
                    LogHelper.info("Compendium unlock state not found to load.  Assuming it hasn't been created yet.", new Object[0]);
                    return;
                }
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((s = reader.readLine()) != null) {
                    CompendiumEntry entry;
                    String[] split = s.trim().replace("\n", "").replace("\r", "").split("\\|");
                    if (split.length != 2 || (entry = this.getEntryAbsolute(split[0])) == null) continue;
                    entry.isLocked = split[1].contains("L");
                    entry.isNew = split[1].contains("N");
                }
                reader.close();
            }
            catch (IOException e) {
                LogHelper.error("Compendium unlock state failed to load!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void addAlias(String alias, String baseItem) {
        this.aliases.put(alias, baseItem);
    }

    public void init(Language lang) {
        if (lang == null) {
            LogHelper.error("Got a current language of NULL from Minecraft?!?  The compendium cannot load!", new Object[0]);
            return;
        }
        this.MCVersion = (String)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"field_110447_Z", "launchedVersion"});
        this.languageCode = lang.func_135034_a().trim();
        this.modVersion = AMCore.instance.getVersion();
        this.compendium.clear();
        this.aliases.clear();
        this.zeroItemTexts.clear();
        if (AMCore.config.allowVersionChecks()) {
            this.checkForModUpdates();
        } else {
            LogHelper.info("Skipping version check due to config", new Object[0]);
        }
        this.loadDocumentVersion(lang);
        if (AMCore.config.allowCompendiumUpdates()) {
            this.updateCompendium(lang);
        } else {
            LogHelper.info("Skipping Compendium auto-update due to config", new Object[0]);
        }
        InputStream stream = this.getCompendium(lang);
        if (stream == null) {
            LogHelper.error("Unable to load the Arcane Compendium!", new Object[0]);
            return;
        }
        this.loadDocument(stream);
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean updateCompendium(Language lang) {
        if (!AMCore.config.allowCompendiumUpdates()) {
            return false;
        }
        try {
            String[] lines;
            String txt = WebRequestUtils.sendPost("http://arcanacraft.qorconcept.com/mc/CompendiumVersioning.txt", new HashMap<String, String>());
            for (String s : lines = txt.replace("\r\n", "\n").split("\n")) {
                String[] sections;
                if (s.startsWith("#") || !(sections = s.split("\\|"))[1].trim().equalsIgnoreCase(this.languageCode) || !this.MCVersion.startsWith(sections[0].trim()) || this.versionCompare(sections[2], this.compendiumVersion) <= 0 || !this.modVersion.startsWith(sections[3])) continue;
                String compendiumFileName = "ArcaneCompendium_" + lang.func_135034_a() + ".xml";
                String compendiumData = WebRequestUtils.sendPost("http://arcanacraft.qorconcept.com/mc/" + this.MCVersion + "/" + compendiumFileName, new HashMap<String, String>());
                this.saveCompendiumData(compendiumData, compendiumFileName);
                LogHelper.info("Updated Compendium", new Object[0]);
                return true;
            }
        }
        catch (Throwable t) {
            LogHelper.warn("Unable to update the compendium!", new Object[0]);
            t.printStackTrace();
        }
        return false;
    }

    private void checkForModUpdates() {
        try {
            String[] lines;
            LogHelper.info("Checking Version.  MC Version: %s", this.MCVersion);
            this.latestModVersion = this.modVersion;
            String txt = WebRequestUtils.sendPost("http://arcanacraft.qorconcept.com/mc/AM2Versioning.txt", new HashMap<String, String>());
            for (String s : lines = txt.replace("\r\n", "\n").split("\n")) {
                String[] sections;
                if (s.startsWith("#") || !this.MCVersion.startsWith((sections = s.split("\\|"))[0].trim())) continue;
                if (this.versionCompare(sections[1], this.latestModVersion) > 0) {
                    LogHelper.info("An update is available.  Version %s is released, detected local version of %s.", this.modVersion, sections[1]);
                    this.latestModVersion = sections[1];
                    this.latestDownloadLink = sections.length >= 3 ? sections[2] : "";
                    this.latestPatchNotesLink = sections.length >= 4 ? sections[3] : "";
                    this.modUpdateAvailable = true;
                    continue;
                }
                LogHelper.info("You are running the latest version of AM2.  Latest Released Version: %s.  Your Version: %s.", this.latestModVersion, this.modVersion);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void saveCompendiumData(String compendium, String fileName) throws Exception {
        if (compendium == null) {
            throw new Exception("No compendium data received");
        }
        String path = this.updatesFolderLocation + File.separatorChar + this.MCVersion + File.separatorChar + this.modVersion;
        File dirPath = new File(path);
        if (!dirPath.exists()) {
            dirPath.mkdirs();
        }
        File f = new File(path + File.separatorChar + fileName);
        FileUtils.writeStringToFile((File)f, (String)compendium);
    }

    public CompendiumEntry getEntry(String key) {
        if (this.aliases.containsKey(key)) {
            CompendiumEntry aliased = this.compendium.get(this.aliases.get(key));
            if (aliased.hasSubItems()) {
                for (CompendiumEntry sub : aliased.getSubItems()) {
                    if (!sub.getID().equals(key)) continue;
                    return sub;
                }
            }
            return aliased;
        }
        return this.compendium.get(key);
    }

    public CompendiumEntry getEntryAbsolute(String key) {
        return this.compendium.get(key);
    }

    public String getZeroItemText(String category) {
        String s = this.zeroItemTexts.get(category);
        return s != null ? s : "";
    }

    private void loadDocument(InputStream stream) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(stream);
            Node parentNode = document.getChildNodes().item(0);
            NodeList categories = parentNode.getChildNodes();
            for (int i = 0; i < categories.getLength(); ++i) {
                Node zeroItemText;
                Node category = categories.item(i);
                if (category.getNodeName().equals("version")) {
                    this.compendiumVersion = category.getTextContent();
                    continue;
                }
                if (category.getAttributes() != null && (zeroItemText = category.getAttributes().getNamedItem("zeroItemText")) != null) {
                    this.zeroItemTexts.put(category.getNodeName(), zeroItemText.getTextContent());
                }
                NodeList entries = category.getChildNodes();
                for (int j = 0; j < entries.getLength(); ++j) {
                    CompendiumEntry ce;
                    Node entry = entries.item(j);
                    CompendiumEntryType type = CompendiumEntryTypes.getForSection(category.getNodeName(), entry.getNodeName());
                    if (type == null || (ce = type.createCompendiumEntry(entry)) == null) continue;
                    this.compendium.put(ce.getID(), ce);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void loadDocumentVersion(Language lang) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            Node category;
            int i;
            InputStream stream = this.getPackagedCompendium(lang);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(stream);
            Node parentNode = document.getChildNodes().item(0);
            NodeList categories = parentNode.getChildNodes();
            for (i = 0; i < categories.getLength(); ++i) {
                category = categories.item(i);
                if (!category.getNodeName().equals("version")) continue;
                this.compendiumVersion = category.getTextContent();
                break;
            }
            stream.close();
            stream = this.getCompendium(lang);
            db = dbf.newDocumentBuilder();
            document = db.parse(stream);
            parentNode = document.getChildNodes().item(0);
            categories = parentNode.getChildNodes();
            for (i = 0; i < categories.getLength(); ++i) {
                category = categories.item(i);
                if (!category.getNodeName().equals("version")) continue;
                String altVersion = category.getTextContent();
                if (this.versionCompare(altVersion, this.compendiumVersion) > 0) {
                    this.compendiumVersion = altVersion;
                    break;
                }
                this.forcePackagedCompendium = true;
                break;
            }
            stream.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    private String getUpdatedPath() {
        String compendiumFileName = "ArcaneCompendium_" + this.languageCode + ".xml";
        return this.updatesFolderLocation + File.separatorChar + this.MCVersion + File.separatorChar + AMCore.instance.getVersion() + File.separatorChar + compendiumFileName;
    }

    private InputStream getCompendium(Language lang) {
        if (!this.forcePackagedCompendium) {
            String path = this.getUpdatedPath();
            try {
                File f = new File(path);
                if (f.exists()) {
                    return new FileInputStream(f);
                }
            }
            catch (Throwable t) {
                LogHelper.trace("An error occurred when trying to create an inputstream from the updated compendium.  Reverting to default.", new Object[0]);
            }
            LogHelper.info("No updated compendium found.  Using packaged compendium.", new Object[0]);
        }
        return this.getPackagedCompendium(lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getPackagedCompendium(Language lang) {
        ResourceLocation rLoc = new ResourceLocation("arsmagica2", String.format("docs/ArcaneCompendium_%s.xml", lang.func_135034_a()));
        IResource resource = null;
        try {
            resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(rLoc);
        }
        catch (IOException iOException) {
        }
        finally {
            if (resource == null) {
                LogHelper.info("Unable to find localized compendium.  Defaulting to en_US", new Object[0]);
                rLoc = new ResourceLocation("arsmagica2", "docs/ArcaneCompendium_en_US.xml");
                try {
                    resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(rLoc);
                }
                catch (IOException iOException) {}
            }
        }
        if (resource != null) {
            return resource.func_110527_b();
        }
        throw new MissingResourceException("No packaged version of the compendium was found.  You may have a corrupted download.", "compendium", "Arcane Compendium");
    }

    public LinkedHashSet<CompendiumEntryType> getCategories() {
        LinkedHashSet<CompendiumEntryType> toReturn = new LinkedHashSet<CompendiumEntryType>();
        for (CompendiumEntryType type : CompendiumEntryTypes.categoryList()) {
            toReturn.add(type);
        }
        return toReturn;
    }

    public ArrayList<CompendiumEntry> getEntriesForCategory(String category) {
        ArrayList<CompendiumEntry> toReturn = new ArrayList<CompendiumEntry>();
        for (CompendiumEntry entry : this.compendium.values()) {
            if (!entry.type.getCategoryName().equals(category)) continue;
            toReturn.add(entry);
        }
        Collections.sort(toReturn);
        return toReturn;
    }

    private void unlockEntry(CompendiumEntry entry, boolean unlockRelated) {
        if (unlockRelated) {
            for (CompendiumEntry e : entry.getRelatedItems()) {
                this.unlockEntry(e, false);
            }
            for (CompendiumEntry e : entry.getSubItems()) {
                this.unlockEntry(e, false);
            }
        }
        if (entry.isLocked()) {
            entry.setIsLocked(false);
            if (ExtendedProperties.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g).getMagicLevel() > 0) {
                Minecraft.func_71410_x().field_71458_u.func_146256_a(compendiumData);
            }
            this.saveUnlockData();
        }
    }

    public void unlockEntry(String key) {
        boolean verbose = key.startsWith("cmd::");
        key = key.replace("cmd::", "");
        if (verbose && key.equals("all")) {
            for (CompendiumEntry entry : this.compendium.values()) {
                entry.setIsLocked(false);
            }
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.unlockSuccess")));
            return;
        }
        CompendiumEntry entry = this.getEntry(key);
        if (entry == null) {
            if (key.contains("@")) {
                entry = this.getEntry(key.split("@")[0]);
            }
            if (entry == null) {
                LogHelper.warn("Attempted to unlock a compendium entry for a non-existant key: " + key, new Object[0]);
                if (verbose) {
                    String message = String.format(StatCollector.func_74838_a((String)"am2.tooltip.compEntryNotFound"), key);
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(message));
                }
                return;
            }
        }
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        if (entry.isLocked) {
            this.unlockEntry(entry, true);
            if (verbose) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("am2.tooltip.unlockSuccess"));
            }
        }
    }

    public void unlockCategory(String category) {
        for (CompendiumEntry entry : this.compendium.values()) {
            if (!entry.type.getCategoryName().equals(category)) continue;
            this.unlockEntry(entry, false);
        }
    }

    public void unlockRelatedItems(ItemStack stack) {
        if (stack == null) {
            return;
        }
        CompendiumEntry entry = null;
        String itemID = "";
        if (stack.func_77973_b().func_77658_a() == null) {
            return;
        }
        if (stack.func_77973_b() instanceof Item) {
            itemID = stack.func_77973_b().func_77658_a().replace("item.", "").replace("arsmagica2:", "");
        } else if (stack.func_77973_b() instanceof ItemBlock) {
            itemID = stack.func_77973_b().func_77658_a().replace("arsmagica2:", "").replace("tile.", "");
        }
        if (stack.func_77960_j() > -1) {
            itemID = itemID + "@" + stack.func_77960_j();
        }
        if ((entry = this.getEntry(itemID)) != null) {
            this.unlockEntry(entry, true);
        }
    }

    public void setLockedState(boolean b) {
        for (CompendiumEntry entry : this.compendium.values()) {
            entry.setIsLocked(b);
        }
    }

    public boolean isCategory(String id) {
        for (CompendiumEntryType type : this.getCategories()) {
            if (!type.getCategoryName().equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isModUpdateAvailable() {
        return this.modUpdateAvailable;
    }

    public String getModDownloadLink() {
        return this.latestDownloadLink;
    }

    public String getPatchNotesLink() {
        return this.latestPatchNotesLink;
    }

    @Override
    public void AddCompenidumEntry(Object entryItem, String entryKey, String entryName, String entryDesc, String parent, boolean allowReplace, String ... relatedKeys) {
        CompendiumEntry parentEntry;
        if (entryItem == null) {
            LogHelper.warn("Null entry item passed.  Cannot add Compendium Entry with key %s.", entryKey);
            return;
        }
        CompendiumEntry existingEntry = this.getEntry(entryKey);
        if (existingEntry != null && !allowReplace) {
            LogHelper.warn("Compendium entry with key %s exists, and allowReplace is false.  The entry was not added.", entryKey);
            return;
        }
        CompendiumEntry compendiumEntry = parentEntry = parent == null ? null : this.getEntry(parent);
        if (parent != null && parentEntry == null) {
            LogHelper.warn("The parent ID %s was not found.  Entry %s will be added with no parent.", parent, entryKey);
        }
        CompendiumEntry newEntry = null;
        if (entryItem instanceof Item) {
            newEntry = new CompendiumEntryItem();
        } else if (entryItem instanceof Block) {
            newEntry = new CompendiumEntryBlock();
        } else if (entryItem instanceof ISpellShape) {
            newEntry = new CompendiumEntrySpellShape();
        } else if (entryItem instanceof ISpellComponent) {
            newEntry = new CompendiumEntrySpellComponent();
        } else if (entryItem instanceof ISpellModifier) {
            newEntry = new CompendiumEntrySpellModifier();
        } else if (entryItem instanceof Entity) {
            newEntry = new CompendiumEntryMob();
        }
        newEntry.id = entryKey;
        newEntry.name = entryName;
        newEntry.description = entryDesc;
        newEntry.isLocked = true;
        newEntry.isNew = true;
        newEntry.parent = parentEntry;
        for (String s : relatedKeys) {
            newEntry.relatedItems.add(s);
        }
        if (parentEntry != null) {
            parentEntry.subItems.add(newEntry);
            this.addAlias(newEntry.getID(), parentEntry.getID());
        }
        this.compendium.put(entryKey, newEntry);
        LogHelper.debug("Successfully added compendium entry %s", entryKey);
    }
}

