/*
 * Decompiled with CFR 0.152.
 */
package am2.preloader;

import am2.LogHelper;
import com.google.common.eventbus.EventBus;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.File;
import java.util.Arrays;
import java.util.Map;

public class AM2PreloaderContainer
extends DummyModContainer
implements IFMLLoadingPlugin {
    private final String[] asmTransformers = new String[]{"am2.preloader.AccessTransformers", "am2.preloader.BytecodeTransformers"};
    private final ModMetadata md = new ModMetadata();
    public static boolean foundThaumcraft = false;
    private static boolean foundOptiFine = false;
    private static boolean confirmedOptiFine = false;
    public static boolean foundDragonAPI = false;
    public static boolean isDevEnvironment = false;

    public AM2PreloaderContainer() {
        LogHelper.info("Core initializing...stand back!  I'm going to try MAGIC!", new Object[0]);
        this.md.autogenerated = true;
        this.md.credits = "Mithion, AlgorithmX2, Sunstrike";
        this.md.modId = this.getModId();
        this.md.version = this.getVersion();
        this.md.name = this.getName();
        this.md.authorList = Arrays.asList("Mithion", "AlgorithmX2", "Sunstrike");
    }

    public String getModId() {
        return "AM2-Preloader";
    }

    public String getName() {
        return "AMCore";
    }

    public String getVersion() {
        return "0.0.3";
    }

    public String getDisplayVersion() {
        return this.getVersion();
    }

    public ModMetadata getMetadata() {
        return this.md;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public String[] getASMTransformerClass() {
        return this.asmTransformers;
    }

    public String getModContainerClass() {
        return "am2.preloader.AM2PreloaderContainer";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        File[] subfiles;
        File loc = (File)data.get("mcLocation");
        LogHelper.trace("MC located at: " + loc.getAbsolutePath(), new Object[0]);
        isDevEnvironment = (Boolean)data.get("runtimeDeobfuscationEnabled") == false;
        File mcFolder = new File(loc.getAbsolutePath() + File.separatorChar + "mods");
        for (File file : subfiles = mcFolder.listFiles()) {
            String name = file.getName();
            if (name == null || !(name = name.toLowerCase()).endsWith(".jar") && !name.endsWith(".zip")) continue;
            if (name.contains("thaumcraft")) {
                LogHelper.info("Core: Located Thaumcraft in " + file.getName(), new Object[0]);
                foundThaumcraft = true;
                continue;
            }
            if (name.contains("optifine")) {
                LogHelper.info("Core: Located OptiFine in " + file.getName() + ". We'll to confirm that...", new Object[0]);
                foundOptiFine = true;
                continue;
            }
            if (!name.contains("dragonapi")) continue;
            LogHelper.info("Core: Located DragonAPI in " + file.getName(), new Object[0]);
            foundDragonAPI = true;
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public static boolean isOptiFinePresent() {
        if (!confirmedOptiFine && foundOptiFine) {
            try {
                Class.forName("optifine.OptiFineForgeTweaker");
            }
            catch (ClassNotFoundException exception1) {
                try {
                    Class.forName("optifine.OptiFineTweaker");
                }
                catch (ClassNotFoundException exception2) {
                    foundOptiFine = false;
                }
            }
            if (foundOptiFine) {
                LogHelper.info("Core: OptiFine presence has been confirmed.", new Object[0]);
            } else {
                LogHelper.info("Core: OptiFine doesn't seem to be there actually.", new Object[0]);
            }
            confirmedOptiFine = true;
        }
        return foundOptiFine;
    }
}

