/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.blocks.IKeystoneLockable;
import am2.api.items.KeystoneAccessType;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SpellUtils;
import am2.utility.DummyEntityPlayer;
import am2.utility.KeystoneUtilities;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;

public class Dig
implements ISpellComponent {
    private static final float hardnessManaFactor = 1.28f;
    private ArrayList<Block> disallowedBlocks = new ArrayList();

    public Dig() {
        this.disallowedBlocks.add(Blocks.field_150357_h);
        this.disallowedBlocks.add(Blocks.field_150483_bI);
        this.disallowedBlocks.add((Block)BlocksCommonProxy.everstone);
        for (String i : AMCore.config.getDigBlacklist()) {
            if (i == null || i == "") continue;
            this.disallowedBlocks.add(Block.func_149684_b((String)i.replace("tile.", "")));
        }
    }

    public void addDisallowedBlock(String block) {
        this.disallowedBlocks.add(Block.func_149684_b((String)block));
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        int miningLevel;
        Block block = world.func_147439_a(blockx, blocky, blockz);
        if (block == Blocks.field_150350_a) {
            return false;
        }
        TileEntity te = world.func_147438_o(blockx, blocky, blockz);
        if (te != null) {
            if (!AMCore.config.getDigBreaksTileEntities()) {
                return false;
            }
            if (te instanceof IKeystoneLockable && !KeystoneUtilities.instance.canPlayerAccess((IKeystoneLockable)te, DummyEntityPlayer.fromEntityLiving(caster), KeystoneAccessType.BREAK)) {
                return false;
            }
        }
        if (this.disallowedBlocks.contains(block)) {
            return false;
        }
        if (block.func_149712_f(world, blockx, blocky, blockz) == -1.0f) {
            return false;
        }
        int meta = world.func_72805_g(blockx, blocky, blockz);
        int harvestLevel = block.getHarvestLevel(meta);
        if (harvestLevel > (miningLevel = 2 + SpellUtils.instance.countModifiers(SpellModifiers.MINING_POWER, stack, 0))) {
            return false;
        }
        EntityPlayer casterPlayer = DummyEntityPlayer.fromEntityLiving(caster);
        if (ForgeEventFactory.doPlayerHarvestCheck((EntityPlayer)casterPlayer, (Block)block, (boolean)true)) {
            float xMana = block.func_149712_f(world, blockx, blocky, blockz) * 1.28f;
            float xBurnout = ArsMagicaApi.getBurnoutFromMana(xMana);
            if (!world.field_72995_K) {
                BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)((EntityPlayerMP)casterPlayer).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)casterPlayer), (int)blockx, (int)blocky, (int)blockz);
                if (event.isCanceled()) {
                    return false;
                }
                block.func_149681_a(world, blockx, blocky, blockz, meta, casterPlayer);
                boolean flag = block.removedByPlayer(world, casterPlayer, blockx, blocky, blockz, true);
                if (flag) {
                    block.func_149664_b(world, blockx, blocky, blockz, meta);
                    block.func_149636_a(world, casterPlayer, blockx, blocky, blockz, meta);
                }
            }
            ExtendedProperties.For(caster).deductMana(xMana);
            ExtendedProperties.For(caster).addBurnout(xBurnout);
            return true;
        }
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 10.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 10.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.EARTH);
    }

    @Override
    public int getID() {
        return 8;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 11);
        objectArray[1] = Items.field_151037_a;
        objectArray[2] = Items.field_151035_b;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.001f;
    }
}

