/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.renderers;

import am2.AMCore;
import am2.blocks.BlockBrokenPowerLink;
import am2.blocks.BlockInlay;
import am2.blocks.BlocksClientProxy;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.tileentities.TileEntityEverstone;
import am2.blocks.tileentities.TileEntityManaBattery;
import am2.guis.GuiBlockAccess;
import am2.items.ItemsCommonProxy;
import am2.models.ModelCandle;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class SimpleBlockRenderHandler
implements ISimpleBlockRenderingHandler {
    GuiBlockAccess blockAccess = new GuiBlockAccess();
    ModelCandle modelCandle = new ModelCandle();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean isInlay = block instanceof BlockInlay;
        block.func_149683_g();
        renderer.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (isInlay) {
            GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
        }
        try {
            tessellator.func_78382_b();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
        try {
            tessellator.func_78381_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!isInlay) {
            if (block == BlocksCommonProxy.craftingAltar) {
                this.renderStandardBlock(block, 0, renderer);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                this.renderStandardBlock(block, 1, renderer);
                GL11.glDisable((int)3042);
            } else {
                this.renderStandardBlock(block, metadata, renderer);
            }
        }
    }

    private void renderStandardBlock(Block block, int metadata, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        try {
            tessellator.func_78382_b();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata));
        try {
            tessellator.func_78381_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tessellator.func_78382_b();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
        try {
            tessellator.func_78381_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tessellator.func_78382_b();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata));
        try {
            tessellator.func_78381_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tessellator.func_78382_b();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata));
        try {
            tessellator.func_78381_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tessellator.func_78382_b();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata));
        try {
            tessellator.func_78381_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tessellator.func_78382_b();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata));
        try {
            tessellator.func_78381_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void renderWizardChalk(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int meta = world.func_72805_g(x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78378_d(0xFFFFFF);
        tessellator.func_78380_c(0xF000E0);
        IIcon par8Icon = BlocksCommonProxy.wizardChalk.func_149691_a(1, meta);
        double d3 = par8Icon.func_94214_a(renderer.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(renderer.field_147851_l * 16.0);
        double d6 = par8Icon.func_94207_b(renderer.field_147853_m * 16.0);
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        double d11 = (double)x + renderer.field_147859_h;
        double d12 = (double)x + renderer.field_147861_i;
        double d13 = (double)y + renderer.field_147857_k;
        double d14 = (double)z + renderer.field_147851_l;
        double d15 = (double)z + renderer.field_147853_m;
        tessellator.func_78374_a(d12, d13, d15, d4, d6);
        tessellator.func_78374_a(d12, d13, d14, d7, d9);
        tessellator.func_78374_a(d11, d13, d14, d3, d5);
        tessellator.func_78374_a(d11, d13, d15, d8, d10);
    }

    private void renderCraftingAltar(Block block, Block mimic, int x, int y, int z, int metadata, RenderBlocks renderer) {
        IIcon icon = mimic.func_149691_a(1, metadata);
        if (icon == null) {
            icon = block.func_149691_a(1, 0);
        }
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, icon);
        icon = mimic.func_149691_a(0, metadata);
        if (icon == null) {
            icon = block.func_149691_a(0, 0);
        }
        renderer.func_147768_a(block, (double)x, (double)y, (double)z, icon);
        icon = mimic.func_149691_a(2, metadata);
        if (icon == null) {
            icon = block.func_149691_a(2, 0);
        }
        renderer.func_147764_f(block, (double)x, (double)y, (double)z, icon);
        icon = mimic.func_149691_a(3, metadata);
        if (icon == null) {
            icon = block.func_149691_a(3, 0);
        }
        renderer.func_147798_e(block, (double)x, (double)y, (double)z, icon);
        icon = mimic.func_149691_a(4, metadata);
        if (icon == null) {
            icon = block.func_149691_a(4, 0);
        }
        renderer.func_147734_d(block, (double)x, (double)y, (double)z, icon);
        icon = mimic.func_149691_a(5, metadata);
        if (icon == null) {
            icon = block.func_149691_a(5, 0);
        }
        renderer.func_147761_c(block, (double)x, (double)y, (double)z, icon);
        renderer.func_147806_b(block, (double)x, (double)y, (double)z, block.func_149691_a(1, 1));
        renderer.func_147768_a(block, (double)x, (double)y, (double)z, block.func_149691_a(0, 1));
        renderer.func_147764_f(block, (double)x, (double)y, (double)z, block.func_149691_a(2, 1));
        renderer.func_147798_e(block, (double)x, (double)y, (double)z, block.func_149691_a(3, 1));
        renderer.func_147734_d(block, (double)x, (double)y, (double)z, block.func_149691_a(4, 1));
        renderer.func_147761_c(block, (double)x, (double)y, (double)z, block.func_149691_a(5, 1));
    }

    private void renderBlock(Block block, int meta, RenderBlocks renderer) {
        if (meta < 0) {
            meta = 0;
        }
        if (meta > 15) {
            meta = 15;
        }
        GL11.glPushMatrix();
        this.blockAccess.setFakeBlockAndMeta(block, meta);
        renderer.field_147837_f = true;
        if (block.func_149645_b() == BlocksCommonProxy.blockRenderID) {
            renderer.field_147844_c = false;
            this.RenderInlayBlock(this.blockAccess, 0, 0, 0, block, 0, renderer);
        } else if (block == BlocksCommonProxy.everstone) {
            renderer.field_147844_c = false;
            this.renderEverstoneBlock(this.blockAccess, 0, 0, 0, block, 0, renderer);
        }
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (block == BlocksCommonProxy.wizardChalk) {
            this.renderWizardChalk(world, x, y, z, block, modelId, renderer);
            return true;
        }
        if (block instanceof BlockInlay) {
            this.RenderInlayBlock(world, x, y, z, block, modelId, renderer);
            return true;
        }
        if (block == BlocksCommonProxy.everstone) {
            this.renderEverstoneBlock(world, x, y, z, block, modelId, renderer);
            return true;
        }
        if (block == BlocksCommonProxy.craftingAltar) {
            Block mimic = BlocksCommonProxy.craftingAltar.getAltarMimicBlock(world, x, y, z);
            this.renderCraftingAltar(block, mimic, x, y, z, world.func_72805_g(x, y, z), renderer);
        } else if (block == BlocksCommonProxy.manaBattery) {
            this.renderManaBattery(world, x, y, z, block, modelId, renderer);
        } else if (block == BlocksCommonProxy.brokenLinkBlock) {
            this.RenderBrokenPowerLink(renderer, x, y, z);
            return true;
        }
        return false;
    }

    private void RenderBrokenPowerLink(RenderBlocks renderer, int x, int y, int z) {
        EntityPlayer player = AMCore.proxy.getLocalPlayer();
        if (x == 0 && y == 0 && z == 0 || player != null && player.func_82169_q(3) != null && player.func_82169_q(3).func_77973_b() == ItemsCommonProxy.magitechGoggles) {
            BlockBrokenPowerLink block = BlocksCommonProxy.brokenLinkBlock;
            renderer.field_147840_d = block.func_149691_a(0, 0);
            renderer.func_147784_q((Block)block, x, y, z);
            renderer.field_147840_d = null;
        }
    }

    private void RenderInlayBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = world != null ? world.func_72805_g(x, y, z) : 0;
        IIcon renderIcon = block.func_149691_a(0, meta);
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
        switch (meta) {
            case 0: {
                break;
            }
            case 1: {
                renderer.field_147867_u = 2;
                renderer.field_147865_v = 2;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                renderer.field_147867_u = 1;
                renderer.field_147865_v = 2;
                break;
            }
            case 8: {
                renderer.field_147867_u = 3;
                renderer.field_147865_v = 3;
                break;
            }
            case 9: {
                renderer.field_147867_u = 2;
                renderer.field_147865_v = 1;
            }
        }
        renderer.field_147840_d = renderIcon;
        renderer.func_147784_q(block, x, y, z);
        renderer.field_147840_d = null;
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
    }

    private void renderEverstoneBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (world == null) {
            return;
        }
        if (block == null) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TileEntityEverstone te = (TileEntityEverstone)Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z);
        if (te != null) {
            Block fBlock = te.getFacade();
            if (fBlock != null) {
                if (te.isSolid()) {
                    IBlockAccess old = renderer.field_147845_a;
                    renderer.field_147845_a = this.blockAccess;
                    this.blockAccess.setControllingTileEntity(te);
                    this.blockAccess.setFakeBlockAndMeta(te.getFacade(), te.getFacadeMeta());
                    this.blockAccess.setOuterBlockAccess(world);
                    this.blockAccess.setOverrideCoords(x, y, z);
                    renderer.func_147784_q(fBlock, x, y, z);
                    this.blockAccess.setOuterBlockAccess(null);
                    renderer.field_147845_a = old;
                } else {
                    Tessellator.field_78398_a.func_78370_a(te.getFadeStrength(), te.getFadeStrength(), te.getFadeStrength(), te.getFadeStrength());
                    renderer.func_147806_b(block, (double)x, (double)y, (double)z, fBlock.func_149691_a(1, te.getFacadeMeta()));
                    renderer.func_147768_a(block, (double)x, (double)y, (double)z, fBlock.func_149691_a(0, te.getFacadeMeta()));
                    renderer.func_147764_f(block, (double)x, (double)y, (double)z, fBlock.func_149691_a(2, te.getFacadeMeta()));
                    renderer.func_147798_e(block, (double)x, (double)y, (double)z, fBlock.func_149691_a(3, te.getFacadeMeta()));
                    renderer.func_147734_d(block, (double)x, (double)y, (double)z, fBlock.func_149691_a(4, te.getFacadeMeta()));
                    renderer.func_147761_c(block, (double)x, (double)y, (double)z, fBlock.func_149691_a(5, te.getFacadeMeta()));
                }
            } else {
                renderer.func_147784_q(block, x, y, z);
            }
        }
    }

    private void renderManaBattery(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TileEntityManaBattery te = (TileEntityManaBattery)world.func_147438_o(x, y, z);
        if (te != null) {
            IBlockAccess old = renderer.field_147845_a;
            renderer.field_147845_a = this.blockAccess;
            this.blockAccess.setControllingTileEntity(te);
            this.blockAccess.setFakeBlockAndMeta(BlocksCommonProxy.manaBattery, 0);
            this.blockAccess.setOuterBlockAccess(world);
            this.blockAccess.setOverrideCoords(x, y, z);
            renderer.func_147784_q(BlocksCommonProxy.manaBattery, x, y, z);
            this.blockAccess.setOuterBlockAccess(null);
            renderer.field_147845_a = old;
            Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
            renderer.func_147806_b(block, (double)x, (double)y, (double)z, BlocksCommonProxy.manaBattery.func_149691_a(1, 15));
            renderer.func_147768_a(block, (double)x, (double)y, (double)z, BlocksCommonProxy.manaBattery.func_149691_a(0, 15));
            renderer.func_147764_f(block, (double)x, (double)y, (double)z, BlocksCommonProxy.manaBattery.func_149691_a(2, 15));
            renderer.func_147798_e(block, (double)x, (double)y, (double)z, BlocksCommonProxy.manaBattery.func_149691_a(3, 15));
            renderer.func_147734_d(block, (double)x, (double)y, (double)z, BlocksCommonProxy.manaBattery.func_149691_a(4, 15));
            renderer.func_147761_c(block, (double)x, (double)y, (double)z, BlocksCommonProxy.manaBattery.func_149691_a(5, 15));
        }
    }

    public boolean shouldRender3DInInventory(int arg0) {
        return true;
    }

    public int getRenderId() {
        return BlocksClientProxy.blockRenderID;
    }
}

