/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.AMCore;
import am2.api.blocks.IKeystoneLockable;
import am2.api.events.ReconstructorRepairEvent;
import am2.api.math.AMVector3;
import am2.api.power.PowerTypes;
import am2.blocks.tileentities.TileEntityAMPower;
import am2.entities.EntityDummyCaster;
import am2.items.ItemFocusCharge;
import am2.items.ItemFocusMana;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import am2.power.PowerNodeRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityArcaneReconstructor
extends TileEntityAMPower
implements IInventory,
ISidedInventory,
IKeystoneLockable {
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private boolean active = false;
    private int repairCounter = 0;
    private static final float repairCostPerDamagePoint = 250.0f;
    private float ringOffset;
    private final AMVector3 outerRingRotation = new AMVector3(0.0, 0.0, 0.0);
    private final AMVector3 middleRingRotation = new AMVector3(0.0, 0.0, 0.0);
    private final AMVector3 innerRingRotation = new AMVector3(0.0, 0.0, 0.0);
    private float rotateOffset = 0.0f;
    private int deactivationDelayTicks = 0;
    private EntityLiving dummyEntity;
    private AMVector3 outerRingRotationSpeeds;
    private AMVector3 middleRingRotationSpeeds;
    private AMVector3 innerRingRotationSpeeds;
    private static final int SLOT_ACTIVE = 3;
    private boolean isFirstTick = true;

    public TileEntityArcaneReconstructor() {
        super(500);
    }

    @Override
    public float particleOffset(int axis) {
        if (axis == 1) {
            return 0.25f;
        }
        return 0.5f;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145845_h() {
        if (this.isFirstTick) {
            this.outerRingRotationSpeeds = new AMVector3(this.field_145850_b.field_73012_v.nextDouble() * 4.0 - 2.0, this.field_145850_b.field_73012_v.nextDouble() * 4.0 - 2.0, this.field_145850_b.field_73012_v.nextDouble() * 4.0 - 2.0);
            this.middleRingRotationSpeeds = new AMVector3(this.field_145850_b.field_73012_v.nextDouble() * 4.0 - 2.0, this.field_145850_b.field_73012_v.nextDouble() * 4.0 - 2.0, this.field_145850_b.field_73012_v.nextDouble() * 4.0 - 2.0);
            this.innerRingRotationSpeeds = new AMVector3(this.field_145850_b.field_73012_v.nextDouble() * 4.0 - 2.0, this.field_145850_b.field_73012_v.nextDouble() * 4.0 - 2.0, this.field_145850_b.field_73012_v.nextDouble() * 4.0 - 2.0);
            this.isFirstTick = false;
        }
        if (PowerNodeRegistry.For(this.field_145850_b).checkPower(this, this.getRepairCost())) {
            if (this.repairCounter++ % this.getRepairRate() == 0 && !this.queueRepairableItem() && this.performRepair() && !this.field_145850_b.field_72995_K) {
                PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), this.getRepairCost());
            }
            this.deactivationDelayTicks = 0;
        } else if (!this.field_145850_b.field_72995_K && this.active && this.deactivationDelayTicks++ > 100) {
            this.deactivationDelayTicks = 0;
            this.active = false;
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateRotations();
            if (this.shouldRenderItemStack()) {
                AMParticle p = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "sparkle2", (double)this.field_145851_c + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6, (double)this.field_145848_d + 0.4, (double)this.field_145849_e + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6));
                if (p != null) {
                    p.AddParticleController(new ParticleFloatUpward(p, 0.0f, 0.02f, 1, false));
                    p.setIgnoreMaxAge(true);
                    p.setParticleScale(0.1f);
                    p.AddParticleController(new ParticleFadeOut(p, 1, false).setFadeSpeed(0.035f).setKillParticleOnFinish(true));
                    p.setRGBColorF(1.0f, 0.0f, 1.0f);
                }
            }
        }
        super.func_145845_h();
    }

    public AMVector3 getOuterRingRotationSpeed() {
        return this.outerRingRotationSpeeds;
    }

    public AMVector3 getMiddleRingRotationSpeed() {
        return this.middleRingRotationSpeeds;
    }

    public AMVector3 getInnerRingRotationSpeed() {
        return this.innerRingRotationSpeeds;
    }

    public float getRotateOffset() {
        return this.rotateOffset;
    }

    public boolean shouldRenderRotateOffset() {
        return (double)this.ringOffset >= 0.5 && this.rotateOffset > 0.0f;
    }

    private void updateRotations() {
        if (this.active) {
            if (this.ringOffset < 0.5f) {
                this.ringOffset += 0.015f;
            } else {
                this.ringOffset = 0.51f;
                this.outerRingRotation.add(this.outerRingRotationSpeeds);
                this.middleRingRotation.add(this.middleRingRotationSpeeds);
                this.innerRingRotation.add(this.innerRingRotationSpeeds);
            }
            if (this.rotateOffset < 10.0f) {
                this.rotateOffset += 0.0625f;
            }
        } else {
            if (this.rotateOffset > 0.0f) {
                this.rotateOffset -= 0.025f;
            }
            if (!(this.outerRingRotation.isZero() && this.middleRingRotation.isZero() && this.innerRingRotation.isZero())) {
                this.outerRingRotation.x = this.easeCoordinate(this.outerRingRotation.x, this.outerRingRotationSpeeds.x);
                this.outerRingRotation.y = this.easeCoordinate(this.outerRingRotation.y, this.outerRingRotationSpeeds.y);
                this.outerRingRotation.z = this.easeCoordinate(this.outerRingRotation.z, this.outerRingRotationSpeeds.z);
                this.middleRingRotation.x = this.easeCoordinate(this.middleRingRotation.x, this.middleRingRotationSpeeds.x);
                this.middleRingRotation.y = this.easeCoordinate(this.middleRingRotation.y, this.middleRingRotationSpeeds.y);
                this.middleRingRotation.z = this.easeCoordinate(this.middleRingRotation.z, this.middleRingRotationSpeeds.z);
                this.innerRingRotation.x = this.easeCoordinate(this.innerRingRotation.x, this.innerRingRotationSpeeds.x);
                this.innerRingRotation.y = this.easeCoordinate(this.innerRingRotation.y, this.innerRingRotationSpeeds.y);
                this.innerRingRotation.z = this.easeCoordinate(this.innerRingRotation.z, this.innerRingRotationSpeeds.z);
            } else {
                this.ringOffset = this.ringOffset > 0.0f ? (this.ringOffset -= 0.03f) : 0.0f;
            }
        }
    }

    private float easeCoordinate(float coord, float step) {
        step = Math.abs(step);
        step = 4.0f;
        float calc = coord;
        if (Math.abs(coord % 360.0f) > -4.0f && Math.abs(coord % 360.0f) < 4.0f) {
            return 0.0f;
        }
        coord = calc < 0.0f ? ((calc %= -360.0f) <= -180.0f ? (coord -= step) : (coord += step)) : ((calc %= 360.0f) >= 180.0f ? (coord += step) : (coord -= step));
        return coord;
    }

    public float getOffset() {
        return this.ringOffset;
    }

    public boolean shouldRenderItemStack() {
        return this.active && (double)this.ringOffset >= 0.5;
    }

    public ItemStack getCurrentItem() {
        return this.inventory[3];
    }

    public AMVector3 getInnerRingRotation() {
        return this.innerRingRotation;
    }

    public AMVector3 getMiddleRingRotation() {
        return this.middleRingRotation;
    }

    public AMVector3 getOuterRingRotation() {
        return this.outerRingRotation;
    }

    private boolean queueRepairableItem() {
        if (this.inventory[3] != null) {
            if (!this.active) {
                this.active = true;
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            return false;
        }
        for (int i = 4; i < 10; ++i) {
            if (!this.itemStackIsValid(this.inventory[i])) continue;
            this.inventory[3] = this.inventory[i].func_77946_l();
            this.inventory[i] = null;
            this.active = true;
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        this.active = false;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    private boolean itemStackIsValid(ItemStack stack) {
        return stack != null && !(stack.func_77973_b() instanceof ItemBlock) && stack.func_77973_b().isRepairable();
    }

    private EntityLiving getDummyEntity() {
        if (this.dummyEntity == null) {
            this.dummyEntity = new EntityDummyCaster(this.field_145850_b);
        }
        return this.dummyEntity;
    }

    private boolean performRepair() {
        if (this.inventory[3] == null) {
            return false;
        }
        ReconstructorRepairEvent event = new ReconstructorRepairEvent(this.inventory[3]);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return true;
        }
        if (this.inventory[3].func_77951_h()) {
            if (!this.field_145850_b.field_72995_K) {
                this.inventory[3].func_77972_a(-1, (EntityLivingBase)this.getDummyEntity());
            }
            return true;
        }
        boolean did_copy = false;
        for (int i = 10; i < 16; ++i) {
            if (this.inventory[i] != null) continue;
            if (!this.field_145850_b.field_72995_K) {
                this.inventory[i] = this.inventory[3].func_77946_l();
                this.inventory[3] = null;
            }
            did_copy = true;
            break;
        }
        this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "arsmagica2:misc.reconstructor.complete", 1.0f, 1.0f, true);
        return did_copy;
    }

    public int func_70302_i_() {
        return 19;
    }

    public ItemStack func_70301_a(int var1) {
        if (var1 >= this.inventory.length) {
            return null;
        }
        return this.inventory[var1];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "ArcaneReconstructor";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("ArcaneReconstructorInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.active = nbttagcompound.func_74767_n("ArcaneReconstructorActive");
        this.repairCounter = nbttagcompound.func_74762_e("ArcaneReconstructorRepairCounter");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("ArcaneReconstructorInventory", (NBTBase)nbttaglist);
        nbttagcompound.func_74757_a("ArcaneReconstructorActive", this.active);
        nbttagcompound.func_74768_a("ArcaneReconstructorRepairCounter", this.repairCounter);
    }

    private int numFociOfType(Class type) {
        int count = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.inventory[i] == null || !type.isInstance(this.inventory[i].func_77973_b())) continue;
            ++count;
        }
        return count;
    }

    private int getRepairRate() {
        int numFoci = this.numFociOfType(ItemFocusCharge.class);
        int base = 20;
        if (numFoci > 0) {
            base -= 5 * numFoci;
        }
        return base;
    }

    private float getRepairCost() {
        int numFoci = this.numFociOfType(ItemFocusMana.class);
        float base = 250.0f;
        float deduction = 100.0f;
        for (int i = 0; i < numFoci; ++i) {
            base -= deduction;
            deduction /= 2.0f;
        }
        return base;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i >= 4 && i < 10 && this.itemStackIsValid(itemstack);
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i >= 4 && i < 10 && this.itemStackIsValid(itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i >= 10 && i < 16;
    }

    @Override
    public int getChargeRate() {
        return 250;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.inventory[16], this.inventory[17], this.inventory[18]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }
}

