/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.AMCore;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.math.AMVector3;
import am2.api.power.PowerTypes;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.tileentities.TileEntityObelisk;
import am2.buffs.BuffEffectManaRegen;
import am2.buffs.BuffList;
import am2.damage.DamageSources;
import am2.entities.EntityAirSled;
import am2.entities.EntityDarkling;
import am2.entities.EntityFlicker;
import am2.entities.EntityShadowHelper;
import am2.entities.EntityThrownSickle;
import am2.entities.EntityWinterGuardianArm;
import am2.multiblock.IMultiblockStructureController;
import am2.particles.AMLineArc;
import am2.power.PowerNodeRegistry;
import am2.utility.EntityUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class TileEntityBlackAurem
extends TileEntityObelisk
implements IMultiblockStructureController {
    private final HashMap arcs = new HashMap();
    private static final int GROUP_CHIMERITE = 0;
    private static final int GROUP_OBSIDIAN = 1;
    private static final int GROUP_SUNSTONE = 2;
    private final ArrayList<EntityLivingBase> cachedEntities = new ArrayList();
    private int ticksSinceLastEntityScan = 0;
    private float rotation = 0.0f;
    private float rotationIncrement = 0.15f;

    public TileEntityBlackAurem() {
        super(10000);
        this.structure = new MultiblockStructureDefinition("blackaurem_structure");
        this.pillars = this.structure.createGroup("pillars", 4);
        this.caps = new HashMap();
        MultiblockStructureDefinition.StructureGroup chimerite = this.structure.createGroup("caps_chimerite", 2);
        MultiblockStructureDefinition.StructureGroup obsidian = this.structure.createGroup("caps_obsidian", 2);
        MultiblockStructureDefinition.StructureGroup sunstone = this.structure.createGroup("caps_sunstone", 2);
        this.caps.put(chimerite, Float.valueOf(1.1f));
        this.caps.put(obsidian, Float.valueOf(1.5f));
        this.caps.put(sunstone, Float.valueOf(2.0f));
        this.structure.addAllowedBlock(0, 0, 0, BlocksCommonProxy.blackAurem);
        this.structure.addAllowedBlock(this.pillars, -2, 0, -2, Blocks.field_150385_bj);
        this.structure.addAllowedBlock(this.pillars, -2, 1, -2, Blocks.field_150385_bj);
        this.structure.addAllowedBlock(chimerite, -2, 2, -2, (Block)BlocksCommonProxy.AMOres, 9);
        this.structure.addAllowedBlock(obsidian, -2, 2, -2, Blocks.field_150343_Z);
        this.structure.addAllowedBlock(sunstone, -2, 2, -2, (Block)BlocksCommonProxy.AMOres, 8);
        this.structure.addAllowedBlock(this.pillars, 2, 0, -2, Blocks.field_150385_bj);
        this.structure.addAllowedBlock(this.pillars, 2, 1, -2, Blocks.field_150385_bj);
        this.structure.addAllowedBlock(chimerite, 2, 2, -2, (Block)BlocksCommonProxy.AMOres, 9);
        this.structure.addAllowedBlock(obsidian, 2, 2, -2, Blocks.field_150343_Z);
        this.structure.addAllowedBlock(sunstone, 2, 2, -2, (Block)BlocksCommonProxy.AMOres, 8);
        this.structure.addAllowedBlock(this.pillars, -2, 0, 2, Blocks.field_150385_bj);
        this.structure.addAllowedBlock(this.pillars, -2, 1, 2, Blocks.field_150385_bj);
        this.structure.addAllowedBlock(chimerite, -2, 2, 2, (Block)BlocksCommonProxy.AMOres, 9);
        this.structure.addAllowedBlock(obsidian, -2, 2, 2, Blocks.field_150343_Z);
        this.structure.addAllowedBlock(sunstone, -2, 2, 2, (Block)BlocksCommonProxy.AMOres, 8);
        this.structure.addAllowedBlock(this.pillars, 2, 0, 2, Blocks.field_150385_bj);
        this.structure.addAllowedBlock(this.pillars, 2, 1, 2, Blocks.field_150385_bj);
        this.structure.addAllowedBlock(chimerite, 2, 2, 2, (Block)BlocksCommonProxy.AMOres, 9);
        this.structure.addAllowedBlock(obsidian, 2, 2, 2, Blocks.field_150343_Z);
        this.structure.addAllowedBlock(sunstone, 2, 2, 2, (Block)BlocksCommonProxy.AMOres, 8);
        this.wizardChalkCircle = this.addWizChalkGroupToStructure(this.structure, 1);
    }

    @Override
    protected void checkNearbyBlockState() {
        ArrayList<MultiblockStructureDefinition.StructureGroup> groups = this.structure.getMatchedGroups(7, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        float capsLevel = 1.0f;
        boolean pillarsFound = false;
        boolean wizChalkFound = false;
        block0: for (MultiblockStructureDefinition.StructureGroup group : groups) {
            if (group == this.pillars) {
                pillarsFound = true;
            } else if (group == this.wizardChalkCircle) {
                wizChalkFound = true;
            }
            for (MultiblockStructureDefinition.StructureGroup cap : this.caps.keySet()) {
                if (group != cap) continue;
                capsLevel = ((Float)this.caps.get(cap)).floatValue();
                continue block0;
            }
        }
        this.powerMultiplier = 1.0f;
        if (wizChalkFound) {
            this.powerMultiplier = 1.25f;
        }
        if (pillarsFound) {
            this.powerMultiplier *= capsLevel;
        }
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.rotation += this.rotationIncrement;
        } else {
            ++this.surroundingCheckTicks;
        }
        if (this.field_145850_b.field_72995_K || this.ticksSinceLastEntityScan++ > 25) {
            this.updateNearbyEntities();
            this.ticksSinceLastEntityScan = 0;
        }
        Iterator<EntityLivingBase> it = this.cachedEntities.iterator();
        while (it.hasNext()) {
            EntityLivingBase ent = it.next();
            if (ent.field_70128_L) {
                it.remove();
                continue;
            }
            MovingObjectPosition mop = this.field_145850_b.func_72901_a(Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.5)), Vec3.func_72443_a((double)ent.field_70165_t, (double)(ent.field_70163_u + (double)ent.func_70047_e()), (double)ent.field_70161_v), false);
            if (EntityUtilities.isSummon(ent) || mop != null) continue;
            ent.field_70181_x = 0.0;
            ent.field_70159_w = 0.0;
            ent.field_70179_y = 0.0;
            double deltaX = (double)((float)this.field_145851_c + 0.5f) - ent.field_70165_t;
            double deltaZ = (double)((float)this.field_145849_e + 0.5f) - ent.field_70161_v;
            double deltaY = (double)this.field_145848_d - ent.field_70163_u;
            double angle = Math.atan2(deltaZ, deltaX);
            double offsetX = Math.cos(angle) * 0.1;
            double offsetZ = Math.sin(angle) * 0.1;
            double offsetY = 0.05f;
            double distanceHorizontal = deltaX * deltaX + deltaZ * deltaZ;
            double distanceVertical = (double)this.field_145848_d - ent.field_70163_u;
            boolean spawnedParticles = false;
            if (distanceHorizontal < 1.3) {
                if (distanceVertical < -1.5 && this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(10) < 3) {
                    AMCore.proxy.particleManager.BoltFromPointToPoint(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.3, (double)this.field_145849_e + 0.5, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, 4, 0);
                }
                if (distanceVertical < -2.0) {
                    offsetY = 0.0;
                    if (!this.field_145850_b.field_72995_K && ent.func_70097_a((DamageSource)DamageSources.darkNexus, 4.0f) && ent.func_110143_aJ() <= 0.0f) {
                        ent.func_70106_y();
                        float power = (float)((int)Math.ceil(ent.func_110138_aP() * (float)(ent.field_70173_aa / 20) % 5000.0f)) * this.powerMultiplier;
                        PowerNodeRegistry.For(this.field_145850_b).insertPower(this, PowerTypes.DARK, power);
                    }
                }
            }
            if (this.field_145850_b.field_72995_K) {
                if (!this.arcs.containsKey(ent)) {
                    AMLineArc arc = (AMLineArc)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "textures/blocks/oreblocksunstone.png", (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.3, (double)this.field_145849_e + 0.5, (Entity)ent));
                    if (arc != null) {
                        arc.setExtendToTarget();
                        arc.func_70538_b(1.0f, 1.0f, 1.0f);
                    }
                    this.arcs.put(ent, arc);
                }
                Iterator arcIterator = this.arcs.keySet().iterator();
                ArrayList<Entity> toRemove = new ArrayList<Entity>();
                while (arcIterator.hasNext()) {
                    Entity arcEnt = (Entity)arcIterator.next();
                    AMLineArc arc = (AMLineArc)((Object)this.arcs.get(arcEnt));
                    if (arcEnt != null && !arcEnt.field_70128_L && arc != null && !arc.field_70128_L) {
                        AMVector3 aMVector3 = new AMVector3((Entity)ent);
                        AMVector3 aMVector32 = new AMVector3(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        if (!(aMVector3.distanceSqTo(aMVector32) > 100.0)) continue;
                    }
                    toRemove.add(arcEnt);
                }
                for (Entity e : toRemove) {
                    this.arcs.remove(e);
                }
            }
            if (this.field_145850_b.field_72995_K) continue;
            ent.func_70091_d(offsetX, offsetY, offsetZ);
        }
        if (this.surroundingCheckTicks % 100 == 0) {
            this.checkNearbyBlockState();
            this.surroundingCheckTicks = 1;
            if (!this.field_145850_b.field_72995_K && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, (float)this.capacity * 0.1f)) {
                List nearbyPlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2)));
                for (EntityPlayer p : nearbyPlayers) {
                    if (p.func_82165_m(BuffList.manaRegen.field_76415_H)) continue;
                    p.func_70690_d((PotionEffect)new BuffEffectManaRegen(600, 3));
                }
            }
        }
        super.callSuperUpdate();
    }

    private void updateNearbyEntities() {
        ArrayList toRemove = new ArrayList();
        List nearbyEntities = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 10), (double)this.field_145848_d, (double)(this.field_145849_e - 10), (double)(this.field_145851_c + 10), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 10)));
        for (EntityLivingBase entity : nearbyEntities) {
            if (entity.func_85032_ar() || entity instanceof IBossDisplayData || entity instanceof EntityDarkling || entity instanceof EntityPlayer || entity instanceof EntityAirSled || entity instanceof EntityWinterGuardianArm || entity instanceof EntityThrownSickle || entity instanceof EntityFlicker || entity instanceof EntityShadowHelper || this.cachedEntities.contains(entity)) continue;
            this.cachedEntities.add(entity);
        }
        this.ticksSinceLastEntityScan = 0;
    }

    @Override
    public MultiblockStructureDefinition getDefinition() {
        return this.structure;
    }

    @Override
    public boolean canRequestPower() {
        return false;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return type == PowerTypes.DARK;
    }

    @Override
    public PowerTypes[] getValidPowerTypes() {
        return new PowerTypes[]{PowerTypes.DARK};
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }
}

