/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.AMCore;
import am2.api.flickers.IFlickerController;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.spell.enums.Affinity;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class FlickerOperatorGentleRains
implements IFlickerFunctionality {
    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 0;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered) {
        int radius = 6;
        int diameter = radius * 2 + 1;
        if (!worldObj.field_72995_K) {
            Block block;
            int effectY;
            int effectX = ((TileEntity)habitat).field_145851_c - radius + worldObj.field_73012_v.nextInt(diameter);
            int effectZ = ((TileEntity)habitat).field_145849_e - radius + worldObj.field_73012_v.nextInt(diameter);
            for (effectY = ((TileEntity)habitat).field_145848_d - 1; worldObj.func_147437_c(effectX, effectY, effectZ) && effectY > 0; --effectY) {
            }
            while (!worldObj.func_147437_c(effectX, effectY, effectZ) && worldObj.func_147439_a(effectX, effectY, effectZ) != Blocks.field_150458_ak && effectY > 0) {
                ++effectY;
            }
            if ((block = worldObj.func_147439_a(effectX, --effectY, effectZ)) == Blocks.field_150458_ak && worldObj.func_72805_g(effectX, effectY, effectZ) < 15) {
                worldObj.func_72921_c(effectX, effectY, effectZ, 15, 2);
                return true;
            }
        } else {
            for (int i = 0; i < AMCore.config.getGFXLevel() * 2; ++i) {
                AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(worldObj, "water_ball", (double)((TileEntity)habitat).field_145851_c + 0.5, ((TileEntity)habitat).field_145848_d + 3, (double)((TileEntity)habitat).field_145849_e + 0.5));
                if (particle == null) continue;
                particle.setAffectedByGravity();
                particle.setMaxAge(10);
                particle.setDontRequireControllers();
                particle.setParticleScale(0.03f);
                particle.field_70145_X = false;
                particle.addRandomOffset(diameter, 0.0, diameter);
            }
        }
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
        return this.DoOperation(worldObj, habitat, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return 1;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        Object[] objectArray = new Object[11];
        objectArray[0] = " B ";
        objectArray[1] = "CWT";
        objectArray[2] = " B ";
        objectArray[3] = Character.valueOf('C');
        objectArray[4] = BlocksCommonProxy.essenceConduit;
        objectArray[5] = Character.valueOf('T');
        objectArray[6] = BlocksCommonProxy.tarmaRoot;
        objectArray[7] = Character.valueOf('W');
        objectArray[8] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.WATER.ordinal());
        objectArray[9] = Character.valueOf('B');
        objectArray[10] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 2);
        return objectArray;
    }
}

