/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.api.flickers.IFlickerController;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.math.AMVector3;
import am2.api.spell.enums.Affinity;
import am2.blocks.tileentities.TileEntityCrystalMarker;
import am2.blocks.tileentities.TileEntityFlickerHabitat;
import am2.items.ItemsCommonProxy;
import am2.utility.GetFirstStackStartingFromSlotResult;
import am2.utility.InventoryUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public class FlickerOperatorItemTransport
implements IFlickerFunctionality {
    private static final float BASE_POWERED_ACTIVATION_TIME = 10.0f;
    private static final float TIME_DISCOUNT_PERCENTAGE = 0.33f;
    public static final FlickerOperatorItemTransport instance = new FlickerOperatorItemTransport();

    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 10;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController controller, boolean powered) {
        Affinity[] emptyFlickerList = new Affinity[6];
        this.DoOperation(worldObj, controller, powered, emptyFlickerList);
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController controller, boolean powered, Affinity[] flickers) {
        if (worldObj.field_72995_K) {
            return false;
        }
        TileEntityFlickerHabitat habitat = null;
        if (!(controller instanceof TileEntityFlickerHabitat)) {
            return false;
        }
        habitat = (TileEntityFlickerHabitat)controller;
        int toMove = 0;
        for (int i = 0; i < 6; ++i) {
            if (flickers[i] != Affinity.ARCANE) continue;
            toMove += 32;
        }
        toMove = Math.max(toMove, 1);
        ArrayList itemsToTransfer = new ArrayList();
        ArrayList<AMVector3> removeFromInList = new ArrayList<AMVector3>();
        boolean itemFound = false;
        if (habitat.getInListPosition() >= habitat.getInListSize()) {
            habitat.setInListPosition(0);
        }
        for (int inIterator = habitat.getInListPosition(); inIterator < habitat.getInListSize(); ++inIterator) {
            TileEntityChest adjacent;
            AMVector3 vector = habitat.getInListAt(inIterator);
            TileEntity te = null;
            TileEntityCrystalMarker crystalMarkerTE = this.GetCrystalMarkerTileEntity(worldObj, (int)vector.x, (int)vector.y, (int)vector.z);
            if (crystalMarkerTE == null) {
                removeFromInList.add(vector);
                break;
            }
            te = this.GetAttachedCrystalMarkerTileEntity(worldObj, crystalMarkerTE, vector);
            if (te == null || !(te instanceof IInventory)) continue;
            itemFound = this.moveItem(worldObj, (IInventory)te, crystalMarkerTE, habitat, toMove);
            if (itemFound) {
                habitat.setInListPosition(inIterator + 1);
                break;
            }
            if (!(te instanceof TileEntityChest) || (adjacent = InventoryUtilities.getAdjacentChest((TileEntityChest)te)) == null || !(itemFound = this.moveItem(worldObj, (IInventory)adjacent, crystalMarkerTE, habitat, toMove))) continue;
            habitat.setInListPosition(inIterator + 1);
        }
        if (!itemFound) {
            habitat.setInListPosition(0);
        }
        for (AMVector3 vector : removeFromInList) {
            habitat.removeInListAt(vector);
        }
        return itemFound;
    }

    private boolean moveItem(World worldObj, IInventory inventory, TileEntityCrystalMarker crystalMarkerTE, TileEntityFlickerHabitat habitat, int toMove) {
        boolean itemFound = false;
        ItemStack orgStack = null;
        int currentSlot = 0;
        GetFirstStackStartingFromSlotResult result = InventoryUtilities.getFirstStackStartingFromSlot(inventory, orgStack, currentSlot, crystalMarkerTE.getFacing());
        orgStack = result.stack;
        currentSlot = result.slot;
        while (orgStack != null) {
            if (orgStack != null && this.InputCanMove(crystalMarkerTE, orgStack, inventory)) {
                int amountToMove;
                ItemStack stackCopy = orgStack.func_77946_l();
                ItemStack mergeStack = stackCopy.func_77979_a(amountToMove = Math.min(toMove, stackCopy.field_77994_a));
                if (this.FindOutput(worldObj, habitat, mergeStack, inventory)) {
                    InventoryUtilities.deductFromInventory(inventory, orgStack, amountToMove - mergeStack.field_77994_a);
                    itemFound = true;
                    break;
                }
                ++currentSlot;
            } else {
                ++currentSlot;
            }
            result = InventoryUtilities.getFirstStackStartingFromSlot(inventory, orgStack, currentSlot, crystalMarkerTE.getFacing());
            orgStack = result.stack;
            currentSlot = result.slot;
            if (currentSlot != -1) continue;
            orgStack = null;
        }
        return itemFound;
    }

    private boolean InputCanMove(TileEntityCrystalMarker crystalMarker, ItemStack stack, IInventory inventory) {
        switch (crystalMarker.getMarkerType()) {
            case 0: {
                return true;
            }
            case 5: {
                return crystalMarker.filterHasItem(stack) && crystalMarker.getFilterCount(stack) < InventoryUtilities.getLikeItemCount(inventory, stack);
            }
            case 6: {
                return crystalMarker.filterHasItem(stack);
            }
            case 8: {
                return !crystalMarker.filterHasItem(stack);
            }
        }
        return false;
    }

    private boolean FindOutput(World worldObj, TileEntityFlickerHabitat attuner, ItemStack stack, IInventory source) {
        HashMap removeFromOutList = new HashMap();
        boolean itemMoved = false;
        for (int priority = 0; priority <= 11; ++priority) {
            int start;
            if (attuner.getOutListPosition(priority) >= attuner.getOutListSize(priority)) {
                attuner.setOutListPosition(priority, 0);
            }
            int pos = start = attuner.getOutListPosition(priority);
            boolean fullLoop = false;
            while (!fullLoop) {
                TileEntityChest inventory;
                TileEntityChest adjacent;
                IInventory inventory2;
                AMVector3 vector = attuner.getOutListAt(priority, pos);
                TileEntity te = null;
                TileEntityCrystalMarker crystalMarkerTE = this.GetCrystalMarkerTileEntity(worldObj, (int)vector.x, (int)vector.y, (int)vector.z);
                if (crystalMarkerTE == null) {
                    if (!removeFromOutList.containsKey(priority)) {
                        removeFromOutList.put(priority, new ArrayList());
                    }
                    ((ArrayList)removeFromOutList.get(priority)).add(vector);
                    break;
                }
                te = this.GetAttachedCrystalMarkerTileEntity(worldObj, crystalMarkerTE, vector);
                int markerType = worldObj.func_72805_g((int)vector.x, (int)vector.y, (int)vector.z);
                if (te != null && te instanceof IInventory && (itemMoved = this.outputItem(markerType, new IInventory[]{inventory2 = (IInventory)te}, stack, crystalMarkerTE, new IInventory[]{source}))) {
                    attuner.setOutListPosition(priority, pos + 1);
                }
                if (!itemMoved && te instanceof TileEntityChest && (adjacent = InventoryUtilities.getAdjacentChest((TileEntityChest)te)) != null && (itemMoved = this.outputItem(markerType, new IInventory[]{inventory = adjacent, (IInventory)te}, stack, crystalMarkerTE, new IInventory[]{source}))) {
                    attuner.setOutListPosition(priority, pos + 1);
                }
                if (itemMoved) break;
                ++pos;
                if ((pos %= attuner.getOutListSize(priority)) != start) continue;
                fullLoop = true;
            }
            Iterator iterator = removeFromOutList.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                for (AMVector3 vector : (ArrayList)removeFromOutList.get(i)) {
                    attuner.removeOutListAt(i, vector);
                }
            }
            if (itemMoved) break;
            attuner.setOutListPosition(priority, 0);
        }
        return itemMoved;
    }

    private boolean outputItem(int markerType, IInventory[] outputs, ItemStack stack, TileEntityCrystalMarker crystalMarkerTE, IInventory[] sources) {
        int side = crystalMarkerTE.getFacing();
        switch (markerType) {
            case 1: 
            case 7: {
                for (IInventory inventory : outputs) {
                    if (!InventoryUtilities.inventoryHasRoomFor(inventory, stack, 1, side) || !this.isDestinationDifferentFromSource(outputs, sources)) continue;
                    return InventoryUtilities.mergeIntoInventory(inventory, stack, stack.field_77994_a, side);
                }
                break;
            }
            case 2: {
                boolean atLeastOneContains = false;
                for (IInventory inventory : outputs) {
                    if (!InventoryUtilities.inventoryHasItem(inventory, stack, 1, side)) continue;
                    atLeastOneContains = true;
                    break;
                }
                for (IInventory inventory : outputs) {
                    if (!atLeastOneContains || !InventoryUtilities.inventoryHasRoomFor(inventory, stack, 1, side) || !this.isDestinationDifferentFromSource(outputs, sources)) continue;
                    return InventoryUtilities.mergeIntoInventory(inventory, stack, stack.field_77994_a, side);
                }
                break;
            }
            case 3: {
                for (IInventory inventory : outputs) {
                    if (!crystalMarkerTE.filterHasItem(stack) || !InventoryUtilities.inventoryHasRoomFor(inventory, stack, 1, side) || !this.isDestinationDifferentFromSource(outputs, sources)) continue;
                    return InventoryUtilities.mergeIntoInventory(inventory, stack, stack.field_77994_a, side);
                }
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                for (IInventory inventory : outputs) {
                    if (!crystalMarkerTE.filterHasItem(stack) || InventoryUtilities.getLikeItemCount(inventory, stack, side) >= crystalMarkerTE.getFilterCount(stack) || !InventoryUtilities.inventoryHasRoomFor(inventory, stack, 1, side) || !this.isDestinationDifferentFromSource(outputs, sources)) continue;
                    return InventoryUtilities.mergeIntoInventory(inventory, stack, stack.field_77994_a, side);
                }
                break;
            }
        }
        return false;
    }

    private boolean isDestinationDifferentFromSource(IInventory[] destinations, IInventory[] sources) {
        boolean destinationDifferent = true;
        block0: for (IInventory destination : destinations) {
            for (IInventory source : sources) {
                if (destination instanceof ISidedInventory || !destination.equals(source)) continue;
                destinationDifferent = false;
                continue block0;
            }
        }
        return destinationDifferent;
    }

    private TileEntityCrystalMarker GetCrystalMarkerTileEntity(World worldObj, int x, int y, int z) {
        TileEntity te = worldObj.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityCrystalMarker) {
            return (TileEntityCrystalMarker)te;
        }
        return null;
    }

    private TileEntity GetAttachedCrystalMarkerTileEntity(World worldObj, TileEntityCrystalMarker crystalMarkerTE, AMVector3 cmVector) {
        TileEntity te = null;
        switch (crystalMarkerTE.getFacing()) {
            case 0: {
                te = worldObj.func_147438_o((int)cmVector.x, (int)cmVector.y + 1, (int)cmVector.z);
                break;
            }
            case 1: {
                te = worldObj.func_147438_o((int)cmVector.x, (int)cmVector.y - 1, (int)cmVector.z);
                break;
            }
            case 2: {
                te = worldObj.func_147438_o((int)cmVector.x, (int)cmVector.y, (int)cmVector.z + 1);
                break;
            }
            case 3: {
                te = worldObj.func_147438_o((int)cmVector.x, (int)cmVector.y, (int)cmVector.z - 1);
                break;
            }
            case 4: {
                te = worldObj.func_147438_o((int)cmVector.x + 1, (int)cmVector.y, (int)cmVector.z);
                break;
            }
            case 5: {
                te = worldObj.func_147438_o((int)cmVector.x - 1, (int)cmVector.y, (int)cmVector.z);
            }
        }
        return te;
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        if (powered) {
            float rechargeTime = 10.0f;
            for (int i = 0; i < 6; ++i) {
                if (flickers[i] != Affinity.LIGHTNING) continue;
                rechargeTime -= rechargeTime * 0.33f;
            }
            return Math.round(rechargeTime);
        }
        return 20;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController controller, boolean powered) {
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController controller, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        Object[] objectArray = new Object[9];
        objectArray[0] = " B ";
        objectArray[1] = "CAC";
        objectArray[2] = " B ";
        objectArray[3] = Character.valueOf('A');
        objectArray[4] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.AIR.ordinal());
        objectArray[5] = Character.valueOf('C');
        objectArray[6] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 4);
        objectArray[7] = Character.valueOf('B');
        objectArray[8] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 5);
        return objectArray;
    }
}

