/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.AMCore;
import am2.api.flickers.IFlickerController;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.spell.enums.Affinity;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class FlickerOperatorLight
implements IFlickerFunctionality {
    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 0;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered) {
        if (!worldObj.field_72995_K) {
            int radius = 16;
            int yRadius = radius / 4;
            int checksPerOperation = 8;
            int checkX = ((TileEntity)habitat).field_145851_c - radius;
            int checkY = ((TileEntity)habitat).field_145848_d - yRadius;
            int checkZ = ((TileEntity)habitat).field_145849_e - radius;
            byte[] meta = habitat.getMetadata(this);
            if (meta.length != 0) {
                AMDataReader rdr = new AMDataReader(meta, false);
                checkX = rdr.getInt();
                checkY = rdr.getInt();
                checkZ = rdr.getInt();
            }
            for (int i = 0; i < checksPerOperation; ++i) {
                int light = worldObj.func_72957_l(checkX, checkY, checkZ);
                if (light < 10 && worldObj.func_147437_c(checkX, checkY, checkZ)) {
                    worldObj.func_147465_d(checkX, checkY, checkZ, (Block)BlocksCommonProxy.invisibleUtility, 10, 2);
                }
                if (++checkX <= ((TileEntity)habitat).field_145851_c + radius) continue;
                checkX = ((TileEntity)habitat).field_145851_c - radius;
                if (++checkY <= ((TileEntity)habitat).field_145848_d + yRadius) continue;
                checkY = ((TileEntity)habitat).field_145848_d - yRadius;
                if (++checkZ <= ((TileEntity)habitat).field_145849_e + radius) continue;
                checkZ = ((TileEntity)habitat).field_145849_e - radius;
            }
            AMDataWriter writer = new AMDataWriter();
            writer.add(checkX).add(checkY).add(checkZ);
            habitat.setMetadata(this, writer.generate());
        } else {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(worldObj, "sparkle", (double)((TileEntity)habitat).field_145851_c + 0.5, ((TileEntity)habitat).field_145848_d + 1, (double)((TileEntity)habitat).field_145849_e + 0.5));
            if (particle != null) {
                particle.addRandomOffset(0.5, 0.4, 0.5);
                particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.02f, 1, false));
                particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f));
                particle.setMaxAge(20);
            }
        }
        return true;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
        return this.DoOperation(worldObj, habitat, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered) {
        habitat.removeMetadata(this);
        if (!worldObj.field_72995_K) {
            int radius = 28;
            int yRadius = radius / 4;
            for (int i = ((TileEntity)habitat).field_145851_c - radius; i <= ((TileEntity)habitat).field_145851_c + radius; ++i) {
                for (int j = ((TileEntity)habitat).field_145848_d - yRadius; j <= ((TileEntity)habitat).field_145848_d + yRadius; ++j) {
                    for (int k = ((TileEntity)habitat).field_145849_e - radius; k <= ((TileEntity)habitat).field_145849_e + radius; ++k) {
                        int meta;
                        Block block = worldObj.func_147439_a(i, j, k);
                        if (block != BlocksCommonProxy.invisibleUtility || (meta = worldObj.func_72805_g(i, j, k)) != 10) continue;
                        worldObj.func_147468_f(i, j, k);
                    }
                }
            }
        }
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return 10;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
        this.RemoveOperator(worldObj, habitat, powered);
    }

    @Override
    public Object[] getRecipe() {
        Object[] objectArray = new Object[11];
        objectArray[0] = "ISI";
        objectArray[1] = "F L";
        objectArray[2] = "ISI";
        objectArray[3] = Character.valueOf('F');
        objectArray[4] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.FIRE.ordinal());
        objectArray[5] = Character.valueOf('S');
        objectArray[6] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 6);
        objectArray[7] = Character.valueOf('L');
        objectArray[8] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.LIGHTNING.ordinal());
        objectArray[9] = Character.valueOf('I');
        objectArray[10] = ItemsCommonProxy.liquidEssenceBottle;
        return objectArray;
    }
}

