/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMLineArc;
import am2.particles.AMParticle;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class ParticleRenderer {
    public static String name = "am2-particle";
    private final ArrayList<EntityFX> particles;
    private final ArrayList<EntityFX> blocks;
    private final ArrayList<EntityFX> radiants;
    private final ArrayList<AMLineArc> arcs;
    private final ArrayList<EntityFX> deferredParticles;
    private final ArrayList<EntityFX> deferredBlocks;
    private final ArrayList<EntityFX> deferredRadiants;
    private final ArrayList<AMLineArc> deferredArcs;

    public ParticleRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.particles = new ArrayList();
        this.radiants = new ArrayList();
        this.arcs = new ArrayList();
        this.blocks = new ArrayList();
        this.deferredParticles = new ArrayList();
        this.deferredRadiants = new ArrayList();
        this.deferredArcs = new ArrayList();
        this.deferredBlocks = new ArrayList();
    }

    public void addEffect(EntityFX effect) {
        if (effect instanceof AMParticle) {
            this.addAMParticle((AMParticle)effect);
        } else if (effect instanceof AMLineArc) {
            this.addArcEffect((AMLineArc)effect);
        } else {
            this.deferredParticles.add(effect);
        }
    }

    public void addAMParticle(AMParticle particle) {
        if (particle.isRadiant()) {
            this.deferredRadiants.add(particle);
        } else if (particle.isBlockTexture()) {
            this.deferredBlocks.add(particle);
        } else {
            this.deferredParticles.add(particle);
        }
    }

    public void addArcEffect(AMLineArc arc) {
        this.deferredArcs.add(arc);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.render(event.partialTicks);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.particles.clear();
        this.radiants.clear();
        this.arcs.clear();
        this.blocks.clear();
        this.deferredParticles.clear();
        this.deferredRadiants.clear();
        this.deferredArcs.clear();
        this.deferredBlocks.clear();
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.updateParticles();
        }
    }

    private void updateParticles() {
        EntityFX particle;
        Minecraft.func_71410_x().field_71424_I.func_76320_a(name + "-update");
        this.particles.addAll(this.deferredParticles);
        this.deferredParticles.clear();
        this.radiants.addAll(this.deferredRadiants);
        this.deferredRadiants.clear();
        this.arcs.addAll(this.deferredArcs);
        this.deferredArcs.clear();
        this.blocks.addAll(this.deferredBlocks);
        this.deferredBlocks.clear();
        Iterator<EntityFX> it = this.particles.iterator();
        while (it.hasNext()) {
            particle = it.next();
            particle.func_70071_h_();
            if (!particle.field_70128_L) continue;
            it.remove();
        }
        it = this.radiants.iterator();
        while (it.hasNext()) {
            particle = it.next();
            particle.func_70071_h_();
            if (!particle.field_70128_L) continue;
            it.remove();
        }
        it = this.arcs.iterator();
        while (it.hasNext()) {
            particle = (AMLineArc)it.next();
            particle.func_70071_h_();
            if (!particle.field_70128_L) continue;
            it.remove();
        }
        it = this.blocks.iterator();
        while (it.hasNext()) {
            particle = it.next();
            particle.func_70071_h_();
            if (!particle.field_70128_L) continue;
            it.remove();
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private void render(float partialTicks) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a(name + "-render");
        EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
        EntityFX.field_70556_an = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        EntityFX.field_70554_ao = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        EntityFX.field_70555_ap = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.renderBlockParticles(partialTicks);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        this.renderStandardParticles(partialTicks);
        this.renderRadiants(partialTicks);
        this.renderArcs(partialTicks);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private void renderStandardParticles(float partialTicks) {
        float rotationX = ActiveRenderInfo.field_74588_d;
        float rotationZ = ActiveRenderInfo.field_74586_f;
        float rotationYZ = ActiveRenderInfo.field_74587_g;
        float rotationXY = ActiveRenderInfo.field_74596_h;
        float rotationXZ = ActiveRenderInfo.field_74589_e;
        GL11.glPushAttrib((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glDisable((int)32826);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (EntityFX particle : this.particles) {
            tessellator.func_78380_c(particle.func_70070_b(partialTicks));
            particle.func_70539_a(tessellator, partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
        }
        tessellator.func_78381_a();
        GL11.glPopAttrib();
    }

    private void renderBlockParticles(float partialTicks) {
        float rotationX = ActiveRenderInfo.field_74588_d;
        float rotationZ = ActiveRenderInfo.field_74586_f;
        float rotationYZ = ActiveRenderInfo.field_74587_g;
        float rotationXY = ActiveRenderInfo.field_74596_h;
        float rotationXZ = ActiveRenderInfo.field_74589_e;
        GL11.glPushAttrib((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glDisable((int)32826);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (EntityFX particle : this.blocks) {
            tessellator.func_78380_c(particle.func_70070_b(partialTicks));
            particle.func_70539_a(tessellator, partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
        }
        tessellator.func_78381_a();
        GL11.glPopAttrib();
    }

    private void renderRadiants(float partialTicks) {
        float rotationX = ActiveRenderInfo.field_74588_d;
        float rotationZ = ActiveRenderInfo.field_74586_f;
        float rotationYZ = ActiveRenderInfo.field_74587_g;
        float rotationXY = ActiveRenderInfo.field_74596_h;
        float rotationXZ = ActiveRenderInfo.field_74589_e;
        GL11.glPushAttrib((int)16640);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)false);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (EntityFX particle : this.radiants) {
            tessellator.func_78380_c(particle.func_70070_b(partialTicks));
            particle.func_70539_a(tessellator, partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
        }
        GL11.glPopAttrib();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
    }

    private void renderArcs(float partialTicks) {
        float rotationX = ActiveRenderInfo.field_74588_d;
        float rotationZ = ActiveRenderInfo.field_74586_f;
        float rotationYZ = ActiveRenderInfo.field_74587_g;
        float rotationXY = ActiveRenderInfo.field_74596_h;
        float rotationXZ = ActiveRenderInfo.field_74589_e;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)2884);
        for (EntityFX entityFX : this.arcs) {
            tessellator.func_78380_c(0xF000E0);
            entityFX.func_70539_a(tessellator, partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }
}

