/*
 * Decompiled with CFR 0.152.
 */
package am2.spell;

import am2.AMCore;
import am2.api.events.SpellCastingEvent;
import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.enums.SkillPointTypes;
import am2.api.spell.enums.SpellModifiers;
import am2.playerextensions.ExtendedProperties;
import am2.playerextensions.SkillData;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import am2.spell.SpellUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class SpellUnlockManager {
    private ArrayList<UnlockEntry> entries;

    public SpellUnlockManager() {
        this.init();
    }

    @SubscribeEvent
    public void onSpellCast(SpellCastingEvent.Pre event) {
        if (event.caster instanceof EntityPlayer) {
            if (ExtendedProperties.For(event.caster).getCurrentMana() < event.manaCost) {
                return;
            }
            for (UnlockEntry entry : this.entries) {
                if (!event.caster.field_70170_p.field_72995_K && entry.unlockIsInPrimaryTree((EntityPlayer)event.caster) && entry.willSpellUnlock(event.stack)) {
                    entry.unlockFor((EntityPlayer)event.caster);
                }
                if (entry.unlock instanceof ISpellModifier || !entry.unlockIsInSpell(event.stack) || SkillData.For((EntityPlayer)event.caster).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(entry.unlock)) && entry.unlockIsInPrimaryTree((EntityPlayer)event.caster)) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    public void init() {
        this.entries = new ArrayList();
        this.entries.add(new UnlockEntry(SkillManager.instance.getSkill("FallingStar"), SkillManager.instance.getSkill("MagicDamage"), SkillManager.instance.getSkill("Gravity"), SkillManager.instance.getSkill("AstralDistortion")));
        this.entries.add(new UnlockEntry(SkillManager.instance.getSkill("Blizzard"), SkillManager.instance.getSkill("Storm"), SkillManager.instance.getSkill("FrostDamage"), SkillManager.instance.getSkill("Freeze"), SkillManager.instance.getSkill("Damage")));
        this.entries.add(new UnlockEntry(SkillManager.instance.getSkill("FireRain"), SkillManager.instance.getSkill("Storm"), SkillManager.instance.getSkill("FireDamage"), SkillManager.instance.getSkill("Ignition"), SkillManager.instance.getSkill("Damage")));
        this.entries.add(new UnlockEntry(SkillManager.instance.getSkill("Dismembering"), SkillManager.instance.getSkill("Piercing"), SkillManager.instance.getSkill("Damage")));
        this.entries.add(new UnlockEntry(SkillManager.instance.getSkill("ManaLink"), SkillManager.instance.getSkill("ManaDrain"), SkillManager.instance.getSkill("Entangle")));
        this.entries.add(new UnlockEntry(SkillManager.instance.getSkill("ManaShield"), SkillManager.instance.getSkill("Shield"), SkillManager.instance.getSkill("Reflect"), SkillManager.instance.getSkill("LifeTap")));
        this.entries.add(new UnlockEntry(SkillManager.instance.getSkill("BuffPower"), SkillManager.instance.getSkill("Haste"), SkillManager.instance.getSkill("Slowfall"), SkillManager.instance.getSkill("SwiftSwim"), SkillManager.instance.getSkill("GravityWell"), SkillManager.instance.getSkill("Leap")));
        this.entries.add(new UnlockEntry(SkillManager.instance.getSkill("Daylight"), SkillManager.instance.getSkill("TrueSight"), SkillManager.instance.getSkill("DivineIntervention"), SkillManager.instance.getSkill("Light")));
        this.entries.add(new UnlockEntry(SkillManager.instance.getSkill("Moonrise"), SkillManager.instance.getSkill("NightVision"), SkillManager.instance.getSkill("EnderIntervention"), SkillManager.instance.getSkill("Lunar")));
        this.entries.add(new UnlockEntry(SkillManager.instance.getSkill("Prosperity"), SkillManager.instance.getSkill("Dig"), SkillManager.instance.getSkill("FeatherTouch"), SkillManager.instance.getSkill("MiningPower")));
    }

    class UnlockEntry {
        private ISkillTreeEntry unlock;
        private ISkillTreeEntry[] requiredComponents;

        public UnlockEntry(ISkillTreeEntry unlock, ISkillTreeEntry ... components) {
            this.unlock = unlock;
            this.requiredComponents = components;
        }

        public boolean unlockIsInSpell(ItemStack spell) {
            for (int i = 0; i < SpellUtils.instance.numStages(spell); ++i) {
                if (!this.partIsInStage(spell, this.unlock, i)) continue;
                return true;
            }
            return false;
        }

        public boolean partIsInStage(ItemStack spell, ISkillTreeEntry part, int stage) {
            if (part instanceof ISpellComponent && !SpellUtils.instance.componentIsPresent(spell, part.getClass(), stage)) {
                return false;
            }
            if (part instanceof ISpellModifier) {
                for (SpellModifiers modifier : ((ISpellModifier)part).getAspectsModified()) {
                    if (SpellUtils.instance.modifierIsPresent(modifier, spell, stage)) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean unlockIsInPrimaryTree(EntityPlayer caster) {
            if (AMCore.config.getSkillTreeSecondaryTierCap() >= SkillTreeManager.instance.getHighestTier()) {
                return true;
            }
            return SkillData.For(caster).getPrimaryTree() == SkillTreeManager.instance.getSkillTreeEntry((ISkillTreeEntry)this.unlock).tree;
        }

        public boolean willSpellUnlock(ItemStack spell) {
            for (int i = 0; i < SpellUtils.instance.numStages(spell); ++i) {
                boolean found = true;
                for (ISkillTreeEntry part : this.requiredComponents) {
                    if (this.partIsInStage(spell, part, i)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return true;
            }
            return false;
        }

        public void unlockFor(EntityPlayer player) {
            if (!player.field_70170_p.field_72995_K) {
                SkillData.For(player).incrementSpellPoints(SkillPointTypes.SILVER);
                SkillData.For(player).learn(SkillTreeManager.instance.getSkillTreeEntry((ISkillTreeEntry)this.unlock).registeredItem);
                SkillData.For(player).forceSync();
            }
        }
    }
}

