/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.buffs.BuffEffect;
import am2.buffs.BuffList;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleOrbitEntity;
import am2.playerextensions.ExtendedProperties;
import am2.utility.EntityUtilities;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class Dispel
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase) || target instanceof IBossDisplayData) {
            return false;
        }
        if (EntityUtilities.isSummon((EntityLivingBase)target) && EntityUtilities.getOwner((EntityLivingBase)target) == caster.func_145782_y()) {
            target.func_70097_a(DamageSource.field_76376_m, 50000.0f);
            return true;
        }
        ArrayList<Integer> effectsToRemove = new ArrayList<Integer>();
        Iterator iter = ((EntityLivingBase)target).func_70651_bq().iterator();
        int magnitudeLeft = 6;
        while (iter.hasNext()) {
            PotionEffect pe;
            int magnitudeCost;
            Integer potionID = ((PotionEffect)iter.next()).func_76456_a();
            if (BuffList.isDispelBlacklisted(potionID) || magnitudeLeft < (magnitudeCost = (pe = ((EntityLivingBase)target).func_70660_b(Potion.field_76425_a[potionID])).func_76458_c())) continue;
            magnitudeLeft -= magnitudeCost;
            effectsToRemove.add(potionID);
            if (!(pe instanceof BuffEffect) || world.field_72995_K) continue;
            ((BuffEffect)pe).stopEffect((EntityLivingBase)target);
        }
        if (effectsToRemove.size() == 0 && ExtendedProperties.For((EntityLivingBase)target).getNumSummons() == 0) {
            return false;
        }
        if (!world.field_72995_K) {
            this.removePotionEffects((EntityLivingBase)target, effectsToRemove);
        }
        return true;
    }

    private void removePotionEffects(EntityLivingBase target, List<Integer> effectsToRemove) {
        for (Integer i : effectsToRemove) {
            if ((i == BuffList.flight.field_76415_H || i == BuffList.levitation.field_76415_H) && target instanceof EntityPlayer && target.func_82165_m(BuffList.flight.field_76415_H)) {
                ((EntityPlayer)target).field_71075_bZ.field_75100_b = false;
                ((EntityPlayer)target).field_71075_bZ.field_75101_c = false;
            }
            target.func_82170_o(i.intValue());
        }
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 200.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "sparkle2", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 2.0, 1.0);
            particle.AddParticleController(new ParticleOrbitEntity(particle, target, 0.1f + rand.nextFloat() * 0.1f, 1, false));
            if (rand.nextBoolean()) {
                particle.setRGBColorF(0.7f, 0.1f, 0.7f);
            }
            particle.setMaxAge(20);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.NONE);
    }

    @Override
    public int getID() {
        return 10;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[4];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 13);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 2);
        objectArray[2] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 5);
        objectArray[3] = Items.field_151117_aB;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }
}

