/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.damage.DamageSources;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleHoldPosition;
import am2.particles.ParticleOrbitEntity;
import am2.playerextensions.AffinityData;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class Heal
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase) {
            if (((EntityLivingBase)target).func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                int healing = SpellUtils.instance.getModifiedInt_Mul(10, stack, caster, target, world, 0, SpellModifiers.HEALING);
                target.func_70015_d(2);
                return SpellHelper.instance.attackTargetSpecial(stack, target, (DamageSource)DamageSources.causeEntityHolyDamage(caster), (float)healing * (0.5f + 2.0f * AffinityData.For(caster).getAffinityDepth(Affinity.LIFE)));
            }
            int healing = SpellUtils.instance.getModifiedInt_Mul(2, stack, caster, target, world, 0, SpellModifiers.HEALING);
            if (ExtendedProperties.For((EntityLivingBase)target).getCanHeal()) {
                ((EntityLivingBase)target).func_70691_i((float)healing);
                ExtendedProperties.For((EntityLivingBase)target).setHealCooldown(60);
                return true;
            }
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 225.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        if (target instanceof EntityLivingBase && ((EntityLivingBase)target).func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            for (int i = 0; i < 25; ++i) {
                AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "symbols", x, y - 1.0, z));
                if (particle == null) continue;
                particle.addRandomOffset(1.0, 1.0, 1.0);
                particle.AddParticleController(new ParticleHoldPosition(particle, 20, 1, true));
                particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, -0.01f, 2, false));
                particle.AddParticleController(new ParticleFadeOut(particle, 2, false).setFadeSpeed(0.02f));
                particle.setParticleScale(0.1f);
                particle.setRGBColorF(1.0f, 0.2f, 0.2f);
            }
        } else {
            for (int i = 0; i < 25; ++i) {
                AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "sparkle", x, y - 1.0, z));
                if (particle == null) continue;
                particle.addRandomOffset(1.0, 1.0, 1.0);
                particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.1f, 1, false));
                particle.AddParticleController(new ParticleOrbitEntity(particle, target, 0.5, 2, false).setIgnoreYCoordinate(true).SetTargetDistance((double)0.3f + rand.nextDouble() * 0.3));
                particle.setMaxAge(20);
                particle.setParticleScale(0.2f);
                particle.setRGBColorF(0.1f, 1.0f, 0.1f);
                if (colorModifier <= -1) continue;
                particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.LIFE);
    }

    @Override
    public int getID() {
        return 25;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 6);
        objectArray[1] = BlocksCommonProxy.aum;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }
}

