/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.RitualShapeHelper;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.power.IPowerNode;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.buffs.BuffEffectIllumination;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.power.PowerNodeRegistry;
import am2.spell.SpellUtils;
import am2.spell.modifiers.Colour;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class Light
implements ISpellComponent,
IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        ItemStack[] reagents;
        if (world.func_147439_a(blockx, blocky, blockz) == BlocksCommonProxy.obelisk && (reagents = RitualShapeHelper.instance.checkForRitual(this, world, blockx, blocky, blockz)) != null) {
            if (!world.field_72995_K) {
                RitualShapeHelper.instance.consumeRitualReagents(this, world, blockx, blocky, blockz);
                RitualShapeHelper.instance.consumeRitualShape(this, world, blockx, blocky, blockz);
                world.func_147449_b(blockx, blocky, blockz, BlocksCommonProxy.celestialPrism);
                PowerNodeRegistry.For(world).registerPowerNode((IPowerNode)world.func_147438_o(blockx, blocky, blockz));
            }
            return true;
        }
        if (world.func_147439_a(blockx, blocky, blockz) == Blocks.field_150350_a) {
            blockFace = -1;
        }
        if (blockFace != -1) {
            switch (blockFace) {
                case 0: {
                    --blocky;
                    break;
                }
                case 1: {
                    ++blocky;
                    break;
                }
                case 2: {
                    --blockz;
                    break;
                }
                case 3: {
                    ++blockz;
                    break;
                }
                case 4: {
                    --blockx;
                    break;
                }
                case 5: {
                    ++blockx;
                }
            }
        }
        if (world.func_147439_a(blockx, blocky, blockz) != Blocks.field_150350_a) {
            return false;
        }
        if (!world.field_72995_K) {
            world.func_147465_d(blockx, blocky, blockz, BlocksCommonProxy.blockMageTorch, this.getColorMeta(stack), 2);
        }
        return true;
    }

    private int getColorMeta(ItemStack spell) {
        int meta = 15;
        int color = 0xFFFFFF;
        if (SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, spell, 0)) {
            ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(spell, 0);
            int ordinalCount = 0;
            for (ISpellModifier mod : mods) {
                if (!(mod instanceof Colour)) continue;
                byte[] data = SpellUtils.instance.getModifierMetadataFromStack(spell, mod, 0, ordinalCount++);
                color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, data);
            }
        }
        for (int i = 0; i < 16; ++i) {
            ItemDye cfr_ignored_0 = (ItemDye)Items.field_151100_aR;
            if (ItemDye.field_150922_c[i] != color) continue;
            meta = i;
            break;
        }
        return meta;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase) {
            int duration = SpellUtils.instance.getModifiedInt_Mul(600, stack, caster, target, world, 0, SpellModifiers.DURATION);
            duration = SpellUtils.instance.modifyDurationBasedOnArmor(caster, duration);
            if (!world.field_72995_K) {
                ((EntityLivingBase)target).func_70690_d((PotionEffect)new BuffEffectIllumination(duration, SpellUtils.instance.countModifiers(SpellModifiers.BUFF_POWER, stack, 0)));
            }
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 50.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 10.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 5; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "sparkle2", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 0.5, 1.0);
            particle.func_70024_g(rand.nextDouble() * 0.2 - 0.1, rand.nextDouble() * 0.2, rand.nextDouble() * 0.2 - 0.1);
            particle.setAffectedByGravity();
            particle.setDontRequireControllers();
            particle.setMaxAge(5);
            particle.setParticleScale(0.1f);
            particle.setRGBColorF(0.6f, 0.2f, 0.8f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.NONE);
    }

    @Override
    public int getID() {
        return 33;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[4];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 15);
        objectArray[1] = BlocksCommonProxy.cerublossom;
        objectArray[2] = Blocks.field_150478_aa;
        objectArray[3] = BlocksCommonProxy.vinteumTorch;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.purification;
    }

    @Override
    public ItemStack[] getReagents() {
        ItemStack[] itemStackArray = new ItemStack[2];
        itemStackArray[0] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 7);
        itemStackArray[1] = new ItemStack((Item)ItemsCommonProxy.manaFocus);
        return itemStackArray;
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }
}

