/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shapes;

import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellCastResult;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.entities.EntitySpellEffect;
import am2.items.ItemsCommonProxy;
import am2.spell.SpellUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Wave
implements ISpellShape {
    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[4];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 0);
        objectArray[1] = BlocksCommonProxy.magicWall;
        objectArray[2] = "E:*";
        objectArray[3] = 25000;
        return objectArray;
    }

    @Override
    public int getID() {
        return 17;
    }

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, int side, boolean giveXP, int useCount) {
        if (world.field_72995_K) {
            return SpellCastResult.SUCCESS;
        }
        double radius = SpellUtils.instance.getModifiedDouble_Add(1.0, stack, caster, (Entity)target, world, 0, SpellModifiers.RADIUS);
        int duration = SpellUtils.instance.getModifiedInt_Mul(20, stack, caster, (Entity)target, world, 0, SpellModifiers.DURATION);
        double speed = SpellUtils.instance.getModifiedDouble_Add(1.0, stack, caster, (Entity)target, world, 0, SpellModifiers.SPEED) * 0.5;
        int gravityModifiers = SpellUtils.instance.countModifiers(SpellModifiers.GRAVITY, stack, 0);
        boolean hasPiercing = SpellUtils.instance.modifierIsPresent(SpellModifiers.PIERCING, stack, 0);
        EntitySpellEffect wave = new EntitySpellEffect(world);
        wave.setRadius((float)radius);
        wave.setTicksToExist(duration);
        wave.SetCasterAndStack(caster, SpellUtils.instance.popStackStage(stack));
        wave.func_70107_b(x, y + 1.0, z);
        wave.setWave(caster.field_70177_z, (float)speed);
        wave.field_70145_X = hasPiercing;
        wave.setGravity((float)gravityModifiers * 0.5f);
        world.func_72838_d((Entity)wave);
        return SpellCastResult.SUCCESS;
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 3.0f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return true;
    }

    @Override
    public String getSoundForAffinity(Affinity affinity, ItemStack stack, World world) {
        switch (affinity) {
            case AIR: {
                return "arsmagica2:spell.cast.air";
            }
            case ARCANE: {
                return "arsmagica2:spell.cast.arcane";
            }
            case EARTH: {
                return "arsmagica2:spell.cast.earth";
            }
            case ENDER: {
                return "arsmagica2:spell.cast.ender";
            }
            case FIRE: {
                return "arsmagica2:spell.cast.fire";
            }
            case ICE: {
                return "arsmagica2:spell.cast.ice";
            }
            case LIFE: {
                return "arsmagica2:spell.cast.life";
            }
            case LIGHTNING: {
                return "arsmagica2:spell.cast.lightning";
            }
            case NATURE: {
                return "arsmagica2:spell.cast.nature";
            }
            case WATER: {
                return "arsmagica2:spell.cast.water";
            }
        }
        return "arsmagica2:spell.cast.none";
    }
}

