/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.particle;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import electroblob.wizardry.client.particle.EntitySnowFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityBlizzardFX
extends EntitySnowFX {
    public static final String NAME = "wizardryblizzard";
    private boolean gravity = false;
    private double angle;
    private double radius;
    private double speed;

    public EntityBlizzardFX(World world, float red, float green, float blue, int maxAge, double originX, double originZ, double radius, double yPos) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, maxAge);
        this.angle = this.field_70146_Z.nextDouble() * Math.PI * 2.0;
        double x = originX - Math.cos(this.angle) * radius;
        double z = originZ + radius * Math.sin(this.angle);
        this.radius = radius;
        this.func_70107_b(x, yPos, z);
        this.field_70145_X = true;
        this.field_70552_h = red;
        this.field_70553_i = green;
        this.field_70551_j = blue;
        this.speed = this.field_70146_Z.nextBoolean() ? this.field_70146_Z.nextDouble() * 2.0 + 1.0 : this.field_70146_Z.nextDouble() * -2.0 - 1.0;
    }

    public EntityBlizzardFX(World world, double x, double y, double z, double vx, double vy, double vz, float red, float green, float blue) {
        super(world, x, y, z, vx, vy, vz);
        this.field_70547_e = 48 + this.field_70146_Z.nextInt(12);
        this.field_70145_X = true;
        this.field_70552_h = red;
        this.field_70553_i = green;
        this.field_70551_j = blue;
    }

    public void setColour(int par1) {
        float f = (float)((par1 & 0xFF0000) >> 16) / 255.0f;
        float f1 = (float)((par1 & 0xFF00) >> 8) / 255.0f;
        float f2 = (float)((par1 & 0xFF) >> 0) / 255.0f;
        float f3 = 1.0f;
        this.func_70538_b(f * f3, f1 * f3, f2 * f3);
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void func_70539_a(Tessellator par1Tessellator, float par2, float par3, float par4, float par5, float par6, float par7) {
        if (this.field_70546_d < this.field_70547_e / 3 || (this.field_70546_d + this.field_70547_e) / 3 % 2 == 0) {
            super.func_70539_a(par1Tessellator, par2, par3, par4, par5, par6, par7);
        }
    }

    @Override
    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
        double omega = 0.3141592653589793 - this.speed / (20.0 * this.radius);
        if (this.speed < 0.0) {
            omega = -0.3141592653589793 + this.speed / (20.0 * this.radius);
        }
        this.angle += omega;
        this.field_70179_y = this.radius * omega * Math.cos(this.angle);
        this.field_70159_w = this.radius * omega * Math.sin(this.angle);
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.gravity) {
            this.field_70181_x -= 0.05;
        }
        if (this.field_70546_d > this.field_70547_e / 2) {
            this.func_82338_g(1.0f - ((float)this.field_70546_d - (float)(this.field_70547_e / 2)) / (float)this.field_70547_e);
        }
    }
}

