/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.particle;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityTornadoFX
extends EntityDiggingFX {
    public static final String NAME = "wizardrytornado";
    private boolean gravity = false;
    private double angle;
    private double radius;
    private double speed;
    private double velX;
    private double velZ;
    private boolean fullBrightness = false;

    public EntityTornadoFX(World world, int maxAge, double originX, double originZ, double radius, double yPos, double velX, double velZ, Block block, int metadata, int side) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, block, metadata, side);
        this.angle = this.field_70146_Z.nextDouble() * Math.PI * 2.0;
        double x = originX - Math.cos(this.angle) * radius;
        double z = originZ + radius * Math.sin(this.angle);
        this.radius = radius;
        this.func_70107_b(x, yPos, z);
        this.field_70547_e = maxAge;
        this.field_70145_X = true;
        if (block != Blocks.field_150349_c || side == 1) {
            this.setColour(block.func_149741_i(side));
        }
        if (block.func_149750_m() == 0) {
            this.field_70552_h = (float)((double)this.field_70552_h * 0.75);
            this.field_70553_i = (float)((double)this.field_70553_i * 0.75);
            this.field_70551_j = (float)((double)this.field_70551_j * 0.75);
        } else {
            this.fullBrightness = true;
        }
        this.speed = this.field_70146_Z.nextDouble() * 2.0 + 1.0;
        this.velX = velX;
        this.velZ = velZ;
    }

    public EntityTornadoFX(World world, double x, double y, double z, double vx, double vy, double vz, float red, float green, float blue) {
        super(world, x, y, z, vx, vy, vz, Blocks.field_150346_d, 0);
        this.field_70547_e = 48 + this.field_70146_Z.nextInt(12);
        this.field_70145_X = true;
        this.field_70552_h = red;
        this.field_70553_i = green;
        this.field_70551_j = blue;
    }

    public void setColour(int par1) {
        float f = (float)((par1 & 0xFF0000) >> 16) / 255.0f;
        float f1 = (float)((par1 & 0xFF00) >> 8) / 255.0f;
        float f2 = (float)((par1 & 0xFF) >> 0) / 255.0f;
        float f3 = 1.0f;
        this.func_70538_b(f * f3, f1 * f3, f2 * f3);
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
        double omega = Math.signum(this.speed) * (0.3141592653589793 - this.speed / (20.0 * this.radius));
        this.angle += omega;
        this.field_70179_y = this.radius * omega * Math.cos(this.angle);
        this.field_70159_w = this.radius * omega * Math.sin(this.angle);
        this.func_70091_d(this.field_70159_w + this.velX, 0.0, this.field_70179_y + this.velZ);
        if (this.gravity) {
            this.field_70181_x -= 0.05;
        }
        if (this.field_70546_d > this.field_70547_e / 2) {
            this.func_82338_g(1.0f - ((float)this.field_70546_d - (float)(this.field_70547_e / 2)) / (float)this.field_70547_e);
        }
    }

    public int func_70070_b(float par1) {
        return this.fullBrightness ? 0xF000F0 : super.func_70070_b(par1);
    }

    public float func_70013_c(float par1) {
        return this.fullBrightness ? 1.0f : super.func_70013_c(par1);
    }
}

