/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryRegistry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.living.EntitySummonedCreature;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.Spell;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityEvilWizard
extends EntityMob
implements IRangedAttackMob,
IEntityAdditionalSpawnData {
    private EntityAIArrowAttack aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 0.5, 20, 50, 14.0f);
    public int textureIndex = 0;
    public boolean hasTower = false;
    protected IEntitySelector targetSelector;
    private static final int healCooldownIndex = 20;
    private static final int elementIndex = 16;
    private int[] spells = new int[4];

    public EntityEvilWizard(World par1World) {
        super(par1World);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.targetSelector = new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                return entity != null && WizardryUtilities.isValidTarget((Entity)EntityEvilWizard.this, entity) && (entity instanceof EntityPlayer || (entity instanceof EntitySummonedCreature || entity instanceof EntityWizard || Arrays.asList(Wizardry.summonedCreatureTargetsWhitelist).contains(EntityList.func_75621_b((Entity)entity).toLowerCase(Locale.ROOT))) && !Arrays.asList(Wizardry.summonedCreatureTargetsBlacklist).contains(EntityList.func_75621_b((Entity)entity).toLowerCase(Locale.ROOT)));
            }
        };
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, this.targetSelector));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiArrowAttack);
        this.func_110177_bN();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        int healCooldown = this.field_70180_af.func_75679_c(20);
        if (healCooldown == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() > 0.0f && !this.func_70644_a(Wizardry.arcaneJammer)) {
            this.func_70691_i(this.getElement() == EnumElement.HEALING ? 8.0f : 4.0f);
            this.field_70180_af.func_75692_b(20, (Object)-1);
        } else if (healCooldown == -1 && this.field_70725_aQ == 0) {
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = (float)this.field_70165_t + this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                    double d1 = (float)this.field_70163_u - 0.5f + this.field_70146_Z.nextFloat();
                    double d2 = (float)this.field_70161_v + this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                    Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, this.field_70170_p, d0, d1, d2, 0.0, 0.1f, 0.0, 48 + this.field_70146_Z.nextInt(12), 1.0f, 1.0f, 0.3f);
                }
            } else {
                if (this.func_110143_aJ() < 10.0f) {
                    this.field_70180_af.func_75692_b(20, (Object)150);
                } else {
                    this.field_70180_af.func_75692_b(20, (Object)400);
                }
                this.field_70170_p.func_72956_a((Entity)this, "wizardry:heal", 0.7f, this.field_70146_Z.nextFloat() * 0.4f + 1.0f);
            }
        }
        if (healCooldown > 0) {
            this.field_70180_af.func_75692_b(20, (Object)(healCooldown - 1));
        }
    }

    public void func_82196_d(EntityLivingBase target, float f) {
        if (f < 30.0f && !this.func_70644_a(Wizardry.arcaneJammer)) {
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d2 = target.field_70161_v - this.field_70161_v;
            if (this.field_70724_aR == 0 && this.spells.length > 0 && !this.field_70170_p.field_72995_K) {
                ArrayList<Spell> spellsArray = new ArrayList<Spell>(this.spells.length);
                for (int i = 0; i < this.spells.length; ++i) {
                    spellsArray.add(Spell.get(this.spells[i]));
                }
                while (!spellsArray.isEmpty()) {
                    Spell spell = (Spell)spellsArray.get(this.field_70146_Z.nextInt(spellsArray.size()));
                    if (spell != null && spell.cast(this.field_70170_p, (EntityLiving)this, target, 1.0f, 1.0f, 1.0f, 1.0f)) {
                        if (spell.doesSpellRequirePacket()) {
                            PacketCastSpell.Message msg = new PacketCastSpell.Message(this.func_145782_y(), target.func_145782_y(), spell.id(), 1.0f, 1.0f, 1.0f);
                            WizardryPacketHandler.net.sendToDimension((IMessage)msg, this.field_70170_p.field_73011_w.field_76574_g);
                        }
                        this.field_70177_z = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
                        this.field_70787_b = true;
                        break;
                    }
                    spellsArray.remove(spell);
                }
            }
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (player.field_71075_bZ.field_75098_d && itemstack != null && itemstack.func_77973_b() instanceof ItemSpellBook && Spell.get(itemstack.func_77960_j()).canBeCastByNPCs()) {
            this.spells[this.field_70146_Z.nextInt((int)3) + 1] = itemstack.func_77960_j();
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound tagcompound) {
        super.func_70014_b(tagcompound);
        tagcompound.func_74768_a("element", this.getElement().ordinal());
        tagcompound.func_74768_a("skin", this.textureIndex);
        tagcompound.func_74783_a("spells", this.spells);
        tagcompound.func_74757_a("hasTower", this.hasTower);
    }

    public void func_70037_a(NBTTagCompound tagcompound) {
        super.func_70037_a(tagcompound);
        this.setElement(EnumElement.values()[tagcompound.func_74762_e("element")]);
        this.textureIndex = tagcompound.func_74762_e("skin");
        this.spells = tagcompound.func_74759_k("spells");
        this.hasTower = tagcompound.func_74767_n("hasTower");
    }

    protected boolean func_70692_ba() {
        return !this.hasTower;
    }

    protected String func_70639_aQ() {
        return "mob.villager.no";
    }

    protected String func_70621_aR() {
        return "mob.villager.hit";
    }

    protected String func_70673_aS() {
        return "mob.villager.death";
    }

    public EnumElement getElement() {
        return EnumElement.values()[this.field_70180_af.func_75679_c(16)];
    }

    public void setElement(EnumElement element) {
        this.field_70180_af.func_75692_b(16, (Object)element.ordinal());
    }

    protected void func_70628_a(boolean hitByPlayer, int lootingLevel) {
        int j = 3 + this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + lootingLevel);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(Wizardry.magicCrystal, 1);
        }
        if (this.spells.length > 0 && this.field_70146_Z.nextInt(100) - lootingLevel < 5) {
            this.func_70099_a(new ItemStack(Wizardry.spellBook, 1, this.spells[1 + this.field_70146_Z.nextInt(this.spells.length - 1)]), 0.0f);
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (source.func_76346_g() instanceof EntityPlayer) {
            ((EntityPlayer)source.func_76346_g()).func_71029_a((StatBase)Wizardry.defeatEvilWizard);
        }
    }

    public IEntityLivingData func_110161_a(IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.func_110161_a(par1EntityLivingData);
        this.textureIndex = this.field_70146_Z.nextInt(6);
        if (this.field_70146_Z.nextBoolean()) {
            this.setElement(EnumElement.values()[this.field_70146_Z.nextInt(EnumElement.values().length - 1) + 1]);
        } else {
            this.setElement(EnumElement.MAGIC);
        }
        EnumElement e = this.getElement();
        this.func_70062_b(1, new ItemStack(WizardryUtilities.getArmour(e, 3)));
        this.func_70062_b(2, new ItemStack(WizardryUtilities.getArmour(e, 2)));
        this.func_70062_b(3, new ItemStack(WizardryUtilities.getArmour(e, 1)));
        this.func_70062_b(4, new ItemStack(WizardryUtilities.getArmour(e, 0)));
        EnumTier maxTier = EnumTier.BASIC;
        this.func_96120_a(0, 0.1f);
        this.func_96120_a(1, 0.1f);
        this.func_96120_a(2, 0.1f);
        this.func_96120_a(3, 0.1f);
        this.func_96120_a(4, 0.1f);
        this.spells[0] = WizardryRegistry.magicMissile.id();
        List<Spell> npcSpells = Spell.getSpells(Spell.npcSpells);
        for (int i = 1; i < this.spells.length; ++i) {
            int j;
            EnumElement element = e == EnumElement.MAGIC ? EnumElement.values()[this.field_70146_Z.nextInt(EnumElement.values().length)] : e;
            int randomiser = this.field_70146_Z.nextInt(20);
            EnumTier tier = randomiser < 10 ? EnumTier.BASIC : (randomiser < 16 ? EnumTier.APPRENTICE : EnumTier.ADVANCED);
            if (tier.ordinal() > maxTier.ordinal()) {
                maxTier = tier;
            }
            List<Spell> list = Spell.getSpells(new Spell.TierElementFilter(tier, element));
            list.retainAll(npcSpells);
            for (j = 0; j < i; ++j) {
                list.remove(Spell.get(this.spells[j]));
            }
            if (list.isEmpty()) {
                list = npcSpells;
                for (j = 0; j < i; ++j) {
                    list.remove(Spell.get(this.spells[j]));
                }
            }
            if (list.isEmpty()) continue;
            this.spells[i] = list.get(this.field_70146_Z.nextInt(list.size())).id();
        }
        EnumTier tier = EnumTier.values()[maxTier.ordinal() + this.field_70146_Z.nextInt(EnumTier.values().length - maxTier.ordinal())];
        this.func_70062_b(0, new ItemStack(WizardryUtilities.getWand(tier, e)));
        return par1EntityLivingData;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.textureIndex);
    }

    public void readSpawnData(ByteBuf data) {
        this.textureIndex = data.readInt();
    }
}

