/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.spell.Spell;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;

public class PacketPlayerSync
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Wizardry.proxy.handlePlayerSyncPacket(message);
        }
        return null;
    }

    public static class Message
    implements IMessage {
        public HashSet<Spell> spellsDiscovered;
        public int selectedMinionID;

        public Message() {
        }

        public Message(HashSet<Spell> spellsDiscovered, int selectedMinionID) {
            this.spellsDiscovered = spellsDiscovered;
            this.selectedMinionID = selectedMinionID;
        }

        public void fromBytes(ByteBuf buf) {
            this.selectedMinionID = buf.readInt();
            this.spellsDiscovered = new HashSet();
            while (buf.isReadable()) {
                this.spellsDiscovered.add(Spell.get(buf.readInt()));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.selectedMinionID);
            if (this.spellsDiscovered == null) {
                return;
            }
            for (Spell spell : this.spellsDiscovered) {
                buf.writeInt(spell.id());
            }
        }
    }
}

