/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.spell.Spell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class Arc
extends Spell {
    public Arc() {
        super(EnumTier.BASIC, 5, EnumElement.LIGHTNING, "arc", EnumSpellType.ATTACK, 15, EnumAction.none, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        MovingObjectPosition rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 8.0f * rangeMultiplier, 4.0f);
        if (rayTrace != null && rayTrace.field_72308_g != null && rayTrace.field_72308_g instanceof EntityLivingBase) {
            Entity target = rayTrace.field_72308_g;
            if (!world.field_72995_K) {
                EntityArc arc = new EntityArc(world);
                arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + 1.0, caster.field_70161_v, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
                world.func_72838_d((Entity)arc);
            } else {
                for (int i = 0; i < 8; ++i) {
                    Wizardry.proxy.spawnParticle(EnumParticleType.SPARK, world, target.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos(target) + (double)(target.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, target.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                    world.func_72869_a("largesmoke", target.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos(target) + (double)(target.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, target.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0);
                }
            }
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, target)) {
                if (!world.field_72995_K) {
                    caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getDisplayNameWithFormatting()}));
                }
            } else {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.SHOCK), 3.0f * damageMultiplier);
            }
            caster.func_71038_i();
            world.func_72956_a(target, "wizardry:arc", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EntityLivingBase target, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        if (target != null) {
            if (!world.field_72995_K) {
                EntityArc arc = new EntityArc(world);
                arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + 1.0, caster.field_70161_v, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
                world.func_72838_d((Entity)arc);
            } else {
                for (int i = 0; i < 8; ++i) {
                    Wizardry.proxy.spawnParticle(EnumParticleType.SPARK, world, target.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos((Entity)target) + (double)(target.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, target.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                    world.func_72869_a("largesmoke", target.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos((Entity)target) + (double)(target.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, target.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0);
                }
            }
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.SHOCK), 3.0f * damageMultiplier);
            caster.func_71038_i();
            world.func_72956_a((Entity)target, "wizardry:arc", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

