/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.spell.Spell;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class Ignite
extends Spell {
    public Ignite() {
        super(EnumTier.BASIC, 5, EnumElement.FIRE, "ignite", EnumSpellType.ATTACK, 10, EnumAction.none, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        MovingObjectPosition rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * rangeMultiplier);
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)target)) {
                if (!world.field_72995_K) {
                    caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getDisplayNameWithFormatting()}));
                }
            } else {
                target.func_70015_d((int)(10.0f * durationMultiplier));
            }
            if (world.field_72995_K) {
                double dx = target.field_70165_t - caster.field_70165_t;
                double dy = WizardryUtilities.getEntityFeetPos((Entity)target) + (double)(target.field_70131_O / 2.0f) - WizardryUtilities.getPlayerEyesPos(caster);
                double dz = target.field_70161_v - caster.field_70161_v;
                for (int i = 1; i < 5; ++i) {
                    world.func_72869_a("flame", caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0);
                }
            }
            caster.func_71038_i();
            world.func_72908_a(caster.field_70165_t + 0.5, caster.field_70163_u + 1.5, caster.field_70161_v + 0.5, "fire.ignite", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        rayTrace = WizardryUtilities.rayTrace(10.0f * rangeMultiplier, world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int blockHitX = rayTrace.field_72311_b;
            int blockHitY = rayTrace.field_72312_c;
            int blockHitZ = rayTrace.field_72309_d;
            int blockHitSide = rayTrace.field_72310_e;
            boolean flag = false;
            switch (blockHitSide) {
                case 0: {
                    if (!world.func_147437_c(blockHitX, blockHitY - 1, blockHitZ)) break;
                    if (!world.field_72995_K) {
                        world.func_147449_b(blockHitX, blockHitY - 1, blockHitZ, (Block)Blocks.field_150480_ab);
                    }
                    flag = true;
                    break;
                }
                case 1: {
                    if (!world.func_147437_c(blockHitX, blockHitY + 1, blockHitZ)) break;
                    if (!world.field_72995_K) {
                        world.func_147449_b(blockHitX, blockHitY + 1, blockHitZ, (Block)Blocks.field_150480_ab);
                    }
                    flag = true;
                    break;
                }
                case 2: {
                    if (!world.func_147437_c(blockHitX, blockHitY, blockHitZ - 1)) break;
                    if (!world.field_72995_K) {
                        world.func_147449_b(blockHitX, blockHitY, blockHitZ - 1, (Block)Blocks.field_150480_ab);
                    }
                    flag = true;
                    break;
                }
                case 3: {
                    if (!world.func_147437_c(blockHitX, blockHitY, blockHitZ + 1)) break;
                    if (!world.field_72995_K) {
                        world.func_147449_b(blockHitX, blockHitY, blockHitZ + 1, (Block)Blocks.field_150480_ab);
                    }
                    flag = true;
                    break;
                }
                case 4: {
                    if (!world.func_147437_c(blockHitX - 1, blockHitY, blockHitZ)) break;
                    if (!world.field_72995_K) {
                        world.func_147449_b(blockHitX - 1, blockHitY, blockHitZ, (Block)Blocks.field_150480_ab);
                    }
                    flag = true;
                    break;
                }
                case 5: {
                    if (!world.func_147437_c(blockHitX + 1, blockHitY, blockHitZ)) break;
                    if (!world.field_72995_K) {
                        world.func_147449_b(blockHitX + 1, blockHitY, blockHitZ, (Block)Blocks.field_150480_ab);
                    }
                    flag = true;
                }
            }
            if (flag) {
                double dx = (double)blockHitX + 0.5 - caster.field_70165_t;
                double dy = (double)blockHitY + 1.5 - (WizardryUtilities.getPlayerEyesPos(caster) + 1.0);
                double dz = (double)blockHitZ + 0.5 - caster.field_70161_v;
                if (world.field_72995_K) {
                    for (int i = 1; i < 5; ++i) {
                        world.func_72869_a("flame", caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0);
                        world.func_72869_a("flame", caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0);
                    }
                }
                caster.func_71038_i();
                world.func_72908_a(caster.field_70165_t + 0.5, caster.field_70163_u + 1.5, caster.field_70161_v + 0.5, "fire.ignite", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EntityLivingBase target, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        if (target != null) {
            if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)target)) {
                target.func_70015_d((int)(10.0f * durationMultiplier));
            }
            if (world.field_72995_K) {
                double dx = target.field_70165_t - caster.field_70165_t;
                double dy = WizardryUtilities.getEntityFeetPos((Entity)target) + (double)(target.field_70131_O / 2.0f) - (caster.field_70163_u + (double)caster.func_70047_e());
                double dz = target.field_70161_v - caster.field_70161_v;
                for (int i = 1; i < 5; ++i) {
                    world.func_72869_a("flame", caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70163_u + (double)caster.func_70047_e() + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70163_u + (double)caster.func_70047_e() + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0);
                }
            }
            caster.func_71038_i();
            world.func_72908_a(caster.field_70165_t + 0.5, caster.field_70163_u + 1.5, caster.field_70161_v + 0.5, "fire.ignite", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

