/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.properties;

import com.google.common.base.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import journeymap.client.properties.MapProperties;
import journeymap.client.properties.config.Config;
import journeymap.client.ui.option.LocationFormat;

public abstract class InGameMapProperties
extends MapProperties {
    @Config(category=Config.Category.Inherit, key="jm.common.show_caves", defaultBoolean=true)
    public final AtomicBoolean showCaves = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.common.font_scale", minValue=1.0, maxValue=4.0, defaultValue=1.0)
    public final AtomicInteger fontScale = new AtomicInteger(1);
    @Config(category=Config.Category.Inherit, key="jm.minimap.texture_size")
    public final AtomicBoolean textureSmall = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.minimap.show_waypointlabels")
    public final AtomicBoolean showWaypointLabels = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.common.location_format_verbose")
    public final AtomicBoolean locationFormatVerbose = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.common.location_format", stringListProvider=LocationFormat.IdProvider.class)
    public final AtomicReference<String> locationFormat = new AtomicReference<String>(new LocationFormat.IdProvider().getDefaultString());
    @Config(category=Config.Category.Inherit, key="jm.minimap.mob_heading")
    public final AtomicBoolean showMobHeading = new AtomicBoolean(true);
    @Config(category=Config.Category.Inherit, key="jm.minimap.player_heading")
    public final AtomicBoolean showPlayerHeading = new AtomicBoolean(true);

    protected InGameMapProperties() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InGameMapProperties that = (InGameMapProperties)o;
        return this.compareTo(that) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.showCaves.hashCode();
        result = 31 * result + this.fontScale.hashCode();
        result = 31 * result + this.textureSmall.hashCode();
        result = 31 * result + this.showWaypointLabels.hashCode();
        result = 31 * result + this.locationFormatVerbose.hashCode();
        result = 31 * result + this.locationFormat.hashCode();
        result = 31 * result + this.showMobHeading.hashCode();
        result = 31 * result + this.showPlayerHeading.hashCode();
        return result;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper(MapProperties me) {
        return super.toStringHelper(me).add("fontScale", (Object)this.fontScale).add("locationFormat", this.locationFormat).add("locationFormatVerbose", (Object)this.locationFormatVerbose).add("showCaves", (Object)this.showCaves).add("showWaypointLabels", (Object)this.showWaypointLabels).add("showMobHeading", (Object)this.showMobHeading).add("showPlayerHeading", (Object)this.showPlayerHeading).add("textureSmall", (Object)this.textureSmall);
    }
}

