/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.client.model.ModelVehicle;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;

public class VehicleType
extends DriveableType {
    public float turnLeftModifier = 1.0f;
    public float turnRightModifier = 1.0f;
    public boolean squashMobs = false;
    public boolean fourWheelDrive = false;
    public boolean rotateWheels = false;
    public boolean tank = false;
    public int vehicleShootDelay;
    public int vehicleShellDelay;
    public boolean hasDoor = false;
    public static ArrayList<VehicleType> types = new ArrayList();

    public VehicleType(TypeFile file) {
        super(file);
        types.add(this);
    }

    @Override
    public void preRead(TypeFile file) {
        super.preRead(file);
        this.wheelPositions = new DriveablePosition[4];
    }

    @Override
    protected void postRead(TypeFile file) {
        super.postRead(file);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (split[0].equals("TurnLeftSpeed")) {
                this.turnLeftModifier = Float.parseFloat(split[1]);
            }
            if (split[0].equals("TurnRightSpeed")) {
                this.turnRightModifier = Float.parseFloat(split[1]);
            }
            if (split[0].equals("SquashMobs")) {
                this.squashMobs = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("FourWheelDrive")) {
                this.fourWheelDrive = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("Tank") || split[0].equals("TankMode")) {
                this.tank = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("HasDoor")) {
                this.hasDoor = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("RotateWheels")) {
                this.rotateWheels = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("ShootDelay")) {
                this.vehicleShootDelay = Integer.parseInt(split[1]);
            }
            if (split[0].equals("ShellDelay")) {
                this.vehicleShellDelay = Integer.parseInt(split[1]);
            }
            if (split[0].equals("ShootSound")) {
                this.shootSoundPrimary = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
            }
            if (split[0].equals("ShellSound")) {
                this.shootSoundSecondary = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static VehicleType getVehicle(String find) {
        for (VehicleType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelVehicle.class);
    }
}

