/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import foxz.command.CommandNoppes;
import java.io.File;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockVine;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import nikedemos.markovnames.generators.MarkovAncientGreek;
import nikedemos.markovnames.generators.MarkovAztec;
import nikedemos.markovnames.generators.MarkovCustomNPCsClassic;
import nikedemos.markovnames.generators.MarkovGenerator;
import nikedemos.markovnames.generators.MarkovJapanese;
import nikedemos.markovnames.generators.MarkovOldNorse;
import nikedemos.markovnames.generators.MarkovRoman;
import nikedemos.markovnames.generators.MarkovSaami;
import nikedemos.markovnames.generators.MarkovSlavic;
import nikedemos.markovnames.generators.MarkovSpanish;
import nikedemos.markovnames.generators.MarkovWelsh;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.LogWriter;
import noppes.npcs.ScriptForgeEventHandler;
import noppes.npcs.ScriptPlayerEventHandler;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.ServerTickHandler;
import noppes.npcs.config.ConfigLoader;
import noppes.npcs.config.ConfigProp;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.ChunkController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.GlobalDataController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.enchants.EnchantInterface;
import noppes.npcs.entity.EntityChairMount;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityMagicProjectile;
import noppes.npcs.entity.EntityNPCGolem;
import noppes.npcs.entity.EntityNpcCrystal;
import noppes.npcs.entity.EntityNpcDragon;
import noppes.npcs.entity.EntityNpcPony;
import noppes.npcs.entity.EntityNpcSlime;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.entity.old.EntityNPCDwarfFemale;
import noppes.npcs.entity.old.EntityNPCDwarfMale;
import noppes.npcs.entity.old.EntityNPCElfFemale;
import noppes.npcs.entity.old.EntityNPCElfMale;
import noppes.npcs.entity.old.EntityNPCEnderman;
import noppes.npcs.entity.old.EntityNPCFurryFemale;
import noppes.npcs.entity.old.EntityNPCFurryMale;
import noppes.npcs.entity.old.EntityNPCHumanFemale;
import noppes.npcs.entity.old.EntityNPCHumanMale;
import noppes.npcs.entity.old.EntityNPCOrcFemale;
import noppes.npcs.entity.old.EntityNPCOrcMale;
import noppes.npcs.entity.old.EntityNPCVillager;
import noppes.npcs.entity.old.EntityNpcEnderchibi;
import noppes.npcs.entity.old.EntityNpcMonsterFemale;
import noppes.npcs.entity.old.EntityNpcMonsterMale;
import noppes.npcs.entity.old.EntityNpcNagaFemale;
import noppes.npcs.entity.old.EntityNpcNagaMale;
import noppes.npcs.entity.old.EntityNpcSkeleton;
import noppes.npcs.scripted.wrapper.WrapperNpcAPI;

@Mod(modid="customnpcs", name="CustomNpcs", version="1.5.1-beta")
public class CustomNpcs {
    @ConfigProp(info="Disable Chat Bubbles")
    public static boolean EnableChatBubbles = true;
    private static int NewEntityStartId = 0;
    @ConfigProp(info="Navigation search range for NPCs. Not recommended to increase if you have a slow pc or on a server. Minimum of 16, maximum of 96.")
    public static int NpcNavRange = 32;
    @ConfigProp(info="Size limit for NPCs. Default 100, larger sizes may cause lag on clients and servers that can't take it!")
    public static int NpcSizeLimit = 100;
    @ConfigProp(info="Set to true if you want the dialog command option to be able to use op commands like tp etc")
    public static boolean NpcUseOpCommands = false;
    @ConfigProp(info="The amount of time that passes before a player's quests are checked for completion in seconds.")
    public static int PlayerQuestCheck = 300;
    @ConfigProp
    public static boolean InventoryGuiEnabled = true;
    @ConfigProp
    public static boolean DisableExtraItems = false;
    @ConfigProp
    public static boolean DisableExtraBlock = false;
    public static long ticks;
    @SidedProxy(clientSide="noppes.npcs.client.ClientProxy", serverSide="noppes.npcs.CommonProxy")
    public static CommonProxy proxy;
    @ConfigProp(info="Enables CustomNpcs startup update message")
    public static boolean EnableUpdateChecker;
    public static CustomNpcs instance;
    public static boolean FreezeNPCs;
    @ConfigProp(info="Only ops can create and edit npcs")
    public static boolean OpsOnly;
    @ConfigProp(info="Default interact line. Leave empty to not have one")
    public static String DefaultInteractLine;
    @ConfigProp
    public static boolean DisableEnchants;
    @ConfigProp(info="Start Id for enchants. IDs can only range from 0-256")
    public static int EnchantStartId;
    @ConfigProp(info="Number of chunk loading npcs that can be active at the same time")
    public static int ChuckLoaders;
    public static File Dir;
    @ConfigProp(info="Set to false if you want to disable guns")
    public static boolean GunsEnabled;
    @ConfigProp(info="Enables leaves decay")
    public static boolean LeavesDecayEnabled;
    @ConfigProp(info="Enables Vine Growth")
    public static boolean VineGrowthEnabled;
    @ConfigProp(info="Enables Ice Melting")
    public static boolean IceMeltsEnabled;
    @ConfigProp(info="Normal players can use soulstone on animals")
    public static boolean SoulStoneAnimals;
    @ConfigProp(info="Normal players can use soulstone on all npcs")
    public static boolean SoulStoneNPCs;
    @ConfigProp(info="When set to Minecraft it will use minecrafts font, when Default it will use OpenSans. Can only use fonts installed on your PC")
    public static String FontType;
    @ConfigProp(info="Font size for custom fonts (doesn't work with minecrafts font)")
    public static int FontSize;
    public static FMLEventChannel Channel;
    public static FMLEventChannel ChannelPlayer;
    public static ConfigLoader Config;
    public static final MarkovGenerator[] MARKOV_GENERATOR;

    public CustomNpcs() {
        instance = this;
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent ev) {
        Channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("CustomNPCs");
        ChannelPlayer = NetworkRegistry.INSTANCE.newEventDrivenChannel("CustomNPCsPlayer");
        MinecraftServer server = MinecraftServer.func_71276_C();
        String dir = "";
        dir = server != null ? new File(".").getAbsolutePath() : Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
        Dir = new File(dir, "customnpcs");
        Dir.mkdir();
        Config = new ConfigLoader(this.getClass(), new File(dir, "config"), "CustomNpcs");
        Config.loadConfig();
        if (NpcNavRange < 16) {
            NpcNavRange = 16;
        }
        if (NpcNavRange > 96) {
            NpcNavRange = 96;
        }
        if (NpcSizeLimit < 1) {
            NpcSizeLimit = 1;
        }
        if (PlayerQuestCheck < 1) {
            PlayerQuestCheck = 1;
        }
        EnchantInterface.load();
        CustomItems.load();
        proxy.load();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventsHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ScriptController());
        ScriptPlayerEventHandler scriptPlayerEventHandler = new ScriptPlayerEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)scriptPlayerEventHandler);
        FMLCommonHandler.instance().bus().register((Object)scriptPlayerEventHandler);
        ScriptForgeEventHandler forgeEventHandler = new ScriptForgeEventHandler().registerForgeEvents();
        MinecraftForge.EVENT_BUS.register((Object)forgeEventHandler);
        FMLCommonHandler.instance().bus().register((Object)forgeEventHandler);
        FMLCommonHandler.instance().bus().register((Object)new ServerTickHandler());
        this.registerNpc(EntityNPCHumanMale.class, "npchumanmale");
        this.registerNpc(EntityNPCVillager.class, "npcvillager");
        this.registerNpc(EntityNpcPony.class, "npcpony");
        this.registerNpc(EntityNPCHumanFemale.class, "npchumanfemale");
        this.registerNpc(EntityNPCDwarfMale.class, "npcdwarfmale");
        this.registerNpc(EntityNPCFurryMale.class, "npcfurrymale");
        this.registerNpc(EntityNpcMonsterMale.class, "npczombiemale");
        this.registerNpc(EntityNpcMonsterFemale.class, "npczombiefemale");
        this.registerNpc(EntityNpcSkeleton.class, "npcskeleton");
        this.registerNpc(EntityNPCDwarfFemale.class, "npcdwarffemale");
        this.registerNpc(EntityNPCFurryFemale.class, "npcfurryfemale");
        this.registerNpc(EntityNPCOrcMale.class, "npcorcfmale");
        this.registerNpc(EntityNPCOrcFemale.class, "npcorcfemale");
        this.registerNpc(EntityNPCElfMale.class, "npcelfmale");
        this.registerNpc(EntityNPCElfFemale.class, "npcelffemale");
        this.registerNpc(EntityNpcCrystal.class, "npccrystal");
        this.registerNpc(EntityNpcEnderchibi.class, "npcenderchibi");
        this.registerNpc(EntityNpcNagaMale.class, "npcnagamale");
        this.registerNpc(EntityNpcNagaFemale.class, "npcnagafemale");
        this.registerNpc(EntityNpcSlime.class, "NpcSlime");
        this.registerNpc(EntityNpcDragon.class, "NpcDragon");
        this.registerNpc(EntityNPCEnderman.class, "npcEnderman");
        this.registerNpc(EntityNPCGolem.class, "npcGolem");
        this.registerNpc(EntityCustomNpc.class, "CustomNpc");
        this.registerNewEntity(EntityChairMount.class, "CustomNpcChairMount", 64, 10, false);
        this.registerNewEntity(EntityProjectile.class, "throwableitem", 64, 3, true);
        this.registerNewEntity(EntityMagicProjectile.class, "magicprojectile", 64, 3, true);
        new RecipeController();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkController());
        new CustomNpcsPermissions();
        PixelmonHelper.load();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent ev) {
        CustomNpcs.MARKOV_GENERATOR[0] = new MarkovRoman(3);
        CustomNpcs.MARKOV_GENERATOR[1] = new MarkovJapanese(4);
        CustomNpcs.MARKOV_GENERATOR[2] = new MarkovSlavic(3);
        CustomNpcs.MARKOV_GENERATOR[3] = new MarkovWelsh(3);
        CustomNpcs.MARKOV_GENERATOR[4] = new MarkovSaami(3);
        CustomNpcs.MARKOV_GENERATOR[5] = new MarkovOldNorse(4);
        CustomNpcs.MARKOV_GENERATOR[6] = new MarkovAncientGreek(3);
        CustomNpcs.MARKOV_GENERATOR[7] = new MarkovAztec(3);
        CustomNpcs.MARKOV_GENERATOR[8] = new MarkovCustomNPCsClassic(3);
        CustomNpcs.MARKOV_GENERATOR[9] = new MarkovSpanish(3);
    }

    @Mod.EventHandler
    public void setAboutToStart(FMLServerAboutToStartEvent event) {
        ChunkController.instance.clear();
        new QuestController();
        new PlayerDataController();
        new FactionController();
        new TransportController();
        new GlobalDataController();
        new SpawnController();
        new LinkedNpcController();
        ScriptController.Instance.loadStoredData();
        ScriptController.Instance.loadForgeScripts();
        ScriptController.Instance.loadPlayerScripts();
        ScriptController.HasStart = false;
        WrapperNpcAPI.clearCache();
        Set names = Block.field_149771_c.func_148742_b();
        for (String name : names) {
            Block block = (Block)Block.field_149771_c.func_82594_a(name);
            if (block instanceof BlockLeavesBase) {
                block.func_149675_a(LeavesDecayEnabled);
            }
            if (block instanceof BlockVine) {
                block.func_149675_a(VineGrowthEnabled);
            }
            if (!(block instanceof BlockIce)) continue;
            block.func_149675_a(IceMeltsEnabled);
        }
    }

    @Mod.EventHandler
    public void started(FMLServerStartedEvent event) {
        RecipeController.instance.load();
        new DialogController();
        new BankController();
        QuestController.instance.load();
        ScriptController.HasStart = true;
        ServerCloneController.Instance = new ServerCloneController();
    }

    @Mod.EventHandler
    public void stopped(FMLServerStoppedEvent event) {
        ServerCloneController.Instance = null;
    }

    @Mod.EventHandler
    public void serverstart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandNoppes());
    }

    private void registerNpc(Class<? extends Entity> cl, String name) {
        EntityRegistry.registerModEntity(cl, (String)name, (int)NewEntityStartId++, (Object)this, (int)64, (int)3, (boolean)true);
        EntityList.field_75625_b.put(name, cl);
    }

    private void registerNewEntity(Class<? extends Entity> cl, String name, int range, int update, boolean velocity) {
        EntityRegistry.registerModEntity(cl, (String)name, (int)NewEntityStartId++, (Object)this, (int)range, (int)update, (boolean)velocity);
    }

    public static File getWorldSaveDirectory() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        File saves = new File(".");
        if (server != null && !server.func_71262_S()) {
            saves = new File(Minecraft.func_71410_x().field_71412_D, "saves");
        }
        if (server != null) {
            File savedir = new File(new File(saves, server.func_71270_I()), "customnpcs");
            if (!savedir.exists()) {
                savedir.mkdir();
            }
            return savedir;
        }
        return null;
    }

    public static File getWorldSaveDirectory(String s) {
        try {
            File dir = new File(".");
            if (CustomNpcs.getServer() != null) {
                if (!CustomNpcs.getServer().func_71262_S()) {
                    dir = new File(Minecraft.func_71410_x().field_71412_D, "saves");
                }
                dir = new File(new File(dir, CustomNpcs.getServer().func_71270_I()), "customnpcs");
            }
            if (s != null) {
                dir = new File(dir, s);
            }
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
        catch (Exception var2) {
            LogWriter.error("Error getting worldsave", var2);
            return null;
        }
    }

    public static MinecraftServer getServer() {
        return MinecraftServer.func_71276_C();
    }

    static {
        EnableUpdateChecker = true;
        FreezeNPCs = false;
        OpsOnly = false;
        DefaultInteractLine = "Hello @p";
        DisableEnchants = false;
        EnchantStartId = 100;
        ChuckLoaders = 20;
        GunsEnabled = true;
        LeavesDecayEnabled = true;
        VineGrowthEnabled = true;
        IceMeltsEnabled = true;
        SoulStoneAnimals = true;
        SoulStoneNPCs = false;
        FontType = "Default";
        FontSize = 18;
        MARKOV_GENERATOR = new MarkovGenerator[10];
    }
}

