/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.pathfinder;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import noppes.npcs.ai.pathfinder.FlyPath;
import noppes.npcs.ai.pathfinder.FlyPathEntity;
import noppes.npcs.ai.pathfinder.FlyPathPoint;

public class FlyPathFinder
extends PathFinder {
    private IBlockAccess worldMap;
    private FlyPath path = new FlyPath();
    private IntHashMap pointMap = new IntHashMap();
    private FlyPathPoint[] pathOptions = new FlyPathPoint[32];
    private boolean isWoddenDoorAllowed;
    private boolean isMovementBlockAllowed;
    private boolean isPathingInWater;
    private boolean canEntityDrown;
    private static final String __OBFID = "CL_00000576";

    public FlyPathFinder(IBlockAccess p_i2137_1_, boolean p_i2137_2_, boolean p_i2137_3_, boolean p_i2137_4_, boolean p_i2137_5_) {
        super(p_i2137_1_, p_i2137_2_, p_i2137_3_, p_i2137_4_, p_i2137_5_);
        this.worldMap = p_i2137_1_;
        this.isWoddenDoorAllowed = p_i2137_2_;
        this.isMovementBlockAllowed = p_i2137_3_;
        this.isPathingInWater = p_i2137_4_;
        this.canEntityDrown = p_i2137_5_;
    }

    public FlyPathEntity createEntityPathTo(Entity p_75856_1_, Entity p_75856_2_, float p_75856_3_) {
        return this.createEntityPathTo(p_75856_1_, p_75856_2_.field_70165_t, p_75856_2_.field_70121_D.field_72338_b, p_75856_2_.field_70161_v, p_75856_3_);
    }

    public FlyPathEntity createEntityPathTo(Entity p_75859_1_, int p_75859_2_, int p_75859_3_, int p_75859_4_, float p_75859_5_) {
        return this.createEntityPathTo(p_75859_1_, (float)p_75859_2_ + 0.5f, (float)p_75859_3_ + 0.5f, (float)p_75859_4_ + 0.5f, p_75859_5_);
    }

    private FlyPathEntity createEntityPathTo(Entity p_75857_1_, double p_75857_2_, double p_75857_4_, double p_75857_6_, float p_75857_8_) {
        this.path.clearPath();
        this.pointMap.func_76046_c();
        boolean flag = this.isPathingInWater;
        int i = MathHelper.func_76128_c((double)(p_75857_1_.field_70121_D.field_72338_b + 0.5));
        if (this.canEntityDrown && p_75857_1_.func_70090_H()) {
            i = (int)p_75857_1_.field_70121_D.field_72338_b;
            Block block = this.worldMap.func_147439_a(MathHelper.func_76128_c((double)p_75857_1_.field_70165_t), i, MathHelper.func_76128_c((double)p_75857_1_.field_70161_v));
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                block = this.worldMap.func_147439_a(MathHelper.func_76128_c((double)p_75857_1_.field_70165_t), ++i, MathHelper.func_76128_c((double)p_75857_1_.field_70161_v));
            }
            flag = this.isPathingInWater;
            this.isPathingInWater = false;
        } else {
            i = MathHelper.func_76128_c((double)(p_75857_1_.field_70121_D.field_72338_b + 0.5));
        }
        FlyPathPoint pathpoint2 = this.openPoint(MathHelper.func_76128_c((double)p_75857_1_.field_70121_D.field_72340_a), i, MathHelper.func_76128_c((double)p_75857_1_.field_70121_D.field_72339_c));
        FlyPathPoint pathpoint = this.openPoint(MathHelper.func_76128_c((double)(p_75857_2_ - (double)(p_75857_1_.field_70130_N / 2.0f))), MathHelper.func_76128_c((double)p_75857_4_), MathHelper.func_76128_c((double)(p_75857_6_ - (double)(p_75857_1_.field_70130_N / 2.0f))));
        FlyPathPoint pathpoint1 = new FlyPathPoint(MathHelper.func_76141_d((float)(p_75857_1_.field_70130_N + 1.0f)), MathHelper.func_76141_d((float)(p_75857_1_.field_70131_O + 1.0f)), MathHelper.func_76141_d((float)(p_75857_1_.field_70130_N + 1.0f)));
        FlyPathEntity pathentity = this.addToPath(p_75857_1_, pathpoint2, pathpoint, pathpoint1, p_75857_8_);
        this.isPathingInWater = flag;
        return pathentity;
    }

    private FlyPathEntity addToPath(Entity p_75861_1_, FlyPathPoint p_75861_2_, FlyPathPoint p_75861_3_, FlyPathPoint p_75861_4_, float p_75861_5_) {
        p_75861_2_.field_75836_e = 0.0f;
        p_75861_2_.field_75834_g = p_75861_2_.field_75833_f = p_75861_2_.func_75832_b(p_75861_3_);
        this.path.clearPath();
        this.path.addPoint(p_75861_2_);
        FlyPathPoint pathpoint3 = p_75861_2_;
        while (!this.path.isPathEmpty()) {
            FlyPathPoint pathpoint4 = this.path.dequeue();
            if (pathpoint4.equals((Object)p_75861_3_)) {
                return this.createEntityPath(p_75861_2_, p_75861_3_);
            }
            if (pathpoint4.func_75832_b(p_75861_3_) < pathpoint3.func_75832_b(p_75861_3_)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.field_75842_i = true;
            int i = this.findPathOptions(p_75861_1_, pathpoint4, p_75861_4_, p_75861_3_, p_75861_5_);
            for (int j = 0; j < i; ++j) {
                FlyPathPoint pathpoint5 = this.pathOptions[j];
                float f1 = pathpoint4.field_75836_e + pathpoint4.func_75832_b(pathpoint5);
                if (pathpoint5.func_75831_a() && !(f1 < pathpoint5.field_75836_e)) continue;
                pathpoint5.field_75841_h = pathpoint4;
                pathpoint5.field_75836_e = f1;
                pathpoint5.field_75833_f = pathpoint5.func_75832_b(p_75861_3_);
                if (pathpoint5.func_75831_a()) {
                    this.path.changeDistance(pathpoint5, pathpoint5.field_75836_e + pathpoint5.field_75833_f);
                    continue;
                }
                pathpoint5.field_75834_g = pathpoint5.field_75836_e + pathpoint5.field_75833_f;
                this.path.addPoint(pathpoint5);
            }
        }
        if (pathpoint3 == p_75861_2_) {
            return null;
        }
        return this.createEntityPath(p_75861_2_, pathpoint3);
    }

    private int findPathOptions(Entity p_75860_1_, FlyPathPoint p_75860_2_, FlyPathPoint p_75860_3_, FlyPathPoint p_75860_4_, float p_75860_5_) {
        int i = 0;
        int b0 = 0;
        if (this.getVerticalOffset(p_75860_1_, p_75860_2_.field_75839_a, p_75860_2_.field_75837_b + 1, p_75860_2_.field_75838_c, p_75860_3_) == 1) {
            b0 = 1;
        }
        FlyPathPoint pathpoint3 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a, p_75860_2_.field_75837_b, p_75860_2_.field_75838_c + 1, p_75860_3_, b0);
        FlyPathPoint pathpoint4 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a - 1, p_75860_2_.field_75837_b, p_75860_2_.field_75838_c, p_75860_3_, b0);
        FlyPathPoint pathpoint5 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a + 1, p_75860_2_.field_75837_b, p_75860_2_.field_75838_c, p_75860_3_, b0);
        FlyPathPoint pathpoint6 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a, p_75860_2_.field_75837_b, p_75860_2_.field_75838_c - 1, p_75860_3_, b0);
        FlyPathPoint pathpoint7 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a, p_75860_2_.field_75837_b + 1, p_75860_2_.field_75838_c + 1, p_75860_3_, b0);
        FlyPathPoint pathpoint8 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a - 1, p_75860_2_.field_75837_b + 1, p_75860_2_.field_75838_c, p_75860_3_, b0);
        FlyPathPoint pathpoint9 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a + 1, p_75860_2_.field_75837_b + 1, p_75860_2_.field_75838_c, p_75860_3_, b0);
        FlyPathPoint pathpoint10 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a, p_75860_2_.field_75837_b + 1, p_75860_2_.field_75838_c - 1, p_75860_3_, b0);
        FlyPathPoint pathpoint11 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a, p_75860_2_.field_75837_b - 1, p_75860_2_.field_75838_c + 1, p_75860_3_, b0);
        FlyPathPoint pathpoint12 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a - 1, p_75860_2_.field_75837_b - 1, p_75860_2_.field_75838_c, p_75860_3_, b0);
        FlyPathPoint pathpoint13 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a + 1, p_75860_2_.field_75837_b - 1, p_75860_2_.field_75838_c, p_75860_3_, b0);
        FlyPathPoint pathpoint14 = this.getSafePoint(p_75860_1_, p_75860_2_.field_75839_a, p_75860_2_.field_75837_b - 1, p_75860_2_.field_75838_c - 1, p_75860_3_, b0);
        if (pathpoint3 != null && !pathpoint3.field_75842_i && pathpoint3.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint3;
        }
        if (pathpoint4 != null && !pathpoint4.field_75842_i && pathpoint4.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint4;
        }
        if (pathpoint5 != null && !pathpoint5.field_75842_i && pathpoint5.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint5;
        }
        if (pathpoint6 != null && !pathpoint6.field_75842_i && pathpoint6.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint6;
        }
        if (pathpoint7 != null && !pathpoint7.field_75842_i && pathpoint7.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint7;
        }
        if (pathpoint8 != null && !pathpoint8.field_75842_i && pathpoint8.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint8;
        }
        if (pathpoint9 != null && !pathpoint9.field_75842_i && pathpoint9.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint9;
        }
        if (pathpoint10 != null && !pathpoint10.field_75842_i && pathpoint10.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint10;
        }
        if (pathpoint11 != null && !pathpoint11.field_75842_i && pathpoint11.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint11;
        }
        if (pathpoint12 != null && !pathpoint12.field_75842_i && pathpoint12.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint12;
        }
        if (pathpoint13 != null && !pathpoint13.field_75842_i && pathpoint13.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint13;
        }
        if (pathpoint14 != null && !pathpoint14.field_75842_i && pathpoint14.func_75829_a(p_75860_4_) < p_75860_5_) {
            this.pathOptions[i++] = pathpoint14;
        }
        return i;
    }

    private FlyPathPoint getSafePoint(Entity entity, int blockX, int blockY, int blockZ, FlyPathPoint pathPoint, int verticalOffsetFlag) {
        FlyPathPoint pathpoint1 = null;
        int verticalOffset = this.getVerticalOffset(entity, blockX, blockY, blockZ, pathPoint);
        if (verticalOffset == 2) {
            return this.openPoint(blockX, blockY, blockZ);
        }
        if (verticalOffset == 1) {
            pathpoint1 = this.openPoint(blockX, blockY, blockZ);
        }
        if (pathpoint1 == null && verticalOffsetFlag > 0 && verticalOffset != -3 && verticalOffset != -4 && this.getVerticalOffset(entity, blockX, blockY + verticalOffsetFlag, blockZ, pathPoint) == 1) {
            pathpoint1 = this.openPoint(blockX, blockY + verticalOffsetFlag, blockZ);
            blockY += verticalOffsetFlag;
        }
        if (pathpoint1 != null) {
            int j1 = 0;
            int k1 = 0;
            while (blockY > 0) {
                k1 = this.getVerticalOffset(entity, blockX, blockY - 1, blockZ, pathPoint);
                if (this.isPathingInWater && k1 == -1) {
                    return null;
                }
                if (k1 != 1) break;
                if (j1++ >= entity.func_82143_as()) {
                    return null;
                }
                if (--blockY <= 0) continue;
                pathpoint1 = this.openPoint(blockX, blockY, blockZ);
            }
            if (k1 == -2) {
                return null;
            }
        }
        return pathpoint1;
    }

    private final FlyPathPoint openPoint(int p_75854_1_, int p_75854_2_, int p_75854_3_) {
        int l = FlyPathPoint.makeHash(p_75854_1_, p_75854_2_, p_75854_3_);
        FlyPathPoint pathpoint = (FlyPathPoint)((Object)this.pointMap.func_76041_a(l));
        if (pathpoint == null) {
            pathpoint = new FlyPathPoint(p_75854_1_, p_75854_2_, p_75854_3_);
            this.pointMap.func_76038_a(l, (Object)pathpoint);
        }
        return pathpoint;
    }

    public int getVerticalOffset(Entity p_75855_1_, int p_75855_2_, int p_75855_3_, int p_75855_4_, FlyPathPoint p_75855_5_) {
        return FlyPathFinder.canEntityStandAt(p_75855_1_, p_75855_2_, p_75855_3_, p_75855_4_, p_75855_5_, this.isPathingInWater, this.isMovementBlockAllowed, this.isWoddenDoorAllowed);
    }

    public static int canEntityStandAt(Entity entity, int blockX, int blockY, int blockZ, FlyPathPoint pathPoint, boolean isPathingInWater, boolean isMovementBlockAllowed, boolean isWoddenDoorAllowed) {
        boolean flag3 = false;
        for (int l = blockX; l < blockX + pathPoint.field_75839_a; ++l) {
            for (int i1 = blockY; i1 < blockY + pathPoint.field_75837_b; ++i1) {
                for (int j1 = blockZ; j1 < blockZ + pathPoint.field_75838_c; ++j1) {
                    Block block = entity.field_70170_p.func_147439_a(l, i1, j1);
                    if (block == Blocks.field_150350_a) {
                        return 2;
                    }
                    if (block == Blocks.field_150415_aT) {
                        flag3 = true;
                    } else if (block != Blocks.field_150358_i && block != Blocks.field_150355_j) {
                        if (!isWoddenDoorAllowed && block == Blocks.field_150466_ao) {
                            return 0;
                        }
                    } else {
                        if (isPathingInWater) {
                            return -1;
                        }
                        flag3 = true;
                    }
                    int k1 = block.func_149645_b();
                    if (entity.field_70170_p.func_147439_a(l, i1, j1).func_149645_b() == 9) {
                        int i2;
                        int l1;
                        int j2 = MathHelper.func_76128_c((double)entity.field_70165_t);
                        if (entity.field_70170_p.func_147439_a(j2, l1 = MathHelper.func_76128_c((double)entity.field_70163_u), i2 = MathHelper.func_76128_c((double)entity.field_70161_v)).func_149645_b() == 9 || entity.field_70170_p.func_147439_a(j2, l1 - 1, i2).func_149645_b() == 9) continue;
                        return -3;
                    }
                    if (block.func_149655_b((IBlockAccess)entity.field_70170_p, l, i1, j1) || isMovementBlockAllowed && block == Blocks.field_150466_ao) continue;
                    if (k1 == 11 || block == Blocks.field_150396_be || k1 == 32) {
                        return -3;
                    }
                    if (block == Blocks.field_150415_aT) {
                        return -4;
                    }
                    Material material = block.func_149688_o();
                    if (material != Material.field_151587_i) {
                        return 0;
                    }
                    if (entity.func_70058_J()) continue;
                    return -2;
                }
            }
        }
        return flag3 ? 2 : 1;
    }

    private FlyPathEntity createEntityPath(FlyPathPoint p_75853_1_, FlyPathPoint p_75853_2_) {
        int i = 1;
        FlyPathPoint pathpoint2 = p_75853_2_;
        while (pathpoint2.field_75841_h != null) {
            ++i;
            pathpoint2 = pathpoint2.field_75841_h;
        }
        PathPoint[] apathpoint = new FlyPathPoint[i];
        pathpoint2 = p_75853_2_;
        apathpoint[--i] = p_75853_2_;
        while (pathpoint2.field_75841_h != null) {
            pathpoint2 = pathpoint2.field_75841_h;
            apathpoint[--i] = pathpoint2;
        }
        return new FlyPathEntity(apathpoint);
    }
}

