/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.pathfinder;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import noppes.npcs.entity.EntityNPCInterface;

public class FlyingMoveHelper
extends EntityMoveHelper {
    private final EntityNPCInterface entity;
    private double posX;
    private double posY;
    private double posZ;
    private double speed;
    private boolean update;

    public FlyingMoveHelper(EntityNPCInterface entity) {
        super((EntityLiving)entity);
        this.entity = entity;
        this.posX = entity.field_70165_t;
        this.posY = entity.field_70163_u;
        this.posZ = entity.field_70161_v;
    }

    public void func_75641_c() {
        if (this.update) {
            this.update = false;
            double speed = this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            double speedMult = 1.2f;
            double d0 = this.posX - this.entity.field_70165_t;
            double d1 = this.posY - this.entity.field_70163_u;
            double d2 = this.posZ - this.entity.field_70161_v;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (this.entity.field_70737_aN == 0 && d4 > 0.5) {
                if (this.posY != this.entity.field_70163_u) {
                    double verticalSpeed;
                    if (this.entity.field_70181_x * Math.signum(this.entity.field_70163_u - this.posY) > 0.0) {
                        this.entity.field_70181_x = 0.0;
                    }
                    if ((verticalSpeed = Math.abs(this.entity.field_70163_u - this.posY)) > speed * speedMult) {
                        verticalSpeed = speed * speedMult;
                    }
                    if ((verticalSpeed += this.entity.ai.flySpeed / 2.0) > Math.abs(this.entity.field_70163_u - this.posY)) {
                        verticalSpeed = Math.abs(this.entity.field_70163_u - this.posY);
                    }
                    int blockY = (int)this.posY;
                    double heightOffGround = 0.0;
                    if (this.entity.ai.hasFlyLimit) {
                        for (blockY = (int)this.posY; blockY > 0; --blockY) {
                            heightOffGround = this.posY - (double)blockY;
                            if (this.entity.field_70170_p.func_147439_a((int)this.posX, blockY, (int)this.posZ) != Blocks.field_150350_a || heightOffGround > (double)this.entity.ai.flyHeightLimit) break;
                        }
                    }
                    if (heightOffGround < (double)this.entity.ai.flyHeightLimit || !this.entity.ai.hasFlyLimit) {
                        this.entity.field_70181_x -= Math.signum(this.entity.field_70163_u - this.posY) * verticalSpeed;
                    }
                }
                double d5 = MathHelper.func_76133_a((double)d4);
                this.entity.field_70159_w += (d0 / d5 * speed - this.entity.field_70159_w) * speed * speedMult;
                this.entity.field_70179_y += (d2 / d5 * speed - this.entity.field_70179_y) * speed * speedMult;
            }
            this.entity.field_70177_z = this.limitAngle(this.entity.field_70177_z, (float)((Math.atan2(-d0, -d2) + Math.PI) * -57.29577951308232), 30.0f);
        }
    }

    private float limitAngle(float p_75639_1_, float p_75639_2_, float p_75639_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_75639_2_ - p_75639_1_));
        if (f3 > p_75639_3_) {
            f3 = p_75639_3_;
        }
        if (f3 < -p_75639_3_) {
            f3 = -p_75639_3_;
        }
        return p_75639_1_ + f3;
    }

    public void func_75642_a(double p_75642_1_, double p_75642_3_, double p_75642_5_, double p_75642_7_) {
        this.posX = p_75642_1_;
        this.posY = p_75642_3_;
        this.posZ = p_75642_5_;
        this.speed = p_75642_7_;
        this.update = true;
    }

    public boolean func_75640_a() {
        return this.update;
    }

    public double func_75638_b() {
        return this.speed;
    }
}

