/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.player.GuiQuestLog;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.constants.EnumPlayerPacket;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ClientTickHandler {
    private World prevWorld;
    private boolean otherContainer = false;
    private int buttonPressed = -1;
    private long buttonTime = 0L;
    private final int[] ignoreKeys = new int[]{157, 29, 54, 42, 184, 56, 220, 219};

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.field_71070_bA instanceof ContainerPlayer) {
            if (this.otherContainer) {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.CheckQuestCompletion, new Object[0]);
                this.otherContainer = false;
            }
        } else {
            this.otherContainer = true;
        }
        ++CustomNpcs.ticks;
        ++RenderNPCInterface.LastTextureTick;
        if (this.prevWorld != mc.field_71441_e) {
            this.prevWorld = mc.field_71441_e;
            MusicController.Instance.stopMusic();
        }
    }

    @SubscribeEvent
    public void onMouse(InputEvent.MouseInputEvent event) {
        if (Mouse.getEventButton() == -1 && Mouse.getDWheel() == 0) {
            return;
        }
        NoppesUtilPlayer.sendData(EnumPlayerPacket.MouseClicked, Mouse.getEventButton(), Mouse.getEventDWheel(), Mouse.isButtonDown((int)Mouse.getEventButton()));
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        if (ClientProxy.QuestLog.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r == null) {
                NoppesUtil.openGUI((EntityPlayer)mc.field_71439_g, new GuiQuestLog((EntityPlayer)mc.field_71439_g));
            } else if (mc.field_71462_r instanceof GuiQuestLog) {
                mc.func_71381_h();
            }
        }
        int key = Keyboard.getEventKey();
        long time = Keyboard.getEventNanoseconds();
        if (Keyboard.getEventKeyState() && !this.isIgnoredKey(key)) {
            this.buttonTime = time;
        }
        if (time - this.buttonTime == 0L || !Keyboard.getEventKeyState()) {
            boolean isCtrlPressed = Keyboard.isKeyDown((int)157) || Keyboard.isKeyDown((int)29);
            boolean isShiftPressed = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
            boolean isAltPressed = Keyboard.isKeyDown((int)184) || Keyboard.isKeyDown((int)56);
            boolean isMetaPressed = Keyboard.isKeyDown((int)220) || Keyboard.isKeyDown((int)219);
            boolean keyDown = Keyboard.isKeyDown((int)key);
            StringBuilder keysDownString = new StringBuilder();
            for (int i = 0; i < Keyboard.getKeyCount(); ++i) {
                if (!Keyboard.isKeyDown((int)i)) continue;
                keysDownString.append((Object)i).append(",");
            }
            if (keysDownString.length() > 0) {
                keysDownString.deleteCharAt(keysDownString.length() - 1);
            }
            NoppesUtilPlayer.sendData(EnumPlayerPacket.KeyPressed, key, isCtrlPressed, isShiftPressed, isAltPressed, isMetaPressed, keyDown, keysDownString.toString());
        }
    }

    private boolean isIgnoredKey(int key) {
        for (int i : this.ignoreKeys) {
            if (i != key) continue;
            return true;
        }
        return false;
    }
}

