/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;

public class GuiNpcTextField
extends GuiTextField {
    public boolean enabled = true;
    public boolean inMenu = true;
    public boolean integersOnly = false;
    public boolean doublesOnly = false;
    public boolean floatsOnly = false;
    private ITextfieldListener listener;
    public int id;
    public int min = 0;
    public int max = Integer.MAX_VALUE;
    public int def = 0;
    public double minDouble = 0.0;
    public double maxDouble = Double.MAX_VALUE;
    public double defDouble = 0.0;
    public float minFloat = 0.0f;
    public float maxFloat = Float.MAX_VALUE;
    public float defFloat = 0.0f;
    private static GuiNpcTextField activeTextfield = null;
    public boolean canEdit = true;
    private final int[] allowedSpecialChars = new int[]{14, 211, 203, 205};

    public GuiNpcTextField(int id, GuiScreen parent, FontRenderer fontRenderer, int i, int j, int k, int l, String s) {
        super(fontRenderer, i, j, k, l);
        this.func_146203_f(500);
        this.func_146180_a(s);
        this.id = id;
        if (parent instanceof ITextfieldListener) {
            this.listener = (ITextfieldListener)parent;
        }
    }

    public static boolean isFieldActive() {
        return activeTextfield != null;
    }

    public GuiNpcTextField(int id, GuiScreen parent, int i, int j, int k, int l, String s) {
        this(id, parent, Minecraft.func_71410_x().field_71466_p, i, j, k, l, s);
    }

    private boolean charAllowed(char c, int i) {
        if (!this.integersOnly || Character.isDigit(c)) {
            return true;
        }
        for (int j : this.allowedSpecialChars) {
            if (j != i) continue;
            return true;
        }
        return false;
    }

    public boolean func_146201_a(char c, int i) {
        if (!this.charAllowed(c, i) || !this.canEdit) {
            return false;
        }
        return super.func_146201_a(c, i);
    }

    public boolean isEmpty() {
        return this.func_146179_b().trim().length() == 0;
    }

    public int getInteger() {
        return Integer.parseInt(this.func_146179_b());
    }

    public boolean isInteger() {
        try {
            Integer.parseInt(this.func_146179_b());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public double getDouble() {
        return Double.parseDouble(this.func_146179_b());
    }

    public boolean isDouble() {
        try {
            Double.parseDouble(this.func_146179_b());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public float getFloat() {
        return Float.parseFloat(this.func_146179_b());
    }

    public boolean isFloat() {
        try {
            Float.parseFloat(this.func_146179_b());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void func_146192_a(int i, int j, int k) {
        if (!this.canEdit) {
            return;
        }
        boolean wasFocused = this.func_146206_l();
        super.func_146192_a(i, j, k);
        if (wasFocused != this.func_146206_l() && wasFocused) {
            this.unFocused();
        }
        if (this.func_146206_l()) {
            activeTextfield = this;
        }
    }

    public void unFocused() {
        if (this.integersOnly && !this.doublesOnly && !this.floatsOnly) {
            if (this.isEmpty() || !this.isInteger()) {
                this.func_146180_a(this.def + "");
            } else if (this.getInteger() < this.min) {
                this.func_146180_a(this.min + "");
            } else if (this.getInteger() > this.max) {
                this.func_146180_a(this.max + "");
            }
        } else if (this.doublesOnly && !this.floatsOnly) {
            if (this.isEmpty() || !this.isDouble()) {
                this.func_146180_a(this.defDouble + "");
            } else if (this.getDouble() < this.minDouble) {
                this.func_146180_a(this.minDouble + "");
            } else if (this.getDouble() > this.maxDouble) {
                this.func_146180_a(this.maxDouble + "");
            }
        } else if (this.floatsOnly) {
            if (this.isEmpty() || !this.isFloat()) {
                this.func_146180_a(this.defFloat + "");
            } else if (this.getFloat() < this.minFloat) {
                this.func_146180_a(this.minFloat + "");
            } else if (this.getFloat() > this.maxFloat) {
                this.func_146180_a(this.maxFloat + "");
            }
        }
        if (this.listener != null) {
            this.listener.unFocused(this);
        }
        if (this == activeTextfield) {
            activeTextfield = null;
        }
    }

    public void func_146194_f() {
        if (this.enabled) {
            super.func_146194_f();
        }
    }

    public void setMinMaxDefault(int min, int max, int def) {
        this.min = min;
        this.max = max;
        this.def = def;
    }

    public void setMinMaxDefaultDouble(double min, double max, double def) {
        this.minDouble = min;
        this.maxDouble = max;
        this.defDouble = def;
    }

    public void setMinMaxDefaultFloat(float min, float max, float def) {
        this.minFloat = min;
        this.maxFloat = max;
        this.defFloat = def;
    }

    public static void unfocus() {
        GuiNpcTextField prev = activeTextfield;
        activeTextfield = null;
        if (prev != null) {
            prev.unFocused();
        }
    }

    public void drawTextBox(int mousX, int mousY) {
        this.func_146194_f();
    }

    public GuiNpcTextField setIntegersOnly() {
        this.integersOnly = true;
        return this;
    }

    public GuiNpcTextField setDoublesOnly() {
        this.doublesOnly = true;
        return this;
    }

    public GuiNpcTextField setFloatsOnly() {
        this.floatsOnly = true;
        return this;
    }
}

