/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.config;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.util.LRUHashMap;
import org.lwjgl.opengl.GL11;

public class TrueTypeFont {
    private static final int MaxWidth = 512;
    private static final List<Font> allFonts = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts());
    private List<Font> usedFonts = new ArrayList<Font>();
    private LinkedHashMap<String, GlyphCache> textcache = new LRUHashMap<String, GlyphCache>(100);
    private Map<Character, Glyph> glyphcache = new HashMap<Character, Glyph>();
    private List<TextureCache> textures = new ArrayList<TextureCache>();
    private Font font;
    private int lineHeight = 1;
    private Graphics2D globalG = (Graphics2D)new BufferedImage(1, 1, 2).getGraphics();
    public float scale = 1.0f;
    private int specialChar = 167;

    public TrueTypeFont(Font font, float scale) {
        this.font = font;
        this.scale = scale;
        this.globalG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.lineHeight = this.globalG.getFontMetrics(font).getHeight();
    }

    public TrueTypeFont(ResourceLocation resource, int fontSize, float scale) throws IOException, FontFormatException {
        InputStream stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font font = Font.createFont(0, stream);
        ge.registerFont(font);
        this.font = font.deriveFont(0, fontSize);
        this.scale = scale;
        this.globalG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.lineHeight = this.globalG.getFontMetrics(font).getHeight();
    }

    public void setSpecial(char c) {
        this.specialChar = c;
    }

    public void draw(String text, float x, float y, int color) {
        GlyphCache cache = this.getOrCreateCache(text);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)1.0f);
        float i = 0.0f;
        for (Glyph gl : cache.glyphs) {
            if (gl.type != GlyphType.NORMAL) {
                if (gl.type == GlyphType.RESET) {
                    GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
                    continue;
                }
                if (gl.type != GlyphType.COLOR) continue;
                GL11.glColor4f((float)((float)(gl.color >> 16 & 0xFF) / 255.0f), (float)((float)(gl.color >> 8 & 0xFF) / 255.0f), (float)((float)(gl.color & 0xFF) / 255.0f), (float)1.0f);
                continue;
            }
            GL11.glBindTexture((int)gl.texture, (int)gl.texture);
            this.drawTexturedModalRect(i, 0.0f, (float)gl.x * this.textureScale(), (float)gl.y * this.textureScale(), (float)gl.width * this.textureScale(), (float)gl.height * this.textureScale());
            i += (float)gl.width * this.textureScale();
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private GlyphCache getOrCreateCache(String text) {
        GlyphCache cache = this.textcache.get(text);
        if (cache != null) {
            return cache;
        }
        cache = new GlyphCache();
        for (int i = 0; i < text.length(); ++i) {
            char g;
            int index;
            char c = text.charAt(i);
            if (c == this.specialChar && i + 1 < text.length() && (index = "0123456789abcdefklmnor".indexOf(g = text.toLowerCase(Locale.ENGLISH).charAt(i + 1))) >= 0) {
                Glyph g1 = new Glyph();
                if (index < 16) {
                    g1.type = GlyphType.COLOR;
                    g1.color = 0;
                } else {
                    g1.type = index == 16 ? GlyphType.RANDOM : (index == 17 ? GlyphType.BOLD : (index == 18 ? GlyphType.STRIKETHROUGH : (index == 19 ? GlyphType.UNDERLINE : (index == 20 ? GlyphType.ITALIC : GlyphType.RESET))));
                }
                cache.glyphs.add(g1);
                ++i;
                continue;
            }
            Glyph var8 = this.getOrCreateGlyph(c);
            cache.glyphs.add(var8);
            cache.width += var8.width;
            cache.height = Math.max(cache.height, var8.height);
        }
        this.textcache.put(text, cache);
        return cache;
    }

    private Glyph getOrCreateGlyph(char c) {
        Glyph g = this.glyphcache.get(Character.valueOf(c));
        if (g != null) {
            return g;
        }
        TextureCache cache = this.getCurrentTexture();
        Font font = this.getFontForChar(c);
        FontMetrics metrics = this.globalG.getFontMetrics(font);
        g = new Glyph();
        g.width = Math.max(metrics.charWidth(c), 1);
        g.height = Math.max(metrics.getHeight(), 1);
        if (cache.x + g.width >= 512) {
            cache.x = 0;
            cache.y += this.lineHeight + 1;
            if (cache.y >= 512) {
                cache.full = true;
                cache = this.getCurrentTexture();
            }
        }
        g.x = cache.x;
        g.y = cache.y;
        cache.x += g.width + 3;
        this.lineHeight = Math.max(this.lineHeight, g.height);
        cache.g.setFont(font);
        cache.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        cache.g.drawString(c + "", g.x, g.y + metrics.getAscent());
        g.texture = cache.textureId;
        TextureUtil.func_110987_a((int)cache.textureId, (BufferedImage)cache.bufferedImage);
        this.glyphcache.put(Character.valueOf(c), g);
        return g;
    }

    private TextureCache getCurrentTexture() {
        TextureCache cache = null;
        for (TextureCache t : this.textures) {
            if (t.full) continue;
            cache = t;
            break;
        }
        if (cache == null) {
            cache = new TextureCache();
            this.textures.add(cache);
        }
        return cache;
    }

    public void drawCentered(String text, float x, float y, int color) {
        this.draw(text, x - (float)this.width(text) / 2.0f, y, color);
    }

    private Font getFontForChar(char c) {
        Font f;
        if (this.font.canDisplay(c)) {
            return this.font;
        }
        Iterator<Font> fa = this.usedFonts.iterator();
        do {
            Font f1;
            if (fa.hasNext()) continue;
            Font fa1 = new Font("Arial Unicode MS", 0, this.font.getSize());
            if (fa1.canDisplay(c)) {
                return fa1;
            }
            Iterator<Font> f2 = allFonts.iterator();
            do {
                if (f2.hasNext()) continue;
                return this.font;
            } while (!(f1 = f2.next()).canDisplay(c));
            f1 = f1.deriveFont(0, this.font.getSize());
            this.usedFonts.add(f1);
            return f1;
        } while (!(f = fa.next()).canDisplay(c));
        return f;
    }

    public void drawTexturedModalRect(float p_73729_1_, float p_73729_2_, float p_73729_3_, float p_73729_4_, float p_73729_5_, float p_73729_6_) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        boolean zLevel = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(p_73729_1_ + 0.0f), (double)(p_73729_2_ + p_73729_6_), (double)zLevel, (double)((p_73729_3_ + 0.0f) * f), (double)((p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + p_73729_6_), (double)zLevel, (double)((p_73729_3_ + p_73729_5_) * f), (double)((p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + 0.0f), (double)zLevel, (double)((p_73729_3_ + p_73729_5_) * f), (double)((p_73729_4_ + 0.0f) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + 0.0f), (double)(p_73729_2_ + 0.0f), (double)zLevel, (double)((p_73729_3_ + 0.0f) * f), (double)((p_73729_4_ + 0.0f) * f1));
        tessellator.func_78381_a();
    }

    public int width(String text) {
        GlyphCache cache = this.getOrCreateCache(text);
        return (int)((float)cache.width * this.scale * this.textureScale());
    }

    public int height(String text) {
        if (text != null && !text.trim().isEmpty()) {
            GlyphCache cache = this.getOrCreateCache(text);
            return Math.max(1, (int)((float)cache.height * this.scale * this.textureScale()));
        }
        return (int)((float)this.lineHeight * this.scale * this.textureScale());
    }

    private float textureScale() {
        return 0.5f;
    }

    public void dispose() {
        for (TextureCache cache : this.textures) {
            GL11.glDeleteTextures((int)cache.textureId);
        }
        this.textcache.clear();
    }

    public String getFontName() {
        return this.font.getFontName();
    }

    static enum GlyphType {
        NORMAL,
        COLOR,
        RANDOM,
        BOLD,
        STRIKETHROUGH,
        UNDERLINE,
        ITALIC,
        RESET,
        OTHER;

    }

    class TextureCache {
        int x;
        int y;
        int textureId = GL11.glGenTextures();
        BufferedImage bufferedImage = new BufferedImage(512, 512, 2);
        Graphics2D g = (Graphics2D)this.bufferedImage.getGraphics();
        boolean full;

        TextureCache() {
        }
    }

    class Glyph {
        GlyphType type = GlyphType.NORMAL;
        int color = -1;
        int x;
        int y;
        int height;
        int width;
        int texture;

        Glyph() {
        }
    }

    class GlyphCache {
        public int width;
        public int height;
        List<Glyph> glyphs = new ArrayList<Glyph>();

        GlyphCache() {
        }
    }
}

