/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import cpw.mods.fml.common.eventhandler.Event;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.scripted.NpcAPI;

public class ScriptContainer {
    private static final String lock = "lock";
    public static ScriptContainer Current;
    private static String CurrentType;
    private static final HashMap<String, Object> Data;
    public String fullscript = "";
    public String script = "";
    public TreeMap<Long, String> console = new TreeMap();
    public boolean errored = false;
    public List<String> scripts = new ArrayList<String>();
    private HashSet<String> unknownFunctions = new HashSet();
    public long lastCreated = 0L;
    private String currentScriptLanguage = null;
    public ScriptEngine engine = null;
    private IScriptHandler handler = null;
    private boolean init = false;
    private static Method luaCoerce;
    private static Method luaCall;
    private CompiledScript compScript = null;

    public ScriptContainer(IScriptHandler handler) {
        this.handler = handler;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.script = compound.func_74779_i("Script");
        this.console = NBTTags.GetLongStringMap(compound.func_150295_c("Console", 10));
        this.scripts = NBTTags.getStringList(compound.func_150295_c("ScriptList", 10));
        this.lastCreated = 0L;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("Script", this.script);
        compound.func_74782_a("Console", (NBTBase)NBTTags.NBTLongStringMap(this.console));
        compound.func_74782_a("ScriptList", (NBTBase)NBTTags.nbtStringList(this.scripts));
        return compound;
    }

    private String getFullCode() {
        if (!this.init) {
            this.fullscript = this.script;
            if (!this.fullscript.isEmpty()) {
                this.fullscript = this.fullscript + "\n";
            }
            for (String loc : this.scripts) {
                String code = ScriptController.Instance.scripts.get(loc);
                if (code == null || code.isEmpty()) continue;
                this.fullscript = this.fullscript + code + "\n";
            }
        }
        return this.fullscript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ScriptEngine engine) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.engine.getContext().setWriter(pw);
        this.engine.getContext().setErrorWriter(pw);
        try {
            if (this.compScript == null && engine instanceof Compilable) {
                this.compScript = ((Compilable)((Object)engine)).compile(this.getFullCode());
            }
            if (this.compScript != null) {
                this.compScript.eval(engine.getContext());
            } else {
                engine.eval(this.getFullCode());
            }
        }
        catch (Throwable var14) {
            this.errored = true;
            var14.printStackTrace(pw);
        }
        finally {
            String errorString = sw.getBuffer().toString().trim();
            this.appandConsole(errorString);
            pw.close();
        }
    }

    public void run(EnumScriptType type, Event event) {
        this.run(type.function, (Object)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String type, Object event) {
        if (!this.errored && this.hasCode() && !this.unknownFunctions.contains(type)) {
            this.setEngine(this.handler.getLanguage());
            if (this.engine != null) {
                if (ScriptController.Instance.lastLoaded > this.lastCreated) {
                    this.lastCreated = ScriptController.Instance.lastLoaded;
                    this.init = false;
                }
                this.engine.put("API", NpcAPI.Instance());
                Current = this;
                CurrentType = type;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                this.engine.getContext().setWriter(pw);
                this.engine.getContext().setErrorWriter(pw);
                try {
                    if (!this.init) {
                        this.engine.eval(this.getFullCode());
                        this.init = true;
                    }
                    ((Invocable)((Object)this.engine)).invokeFunction(type, event);
                }
                catch (NoSuchMethodException var13) {
                    this.unknownFunctions.add(type);
                }
                catch (Throwable var14) {
                    this.errored = true;
                    var14.printStackTrace(pw);
                }
                finally {
                    String errorString = sw.getBuffer().toString().trim();
                    this.appandConsole(errorString);
                    pw.close();
                    Current = null;
                }
            }
        }
    }

    public void appandConsole(String message) {
        if (message != null && !message.isEmpty()) {
            long time = System.currentTimeMillis();
            if (this.console.containsKey(time)) {
                message = this.console.get(time) + "\n" + message;
            }
            this.console.put(time, message);
            while (this.console.size() > 40) {
                this.console.remove(this.console.firstKey());
            }
        }
    }

    public boolean hasCode() {
        return !this.getFullCode().isEmpty();
    }

    public void setEngine(String scriptLanguage) {
        if (this.currentScriptLanguage != null && this.currentScriptLanguage.equals(scriptLanguage)) {
            return;
        }
        this.engine = ScriptController.Instance.getEngineByName(scriptLanguage.toLowerCase());
        this.currentScriptLanguage = scriptLanguage;
    }

    static {
        Data = new HashMap();
    }
}

