/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.scripted.interfaces.IPos;

public class ScriptBlockPos
implements IPos {
    private BlockPos blockPos;

    public ScriptBlockPos(BlockPos pos) {
        this.blockPos = pos;
    }

    @Override
    public int getX() {
        return this.blockPos.getX();
    }

    @Override
    public int getY() {
        return this.blockPos.getY();
    }

    @Override
    public int getZ() {
        return this.blockPos.getZ();
    }

    @Override
    public IPos up() {
        return new ScriptBlockPos(this.blockPos.up());
    }

    @Override
    public IPos up(int n) {
        return new ScriptBlockPos(this.blockPos.up(n));
    }

    @Override
    public IPos down() {
        return new ScriptBlockPos(this.blockPos.down());
    }

    @Override
    public IPos down(int n) {
        return new ScriptBlockPos(this.blockPos.down(n));
    }

    @Override
    public IPos north() {
        return new ScriptBlockPos(this.blockPos.north());
    }

    @Override
    public IPos north(int n) {
        return new ScriptBlockPos(this.blockPos.north(n));
    }

    @Override
    public IPos east() {
        return new ScriptBlockPos(this.blockPos.east());
    }

    @Override
    public IPos east(int n) {
        return new ScriptBlockPos(this.blockPos.east(n));
    }

    @Override
    public IPos south() {
        return new ScriptBlockPos(this.blockPos.south());
    }

    @Override
    public IPos south(int n) {
        return new ScriptBlockPos(this.blockPos.south(n));
    }

    @Override
    public IPos west() {
        return new ScriptBlockPos(this.blockPos.west());
    }

    @Override
    public IPos west(int n) {
        return new ScriptBlockPos(this.blockPos.west(n));
    }

    @Override
    public IPos add(int x, int y, int z) {
        return new ScriptBlockPos(this.blockPos.add(x, y, z));
    }

    @Override
    public IPos add(IPos pos) {
        return new ScriptBlockPos(this.blockPos.add(pos.getMCBlockPos()));
    }

    @Override
    public IPos subtract(int x, int y, int z) {
        return new ScriptBlockPos(this.blockPos.add(-x, -y, -z));
    }

    @Override
    public IPos subtract(IPos pos) {
        return new ScriptBlockPos(this.blockPos.add(-pos.getX(), -pos.getY(), -pos.getZ()));
    }

    @Override
    public IPos offset(int direction) {
        return new ScriptBlockPos(this.blockPos.offset(EnumFacing.values()[direction]));
    }

    @Override
    public IPos offset(int direction, int n) {
        return new ScriptBlockPos(this.blockPos.offset(EnumFacing.values()[direction], n));
    }

    @Override
    public BlockPos getMCBlockPos() {
        return this.blockPos;
    }

    @Override
    public double[] normalize() {
        double d = Math.sqrt(this.blockPos.getX() * this.blockPos.getX() + this.blockPos.getY() * this.blockPos.getY() + this.blockPos.getZ() * this.blockPos.getZ());
        return new double[]{(double)this.getX() / d, (double)this.getY() / d, (double)this.getZ() / d};
    }

    @Override
    public double distanceTo(IPos pos) {
        double d0 = this.getX() - pos.getX();
        double d1 = this.getY() - pos.getY();
        double d2 = this.getZ() - pos.getZ();
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }
}

