/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.scripted.ScriptItemStack;
import noppes.npcs.scripted.entity.ScriptEntity;
import noppes.npcs.scripted.interfaces.IEntityLivingBase;
import noppes.npcs.scripted.wrapper.ScriptDamageSource;

public class ScriptLivingBase<T extends EntityLivingBase>
extends ScriptEntity<T>
implements IEntityLivingBase {
    protected T entity;

    public ScriptLivingBase(T entity) {
        super(entity);
        this.entity = entity;
    }

    @Override
    public float getHealth() {
        return this.entity.func_110143_aJ();
    }

    @Override
    public void setHealth(float health) {
        this.entity.func_70606_j(health);
    }

    public void hurt(float damage) {
        this.entity.func_70097_a(DamageSource.field_76377_j, damage);
    }

    public void hurt(float damage, ScriptEntity source) {
        if (source.getType() == 1) {
            this.entity.func_70097_a((DamageSource)new EntityDamageSource("player", source.getMCEntity()), damage);
        } else {
            this.entity.func_70097_a((DamageSource)new EntityDamageSource(source.getTypeName(), source.getMCEntity()), damage);
        }
    }

    public void hurt(float damage, ScriptDamageSource damageSource) {
        this.entity.func_70097_a(damageSource.getMCDamageSource(), damage);
    }

    @Override
    public double getMaxHealth() {
        return this.entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
    }

    @Override
    public boolean isAttacking() {
        return this.entity.func_70643_av() != null;
    }

    @Override
    public void setAttackTarget(ScriptLivingBase living) {
        if (living == null) {
            this.entity.func_70604_c(null);
        } else {
            this.entity.func_70604_c(living.entity);
        }
    }

    @Override
    public ScriptLivingBase getAttackTarget() {
        return (ScriptLivingBase)ScriptController.Instance.getScriptForEntity((Entity)this.entity.func_70643_av());
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 5 ? true : super.typeOf(type);
    }

    @Override
    public boolean canSeeEntity(ScriptEntity entity) {
        return this.entity.func_70685_l(entity.entity);
    }

    @Override
    public T getMCEntity() {
        return this.entity;
    }

    @Override
    public void swingHand() {
        this.entity.func_71038_i();
    }

    @Override
    public void addPotionEffect(int effect, int duration, int strength, boolean hideParticles) {
        if (effect < 0 || effect >= Potion.field_76425_a.length || Potion.field_76425_a[effect] == null) {
            return;
        }
        if (strength < 0) {
            strength = 0;
        }
        if (duration < 0) {
            duration = 0;
        }
        if (!Potion.field_76425_a[effect].func_76403_b()) {
            duration *= 20;
        }
        if (duration == 0) {
            this.entity.func_82170_o(effect);
        } else {
            this.entity.func_70690_d(new PotionEffect(effect, duration, strength));
        }
    }

    @Override
    public void clearPotionEffects() {
        this.entity.func_70674_bp();
    }

    @Override
    public int getPotionEffect(int effect) {
        PotionEffect pf = this.entity.func_70660_b(Potion.field_76425_a[effect]);
        if (pf == null) {
            return -1;
        }
        return pf.func_76458_c();
    }

    @Override
    public ScriptItemStack getHeldItem() {
        ItemStack item = this.entity.func_70694_bm();
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    @Override
    public void setHeldItem(ScriptItemStack item) {
        this.entity.func_70062_b(0, item == null ? null : item.item);
    }

    @Override
    public ScriptItemStack getArmor(int slot) {
        ItemStack item = this.entity.func_71124_b(slot + 1);
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    @Override
    public void setArmor(int slot, ScriptItemStack item) {
        this.entity.func_70062_b(slot + 1, item == null ? null : item.item);
    }
}

