/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted.entity;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumAnimation;
import noppes.npcs.constants.EnumJobType;
import noppes.npcs.constants.EnumNavType;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.constants.EnumStandingType;
import noppes.npcs.controllers.Line;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.ScriptFaction;
import noppes.npcs.scripted.ScriptItemStack;
import noppes.npcs.scripted.entity.ScriptLiving;
import noppes.npcs.scripted.entity.ScriptLivingBase;
import noppes.npcs.scripted.entity.ScriptPlayer;
import noppes.npcs.scripted.interfaces.ICustomNpc;
import noppes.npcs.scripted.interfaces.ITimers;
import noppes.npcs.scripted.roles.ScriptJobBard;
import noppes.npcs.scripted.roles.ScriptJobConversation;
import noppes.npcs.scripted.roles.ScriptJobFollower;
import noppes.npcs.scripted.roles.ScriptJobGuard;
import noppes.npcs.scripted.roles.ScriptJobHealer;
import noppes.npcs.scripted.roles.ScriptJobInterface;
import noppes.npcs.scripted.roles.ScriptJobItemGiver;
import noppes.npcs.scripted.roles.ScriptJobPuppet;
import noppes.npcs.scripted.roles.ScriptJobSpawner;
import noppes.npcs.scripted.roles.ScriptRoleBank;
import noppes.npcs.scripted.roles.ScriptRoleFollower;
import noppes.npcs.scripted.roles.ScriptRoleInterface;
import noppes.npcs.scripted.roles.ScriptRoleMailman;
import noppes.npcs.scripted.roles.ScriptRoleTrader;
import noppes.npcs.scripted.roles.ScriptRoleTransporter;
import noppes.npcs.util.ValueUtil;

public class ScriptNpc<T extends EntityNPCInterface>
extends ScriptLiving<T>
implements ICustomNpc {
    public EntityNPCInterface npc;

    public ScriptNpc(T npc) {
        super(npc);
        this.npc = npc;
    }

    @Override
    public int getSize() {
        return this.npc.display.modelSize;
    }

    @Override
    public void setSize(int size) {
        if (size < 1) {
            size = 1;
        }
        if (size > CustomNpcs.NpcSizeLimit) {
            size = CustomNpcs.NpcSizeLimit;
        }
        this.npc.display.modelSize = size;
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public int getModelType() {
        return this.npc.display.modelType;
    }

    @Override
    public void setModelType(int modelType) {
        if (modelType > 2) {
            modelType = 2;
        } else if (modelType < 0) {
            modelType = 0;
        }
        this.npc.display.modelType = modelType;
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public String getName() {
        return this.npc.display.name;
    }

    @Override
    public void setRotation(float rotation) {
        this.npc.ai.orientation = (int)rotation;
        super.setRotation(rotation);
    }

    public void setRotationType(int rotationType) {
        for (EnumStandingType e : EnumStandingType.values()) {
            if (e.ordinal() != rotationType) continue;
            this.npc.ai.standingType = e;
            break;
        }
    }

    public int getRotationType() {
        return this.npc.ai.standingType.ordinal();
    }

    @Override
    public void setName(String name) {
        this.npc.display.name = name;
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public String getTitle() {
        return this.npc.display.title;
    }

    @Override
    public void setTitle(String title) {
        this.npc.display.title = title;
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public String getTexture() {
        return this.npc.display.texture;
    }

    @Override
    public void setTexture(String texture) {
        this.npc.display.texture = texture;
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public int getHomeX() {
        return this.npc.getStartPos()[0];
    }

    @Override
    public void setHomeX(int x) {
        this.npc.ai.startPos[0] = x;
    }

    @Override
    public int getHomeY() {
        return this.npc.getStartPos()[1];
    }

    @Override
    public void setHomeY(int y) {
        this.npc.ai.startPos[1] = y;
    }

    @Override
    public int getHomeZ() {
        return this.npc.getStartPos()[2];
    }

    @Override
    public void setHomeZ(int z) {
        this.npc.ai.startPos[2] = z;
    }

    @Override
    public void setHome(int x, int y, int z) {
        this.npc.ai.startPos = new int[]{x, y, z};
    }

    @Override
    public void setMaxHealth(double health) {
        this.npc.stats.setMaxHealth(health);
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public void setReturnToHome(boolean bo) {
        this.npc.ai.returnToStart = bo;
    }

    @Override
    public boolean getReturnToHome() {
        return this.npc.ai.returnToStart;
    }

    @Override
    public ScriptFaction getFaction() {
        return new ScriptFaction(this.npc.getFaction());
    }

    @Override
    public void setFaction(int id) {
        this.npc.setFaction(id);
    }

    @Override
    public void setAttackFactions(boolean attackOtherFactions) {
        this.npc.advanced.attackOtherFactions = attackOtherFactions;
    }

    @Override
    public boolean getAttackFactions() {
        return this.npc.advanced.attackOtherFactions;
    }

    @Override
    public void setDefendFaction(boolean defendFaction) {
        this.npc.advanced.defendFaction = defendFaction;
    }

    @Override
    public boolean getDefendFaction() {
        return this.npc.advanced.defendFaction;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 2 ? true : super.typeOf(type);
    }

    @Override
    public void shootItem(ScriptLivingBase target, ScriptItemStack item, int accuracy) {
        if (item == null) {
            return;
        }
        if (accuracy < 0) {
            accuracy = 0;
        } else if (accuracy > 100) {
            accuracy = 100;
        }
        this.npc.shoot((EntityLivingBase)target.entity, accuracy, item.item, false);
    }

    @Override
    public void say(String message) {
        this.npc.saySurrounding(new Line(message));
    }

    @Override
    public void say(ScriptPlayer player, String message) {
        if (player == null || message == null || message.isEmpty()) {
            return;
        }
        this.npc.say((EntityPlayer)player.player, new Line(message));
    }

    @Override
    public void kill() {
        this.npc.func_70106_y();
    }

    @Override
    public void reset() {
        this.npc.reset();
    }

    @Override
    public ScriptRoleInterface getRole() {
        if (this.npc.advanced.role == EnumRoleType.Bank) {
            return new ScriptRoleBank(this.npc);
        }
        if (this.npc.advanced.role == EnumRoleType.Follower) {
            return new ScriptRoleFollower(this.npc);
        }
        if (this.npc.advanced.role == EnumRoleType.Postman) {
            return new ScriptRoleMailman(this.npc);
        }
        if (this.npc.advanced.role == EnumRoleType.Trader) {
            return new ScriptRoleTrader(this.npc);
        }
        if (this.npc.advanced.role == EnumRoleType.Transporter) {
            return new ScriptRoleTransporter(this.npc);
        }
        return new ScriptRoleInterface(this.npc);
    }

    public void setRole(int role) {
        for (EnumRoleType e : EnumRoleType.values()) {
            if (e.ordinal() != role) continue;
            this.npc.advanced.role = e;
            break;
        }
    }

    @Override
    public ScriptJobInterface getJob() {
        if (this.npc.advanced.job == EnumJobType.Bard) {
            return new ScriptJobBard(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.Conversation) {
            return new ScriptJobConversation(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.Follower) {
            return new ScriptJobFollower(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.Guard) {
            return new ScriptJobGuard(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.Healer) {
            return new ScriptJobHealer(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.Puppet) {
            return new ScriptJobPuppet(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.ItemGiver) {
            return new ScriptJobItemGiver(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.Spawner) {
            return new ScriptJobSpawner(this.npc);
        }
        return new ScriptJobInterface(this.npc);
    }

    public void setJob(int job) {
        for (EnumJobType e : EnumJobType.values()) {
            if (e.ordinal() != job) continue;
            this.npc.advanced.job = e;
            break;
        }
    }

    @Override
    public ScriptItemStack getRightItem() {
        ItemStack item = this.npc.inventory.getWeapon();
        if (item == null || item.func_77973_b() == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    @Override
    public void setRightItem(ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.setWeapon(null);
        } else {
            this.npc.inventory.setWeapon(item.item);
        }
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public ScriptItemStack getLefttItem() {
        ItemStack item = this.npc.getOffHand();
        if (item == null || item.func_77973_b() == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    @Override
    public void setLeftItem(ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.setOffHand(null);
        } else {
            this.npc.inventory.setOffHand(item.item);
        }
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public ScriptItemStack getProjectileItem() {
        ItemStack item = this.npc.inventory.getProjectile();
        if (item == null || item.func_77973_b() == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    @Override
    public void setProjectileItem(ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.setProjectile(null);
        } else {
            this.npc.inventory.setProjectile(item.item);
        }
        this.npc.script.aiNeedsUpdate = true;
    }

    @Override
    public boolean canAimWhileShooting() {
        return !this.npc.stats.aimWhileShooting;
    }

    @Override
    public void aimWhileShooting(boolean aimWhileShooting) {
        this.npc.stats.aimWhileShooting = aimWhileShooting;
    }

    @Override
    public void setMinProjectileDelay(int minDelay) {
        this.npc.stats.minDelay = minDelay;
    }

    @Override
    public int getMinProjectileDelay() {
        return this.npc.stats.minDelay;
    }

    @Override
    public void setMaxProjectileDelay(int maxDelay) {
        this.npc.stats.maxDelay = maxDelay;
    }

    @Override
    public int getMaxProjectileDelay() {
        return this.npc.stats.maxDelay;
    }

    @Override
    public void setRangedRage(int rangedRange) {
        this.npc.stats.rangedRange = rangedRange;
    }

    @Override
    public int getRangedRage() {
        return this.npc.stats.rangedRange;
    }

    @Override
    public void setFireRate(int rate) {
        this.npc.stats.fireRate = rate;
    }

    @Override
    public int getFireRate() {
        return this.npc.stats.fireRate;
    }

    @Override
    public void setBurstCount(int burstCount) {
        this.npc.stats.burstCount = burstCount;
    }

    @Override
    public int getBurstCount() {
        return this.npc.stats.burstCount;
    }

    @Override
    public void setShotCount(int shotCount) {
        this.npc.stats.shotCount = shotCount;
    }

    @Override
    public int getShotCount() {
        return this.npc.stats.shotCount;
    }

    @Override
    public void setAccuracy(int accuracy) {
        this.npc.stats.accuracy = accuracy;
    }

    @Override
    public int getAccuracy() {
        return this.npc.stats.accuracy;
    }

    @Override
    public String getFireSound() {
        return this.npc.stats.fireSound;
    }

    @Override
    public void setFireSound(String fireSound) {
        this.npc.stats.fireSound = fireSound;
    }

    @Override
    public ScriptItemStack getArmor(int slot) {
        ItemStack item = this.npc.inventory.armor.get(slot);
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    @Override
    public void setArmor(int slot, ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.armor.put(slot, null);
        } else {
            this.npc.inventory.armor.put(slot, item.item);
        }
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public ScriptItemStack getLootItem(int slot) {
        return new ScriptItemStack(this.npc.inventory.func_70301_a(slot + 7));
    }

    @Override
    public void setLootItem(int slot, ScriptItemStack item) {
        this.npc.inventory.func_70299_a(slot + 7, item.item);
    }

    @Override
    public double getLootChance(int slot) {
        if (!this.npc.inventory.dropchance.containsKey(slot)) {
            return 100.0;
        }
        return this.npc.inventory.dropchance.get(slot);
    }

    @Override
    public void setLootChance(int slot, double chance) {
        if (!this.npc.inventory.dropchance.containsKey(slot)) {
            return;
        }
        if (chance < 0.0) {
            chance = 0.0;
        }
        if (chance > 100.0) {
            chance = 100.0;
        }
        this.npc.inventory.dropchance.put(slot, chance);
    }

    @Override
    public int getLootMode() {
        return this.npc.inventory.lootMode;
    }

    @Override
    public void setLootMode(int lootMode) {
        if (lootMode < 0 || lootMode > 1) {
            return;
        }
        this.npc.inventory.lootMode = lootMode;
    }

    @Override
    public void setMinLootXP(int lootXP) {
        if (lootXP > this.npc.inventory.maxExp) {
            lootXP = this.npc.inventory.maxExp;
        }
        if (lootXP < 0) {
            lootXP = 0;
        }
        if (lootXP > Short.MAX_VALUE) {
            lootXP = Short.MAX_VALUE;
        }
        this.npc.inventory.minExp = lootXP;
    }

    @Override
    public void setMaxLootXP(int lootXP) {
        if (lootXP < this.npc.inventory.minExp) {
            lootXP = this.npc.inventory.minExp;
        }
        if (lootXP < 0) {
            lootXP = 0;
        }
        if (lootXP > Short.MAX_VALUE) {
            lootXP = Short.MAX_VALUE;
        }
        this.npc.inventory.maxExp = lootXP;
    }

    @Override
    public int getMinLootXP() {
        return this.npc.inventory.minExp;
    }

    @Override
    public int getMaxLootXP() {
        return this.npc.inventory.maxExp;
    }

    @Override
    public void setAnimation(int type) {
        if (type == 0) {
            this.npc.ai.animationType = EnumAnimation.NONE;
        } else if (type == 1) {
            this.npc.ai.animationType = EnumAnimation.SITTING;
        } else if (type == 5) {
            this.npc.ai.animationType = EnumAnimation.DANCING;
        } else if (type == 4) {
            this.npc.ai.animationType = EnumAnimation.SNEAKING;
        } else if (type == 2) {
            this.npc.ai.animationType = EnumAnimation.LYING;
        } else if (type == 3) {
            this.npc.ai.animationType = EnumAnimation.HUG;
        }
    }

    @Override
    public void setTacticalVariant(int variant) {
        if (variant > EnumNavType.values().length - 1 || variant < 0) {
            return;
        }
        this.npc.ai.tacticalVariant = EnumNavType.values()[variant];
        this.npc.ai.directLOS = EnumNavType.values()[variant] != EnumNavType.Stalk && this.npc.ai.directLOS;
    }

    @Override
    public int getTacticalVariant() {
        return this.npc.ai.tacticalVariant.ordinal();
    }

    @Override
    public void setTacticalVariant(String variant) {
        boolean found = false;
        for (String s : EnumNavType.names()) {
            if (!s.equals(variant)) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        this.npc.ai.tacticalVariant = EnumNavType.valueOf(variant);
    }

    @Override
    public String getTacticalVariantName() {
        return this.npc.ai.tacticalVariant.name();
    }

    @Override
    public void setTacticalRadius(int tacticalRadius) {
        if (tacticalRadius < 0) {
            tacticalRadius = 0;
        }
        this.npc.ai.tacticalRadius = tacticalRadius;
    }

    @Override
    public int getTacticalRadius() {
        return this.npc.ai.tacticalRadius;
    }

    @Override
    public void setIgnoreCobweb(boolean ignore) {
        this.npc.ai.ignoreCobweb = ignore;
    }

    @Override
    public boolean getIgnoreCobweb() {
        return this.npc.ai.ignoreCobweb;
    }

    @Override
    public void setOnFoundEnemy(int onAttack) {
        if (onAttack < 0 || onAttack > 3) {
            return;
        }
        this.npc.ai.onAttack = onAttack;
    }

    @Override
    public int onFoundEnemy() {
        return this.npc.ai.onAttack;
    }

    @Override
    public void setShelterFrom(int shelterFrom) {
        if (shelterFrom < 0 || shelterFrom > 2) {
            return;
        }
        this.npc.ai.findShelter = shelterFrom;
    }

    @Override
    public int getShelterFrom() {
        return this.npc.ai.findShelter;
    }

    @Override
    public boolean hasLivingAnimation() {
        return !this.npc.display.disableLivingAnimation;
    }

    @Override
    public void setLivingAnimation(boolean livingAnimation) {
        this.npc.display.disableLivingAnimation = !livingAnimation;
    }

    @Override
    public void setVisibleType(int type) {
        this.npc.display.visible = type;
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public int getVisibleType() {
        return this.npc.display.visible;
    }

    @Override
    public void setVisibleTo(ScriptPlayer player, boolean visible) {
        UUID uuid = player.player.getPersistentID();
        ArrayList<UUID> uuidList = this.npc.display.invisibleToList;
        if (uuidList != null) {
            if (!uuidList.contains(uuid)) {
                if (!visible) {
                    this.npc.display.invisibleToList.add(uuid);
                }
            } else if (visible) {
                this.npc.display.invisibleToList.remove(uuid);
            }
        }
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public boolean isVisibleTo(ScriptPlayer player) {
        return !this.npc.scriptInvisibleToPlayer((EntityPlayer)player.player);
    }

    @Override
    public void setShowName(int type) {
        this.npc.display.showName = type;
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public int getShowName() {
        return this.npc.display.showName;
    }

    @Override
    public int getShowBossBar() {
        return this.npc.display.showBossBar;
    }

    @Override
    public void setShowBossBar(int type) {
        this.npc.display.showBossBar = (byte)type;
        this.npc.script.clientNeedsUpdate = true;
    }

    @Override
    public float getMeleeStrength() {
        return this.npc.stats.getAttackStrength();
    }

    @Override
    public void setMeleeStrength(float strength) {
        this.npc.stats.setAttackStrength(strength);
    }

    @Override
    public int getMeleeSpeed() {
        return this.npc.stats.attackSpeed;
    }

    @Override
    public void setMeleeSpeed(int speed) {
        this.npc.stats.attackSpeed = speed;
    }

    @Override
    public float getRangedStrength() {
        return this.npc.stats.pDamage;
    }

    @Override
    public void setRangedStrength(float strength) {
        this.npc.stats.pDamage = (float)Math.floor(strength);
    }

    @Override
    public int getRangedSpeed() {
        return this.npc.stats.pSpeed;
    }

    @Override
    public void setRangedSpeed(int speed) {
        this.npc.stats.pSpeed = speed;
    }

    @Override
    public int getRangedBurst() {
        return this.npc.stats.burstCount;
    }

    @Override
    public void setRangedBurst(int count) {
        this.npc.stats.burstCount = count;
    }

    @Override
    public int getRespawnTime() {
        return this.npc.stats.respawnTime;
    }

    @Override
    public void setRespawnTime(int time) {
        this.npc.stats.respawnTime = time;
    }

    @Override
    public int getRespawnCycle() {
        return this.npc.stats.spawnCycle;
    }

    @Override
    public void setRespawnCycle(int cycle) {
        if (cycle < 0) {
            cycle = 0;
        }
        if (cycle > 3) {
            cycle = 3;
        }
        this.npc.stats.spawnCycle = cycle;
    }

    @Override
    public boolean getHideKilledBody() {
        return this.npc.stats.hideKilledBody;
    }

    @Override
    public void hideKilledBody(boolean hide) {
        this.npc.stats.hideKilledBody = hide;
    }

    @Override
    public boolean naturallyDespawns() {
        return this.npc.stats.canDespawn;
    }

    @Override
    public void setNaturallyDespawns(boolean canDespawn) {
        this.npc.stats.canDespawn = canDespawn;
    }

    @Override
    public void giveItem(ScriptPlayer player, ScriptItemStack item) {
        this.npc.givePlayerItem((EntityPlayer)player.player, item.item);
    }

    @Override
    public void executeCommand(String command) {
        NoppesUtilServer.runCommand((EntityLivingBase)this.npc, this.npc.func_70005_c_(), command, null);
    }

    @Override
    public void setHeadScale(float x, float y, float z) {
        if (this.npc instanceof EntityCustomNpc) {
            ((EntityCustomNpc)this.npc).modelData.head.scaleX = ValueUtil.correctFloat(x, 0.5f, 1.5f);
            ((EntityCustomNpc)this.npc).modelData.head.scaleY = ValueUtil.correctFloat(y, 0.5f, 1.5f);
            ((EntityCustomNpc)this.npc).modelData.head.scaleZ = ValueUtil.correctFloat(z, 0.5f, 1.5f);
            this.npc.script.clientNeedsUpdate = true;
        }
    }

    @Override
    public void setBodyScale(float x, float y, float z) {
        if (this.npc instanceof EntityCustomNpc) {
            ((EntityCustomNpc)this.npc).modelData.body.scaleX = ValueUtil.correctFloat(x, 0.5f, 1.5f);
            ((EntityCustomNpc)this.npc).modelData.body.scaleY = ValueUtil.correctFloat(y, 0.5f, 1.5f);
            ((EntityCustomNpc)this.npc).modelData.body.scaleZ = ValueUtil.correctFloat(z, 0.5f, 1.5f);
            this.npc.script.clientNeedsUpdate = true;
        }
    }

    @Override
    public void setArmsScale(float x, float y, float z) {
        if (this.npc instanceof EntityCustomNpc) {
            ((EntityCustomNpc)this.npc).modelData.arms.scaleX = ValueUtil.correctFloat(x, 0.5f, 1.5f);
            ((EntityCustomNpc)this.npc).modelData.arms.scaleY = ValueUtil.correctFloat(y, 0.5f, 1.5f);
            ((EntityCustomNpc)this.npc).modelData.arms.scaleZ = ValueUtil.correctFloat(z, 0.5f, 1.5f);
            this.npc.script.clientNeedsUpdate = true;
        }
    }

    @Override
    public void setLegsScale(float x, float y, float z) {
        if (this.npc instanceof EntityCustomNpc) {
            ((EntityCustomNpc)this.npc).modelData.legs.scaleX = ValueUtil.correctFloat(x, 0.5f, 1.5f);
            ((EntityCustomNpc)this.npc).modelData.legs.scaleY = ValueUtil.correctFloat(y, 0.5f, 1.5f);
            ((EntityCustomNpc)this.npc).modelData.legs.scaleZ = ValueUtil.correctFloat(z, 0.5f, 1.5f);
            this.npc.script.clientNeedsUpdate = true;
        }
    }

    @Override
    public void setExplosionResistance(float resistance) {
        this.npc.stats.resistances.explosion = ValueUtil.correctFloat(resistance, 0.0f, 2.0f);
    }

    @Override
    public float getExplosionResistance() {
        return this.npc.stats.resistances.explosion;
    }

    @Override
    public void setMeleeResistance(float resistance) {
        this.npc.stats.resistances.playermelee = ValueUtil.correctFloat(resistance, 0.0f, 2.0f);
    }

    @Override
    public float getMeleeResistance() {
        return this.npc.stats.resistances.playermelee;
    }

    @Override
    public void setArrowResistance(float resistance) {
        this.npc.stats.resistances.arrow = ValueUtil.correctFloat(resistance, 0.0f, 2.0f);
    }

    @Override
    public float getArrowResistance() {
        return this.npc.stats.resistances.arrow;
    }

    @Override
    public void setKnockbackResistance(float resistance) {
        this.npc.stats.resistances.knockback = ValueUtil.correctFloat(resistance, 0.0f, 2.0f);
    }

    @Override
    public float getKnockbackResistance() {
        return this.npc.stats.resistances.knockback;
    }

    @Override
    public void setRetaliateType(int type) {
        this.npc.ai.onAttack = type;
        this.npc.setResponse();
    }

    @Override
    public float getCombatRegen() {
        return this.npc.stats.combatRegen;
    }

    @Override
    public void setCombatRegen(float regen) {
        this.npc.stats.combatRegen = (float)Math.floor(regen);
    }

    @Override
    public float getHealthRegen() {
        return this.npc.stats.healthRegen;
    }

    @Override
    public void setHealthRegen(float regen) {
        this.npc.stats.healthRegen = (float)Math.floor(regen);
    }

    @Override
    public long getAge() {
        return this.npc.totalTicksAlive;
    }

    public ITimers getTimers() {
        return this.npc.timers;
    }

    @Override
    public void setFly(int fly) {
        fly = fly > 0 ? 1 : 0;
        this.npc.ai.movementType = fly;
    }

    @Override
    public boolean canFly() {
        return this.npc.ai.movementType == 1;
    }

    @Override
    public void setFlySpeed(double flySpeed) {
        if (flySpeed < 0.0) {
            flySpeed = 0.0;
        }
        this.npc.ai.flySpeed = flySpeed;
    }

    @Override
    public double getFlySpeed(double flySpeed) {
        return this.npc.ai.flySpeed;
    }

    @Override
    public void setFlyGravity(double flyGravity) {
        if (flyGravity < 0.0) {
            flyGravity = 0.0;
        }
        if (flyGravity > 1.0) {
            flyGravity = 1.0;
        }
        this.npc.ai.flyGravity = flyGravity;
    }

    @Override
    public double getFlyGravity(double flySpeed) {
        return this.npc.ai.flyGravity;
    }

    public void setFlyHeightLimit(int flyHeightLimit) {
        if (flyHeightLimit < 0) {
            flyHeightLimit = 0;
        }
        this.npc.ai.flyHeightLimit = flyHeightLimit;
    }

    public int getFlyHeightLimit(int flyHeightLimit) {
        return this.npc.ai.flyHeightLimit;
    }

    public void limitFlyHeight(boolean limit) {
        this.npc.ai.hasFlyLimit = limit;
    }

    public boolean isFlyHeightLimited(boolean limit) {
        return this.npc.ai.hasFlyLimit;
    }

    @Override
    public void setSpeed(int speed) {
        this.npc.ai.setWalkingSpeed(speed);
    }

    @Override
    public int getSpeed() {
        return this.npc.ai.getWalkingSpeed();
    }

    @Override
    public void setSkinType(byte type) {
        this.npc.display.skinType = type;
        this.npc.updateClient = true;
    }

    @Override
    public byte getSkinType() {
        return this.npc.display.skinType;
    }

    @Override
    public void setSkinUrl(String url) {
        if (this.npc.display.url.equals(url)) {
            return;
        }
        this.npc.display.url = url;
        this.npc.textureLocation = null;
        this.npc.display.skinType = (byte)2;
        this.npc.updateClient = true;
    }

    @Override
    public String getSkinUrl() {
        return this.npc.display.url;
    }

    @Override
    public void setCloakTexture(String cloakTexture) {
        this.npc.display.cloakTexture = cloakTexture;
        this.npc.updateClient = true;
    }

    @Override
    public String getCloakTexture() {
        return this.npc.display.cloakTexture;
    }

    @Override
    public void setOverlayTexture(String overlayTexture) {
        this.npc.display.glowTexture = overlayTexture;
        this.npc.updateClient = true;
    }

    @Override
    public String getOverlayTexture() {
        return this.npc.display.glowTexture;
    }

    @Override
    public void setCollisionType(int type) {
        this.npc.display.collidesWith = type;
    }

    @Override
    public int getCollisionType() {
        return this.npc.display.collidesWith;
    }

    @Override
    public void updateClient() {
        this.npc.updateClient();
    }
}

