/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted.gui;

import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.gui.ScriptGuiComponent;
import noppes.npcs.scripted.interfaces.IItemSlot;
import noppes.npcs.scripted.interfaces.IItemStack;

public class ScriptGuiItemSlot
extends ScriptGuiComponent
implements IItemSlot {
    IItemStack stack;

    public ScriptGuiItemSlot() {
    }

    public ScriptGuiItemSlot(int x, int y) {
        this.setPos(x, y);
    }

    public ScriptGuiItemSlot(int x, int y, IItemStack stack) {
        this(x, y);
        this.setStack(stack);
    }

    @Override
    public boolean hasStack() {
        return this.stack != null && this.stack.getStackSize() > 0;
    }

    @Override
    public IItemStack getStack() {
        return this.stack;
    }

    @Override
    public IItemSlot setStack(IItemStack itemStack) {
        this.stack = itemStack;
        return this;
    }

    @Override
    public Slot getMCSlot() {
        return null;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        super.toNBT(nbt);
        if (this.hasStack()) {
            nbt.func_74782_a("stack", (NBTBase)this.stack.getItemNbt().getMCNBT());
        }
        return nbt;
    }

    @Override
    public ScriptGuiComponent fromNBT(NBTTagCompound nbt) {
        super.fromNBT(nbt);
        if (nbt.func_74764_b("stack")) {
            this.setStack(NpcAPI.Instance().getIItemStack(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("stack"))));
        }
        return this;
    }
}

