/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.armourer;

import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.armourer.tab.GuiTabArmourerBlockUtils;
import moe.plushie.armourers_workshop.client.gui.armourer.tab.GuiTabArmourerDisplaySettings;
import moe.plushie.armourers_workshop.client.gui.armourer.tab.GuiTabArmourerMain;
import moe.plushie.armourers_workshop.client.gui.armourer.tab.GuiTabArmourerSkinSettings;
import moe.plushie.armourers_workshop.client.gui.controls.AbstractGuiDialog;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTab;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTabPanel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTabbed;
import moe.plushie.armourers_workshop.client.gui.controls.IDialogCallback;
import moe.plushie.armourers_workshop.client.gui.controls.ModGuiControl;
import moe.plushie.armourers_workshop.common.data.type.Rectangle_I_2D;
import moe.plushie.armourers_workshop.common.inventory.ContainerArmourer;
import moe.plushie.armourers_workshop.common.inventory.slot.SlotHidable;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityArmourer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiArmourer
extends GuiTabbed<ContainerArmourer>
implements IDialogCallback,
ModGuiControl.IScreenSize {
    private static final ResourceLocation texture = new ResourceLocation("armourers_workshop:textures/gui/armourer/armourer.png");
    public final TileEntityArmourer tileEntity;
    private final String inventoryName;
    public GuiTabArmourerMain tabMain;
    public GuiTabArmourerDisplaySettings tabDisplaySettings;
    public GuiTabArmourerSkinSettings tabSkinSettings;
    public GuiTabArmourerBlockUtils tabBlockUtils;
    private static int activeTab;

    public GuiArmourer(InventoryPlayer invPlayer, TileEntityArmourer tileEntity) {
        super(new ContainerArmourer(invPlayer, tileEntity), false, TEXTURE_TAB_ICONS);
        this.tileEntity = tileEntity;
        this.inventoryName = tileEntity.func_70005_c_();
        this.tabMain = new GuiTabArmourerMain(0, this);
        this.tabDisplaySettings = new GuiTabArmourerDisplaySettings(1, (GuiScreen)this);
        this.tabSkinSettings = new GuiTabArmourerSkinSettings(2, (GuiScreen)this);
        this.tabBlockUtils = new GuiTabArmourerBlockUtils(3, (GuiScreen)this);
        this.tabList.add(this.tabMain);
        this.tabList.add(this.tabDisplaySettings);
        this.tabList.add(this.tabSkinSettings);
        this.tabList.add(this.tabBlockUtils);
        this.tabController.addTab(new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(this.inventoryName, "tab.main", new Object[0])).setIconLocation(0, 0).setTabTextureSize(26, 30).setPadding(0, 4, 3, 3).setAnimation(8, 150));
        this.tabController.addTab(new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(this.inventoryName, "tab.displaySettings", new Object[0])).setIconLocation(16, 0).setTabTextureSize(26, 30).setPadding(0, 4, 3, 3).setAnimation(8, 150));
        this.tabController.addTab(new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(this.inventoryName, "tab.skinSettings", new Object[0])).setIconLocation(32, 0).setTabTextureSize(26, 30).setPadding(0, 4, 3, 3).setAnimation(8, 150));
        this.tabController.addTab(new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(this.inventoryName, "tab.blockUtils", new Object[0])).setIconLocation(48, 0).setTabTextureSize(26, 30).setPadding(0, 4, 3, 3).setAnimation(8, 150));
        this.tabController.setActiveTabIndex(this.getActiveTab());
        this.tabChanged();
        this.skinTypeUpdate(tileEntity.getSkinType());
    }

    private void setSlotVisibility(boolean visible) {
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            Object slot = this.field_147002_h.field_75151_b.get(i);
            if (slot == null || !(slot instanceof SlotHidable)) continue;
            ((SlotHidable)((Object)slot)).setVisible(visible);
        }
    }

    @Override
    protected void tabChanged() {
        super.tabChanged();
        this.setSlotVisibility(this.getActiveTab() == 0);
    }

    @Override
    public void func_73866_w_() {
        this.field_146999_f = 176;
        this.field_147000_g = 224;
        super.func_73866_w_();
        if (this.isDialogOpen()) {
            this.dialog.initGui();
        }
        this.field_146292_n.clear();
        this.field_146292_n.add(this.tabController);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.tileEntity.loadedArmourItem) {
            this.tileEntity.loadedArmourItem = false;
            SkinProperties skinProperties = this.tileEntity.getSkinProps();
            this.tabMain.resetValues(skinProperties);
            this.tabSkinSettings.resetValues(skinProperties);
            this.skinTypeUpdate(this.tileEntity.getSkinType());
        }
    }

    public void skinTypeUpdate(ISkinType skinType) {
        if (skinType == SkinTypeRegistry.skinBow | skinType == SkinTypeRegistry.skinSword) {
            this.tabController.getTab(2).setVisable(false);
        } else {
            this.tabController.getTab(2).setVisable(true);
        }
    }

    protected void func_146976_a(float partialTickTime, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        for (int i = 0; i < this.tabList.size(); ++i) {
            GuiTabPanel tab = (GuiTabPanel)((Object)this.tabList.get(i));
            if (tab.getTabId() != this.getActiveTab()) continue;
            tab.drawBackgroundLayer(partialTickTime, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179097_i();
        GuiHelper.renderLocalizedGuiName(this.field_146289_q, this.field_146999_f, this.tileEntity.func_70005_c_());
        for (int i = 0; i < this.tabList.size(); ++i) {
            GuiTabPanel tab = (GuiTabPanel)((Object)this.tabList.get(i));
            if (tab.getTabId() != this.getActiveTab()) continue;
            tab.drawForegroundLayer(mouseX, mouseY, 0.0f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        this.tabController.drawHoverText(this.field_146297_k, mouseX, mouseY);
        GL11.glPopMatrix();
        GlStateManager.func_179126_j();
    }

    @Override
    protected int getActiveTab() {
        return activeTab;
    }

    @Override
    protected void setActiveTab(int value) {
        activeTab = value;
    }

    @Override
    public String getName() {
        return this.tileEntity.func_70005_c_();
    }

    @Override
    public void dialogResult(AbstractGuiDialog dialog, IDialogCallback.DialogResult result) {
        for (int i = 0; i < this.tabList.size(); ++i) {
            GuiTabPanel tab = (GuiTabPanel)((Object)this.tabList.get(i));
            if (tab.getTabId() != this.getActiveTab() || !(tab instanceof IDialogCallback)) continue;
            ((IDialogCallback)((Object)tab)).dialogResult(dialog, result);
        }
        this.closeDialog();
    }

    @Override
    public Rectangle_I_2D getSize() {
        return new Rectangle_I_2D(this.field_147003_i, this.field_147009_r, this.field_146294_l, this.field_146295_m);
    }
}

