/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.dialog;

import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.AbstractGuiDialog;
import moe.plushie.armourers_workshop.client.gui.controls.GuiDropDownList;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTextFieldCustom;
import moe.plushie.armourers_workshop.client.gui.controls.IDialogCallback;
import moe.plushie.armourers_workshop.common.library.global.task.user.GlobalTaskSkinReport;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiGlobalLibraryDialogReportSkin
extends AbstractGuiDialog {
    private final int skinId;
    private GuiButtonExt buttonOk;
    private GuiButtonExt buttonCancel;
    private GuiDropDownList dropDownReportType;
    private GuiTextFieldCustom textReportMessage;

    public GuiGlobalLibraryDialogReportSkin(GuiScreen parent, String name, IDialogCallback callback, int width, int height, int skinId) {
        super(parent, name, callback, width, height);
        this.skinId = skinId;
        this.slotHandler = null;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.buttonOk = new GuiButtonExt(0, this.x + this.width - 160 - 20, this.y + this.height - 30, 80, 20, I18n.func_135052_a((String)"inventory.armourers_workshop:common.button.ok", (Object[])new Object[0]));
        this.buttonCancel = new GuiButtonExt(0, this.x + this.width - 80 - 10, this.y + this.height - 30, 80, 20, I18n.func_135052_a((String)"inventory.armourers_workshop:common.button.cancel", (Object[])new Object[0]));
        this.dropDownReportType = new GuiDropDownList(0, this.x + 10, this.y + 25, this.width - 20, "", null);
        for (GlobalTaskSkinReport.SkinReport.SkinReportType reportType : GlobalTaskSkinReport.SkinReport.SkinReportType.values()) {
            this.dropDownReportType.addListItem(I18n.func_135052_a((String)reportType.getLangKey(), (Object[])new Object[0]), reportType.toString(), true);
        }
        this.dropDownReportType.setListSelectedIndex(0);
        this.textReportMessage = new GuiTextFieldCustom(this.x + 10, this.y + 45, this.width - 20, 80);
        this.textReportMessage.setEmptyLabel(GuiHelper.getLocalizedControlName(this.name, "optional_message", new Object[0]));
        this.textReportMessage.setMaxStringLength(255);
        this.buttonList.add(this.buttonOk);
        this.buttonList.add(this.buttonCancel);
        this.buttonList.add(this.dropDownReportType);
    }

    @Override
    public void update() {
        super.update();
        this.textReportMessage.updateCursorCounter();
    }

    @Override
    public boolean keyTyped(char c, int keycode) {
        boolean typed = false;
        if (!this.dropDownReportType.getIsDroppedDown() && this.textReportMessage.keyTyped(c, keycode)) {
            return true;
        }
        return super.keyTyped(c, keycode);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        this.textReportMessage.mouseClicked(mouseX, mouseY, button);
        if (!this.dropDownReportType.getIsDroppedDown() && button == 1 & this.textReportMessage.isFocused()) {
            this.textReportMessage.setText("");
        }
        super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.buttonCancel) {
            this.returnDialogResult(IDialogCallback.DialogResult.CANCEL);
        }
        if (button == this.buttonOk) {
            this.returnDialogResult(IDialogCallback.DialogResult.OK);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTickTime) {
        super.drawForeground(mouseX, mouseY, partialTickTime);
        GlStateManager.func_179140_f();
        this.drawTitle();
        this.textReportMessage.func_191745_a(this.mc, mouseX, mouseY, partialTickTime);
        this.dropDownReportType.drawForeground(this.mc, mouseX, mouseY, partialTickTime);
        this.fontRenderer.func_78279_b(GuiHelper.getLocalizedControlName(this.name, "label.report_warning", new Object[0]), this.x + 10, this.y + 130, this.width - 20, 0x7F0000);
    }

    public GlobalTaskSkinReport.SkinReport getSkinReport() {
        return new GlobalTaskSkinReport.SkinReport(this.skinId, this.getReportType(), this.getReportMessage());
    }

    private GlobalTaskSkinReport.SkinReport.SkinReportType getReportType() {
        return GlobalTaskSkinReport.SkinReport.SkinReportType.valueOf(this.dropDownReportType.getListSelectedItem().tag);
    }

    private String getReportMessage() {
        return this.textReportMessage.getText().trim();
    }
}

