/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiIconButton;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieAuth;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieSession;
import moe.plushie.armourers_workshop.common.library.global.permission.PermissionSystem;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGlobalLibraryPanelHeader
extends GuiPanel {
    private static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("armourers_workshop:textures/gui/global_library/global-library.png");
    private GuiIconButton iconButtonHome;
    private GuiIconButton iconButtonFavourites;
    private GuiIconButton iconButtonMyFiles;
    private GuiIconButton iconButtonUploadSkin;
    private GuiIconButton iconButtonJoin;
    private GuiIconButton iconButtonInfo;
    private GuiIconButton iconButtonModeration;
    private GuiIconButton iconButtonProfile;

    public GuiGlobalLibraryPanelHeader(GuiScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
    }

    @Override
    public void initGui() {
        super.initGui();
        String guiName = ((GuiGlobalLibrary)this.parent).getGuiName();
        this.buttonList.clear();
        this.iconButtonHome = new GuiIconButton(this.parent, 0, this.x + this.width - 21, this.y + 4, 18, 18, GuiHelper.getLocalizedControlName(guiName, "header.home", new Object[0]), BUTTON_TEXTURES).setIconLocation(0, 0, 16, 16);
        this.iconButtonMyFiles = new GuiIconButton(this.parent, 2, this.x + this.width - 41, this.y + 4, 18, 18, GuiHelper.getLocalizedControlName(guiName, "header.myFiles", new Object[0]), BUTTON_TEXTURES).setIconLocation(0, 34, 16, 16);
        this.iconButtonUploadSkin = new GuiIconButton(this.parent, 3, this.x + this.width - 61, this.y + 4, 18, 18, GuiHelper.getLocalizedControlName(guiName, "header.uploadSkin", new Object[0]), BUTTON_TEXTURES).setIconLocation(0, 51, 16, 16);
        this.iconButtonUploadSkin.setDisableText(GuiHelper.getLocalizedControlName(guiName, "header.uploadSkinBan", new Object[0]));
        this.iconButtonJoin = new GuiIconButton(this.parent, 4, this.x + this.width - 41, this.y + 4, 18, 18, GuiHelper.getLocalizedControlName(guiName, "header.join", new Object[0]), BUTTON_TEXTURES).setIconLocation(0, 68, 16, 16);
        this.iconButtonInfo = new GuiIconButton(this.parent, 5, this.x + this.width - 81, this.y + 4, 18, 18, GuiHelper.getLocalizedControlName(guiName, "header.info", new Object[0]), BUTTON_TEXTURES).setIconLocation(0, 17, 16, 16);
        this.iconButtonModeration = new GuiIconButton(this.parent, -1, this.x, this.y + 4, 18, 18, GuiHelper.getLocalizedControlName(guiName, "header.moderation", new Object[0]), BUTTON_TEXTURES).setIconLocation(0, 119, 16, 16);
        this.iconButtonProfile = new GuiIconButton(this.parent, -1, this.x + 1, this.y + 1, 24, 24, GuiHelper.getLocalizedControlName(guiName, "header.my_profile", new Object[0]), BUTTON_TEXTURES);
        this.buttonList.add(this.iconButtonHome);
        this.buttonList.add(this.iconButtonMyFiles);
        this.buttonList.add(this.iconButtonUploadSkin);
        this.buttonList.add(this.iconButtonJoin);
        this.buttonList.add(this.iconButtonInfo);
        this.buttonList.add(this.iconButtonModeration);
        this.betaCheckUpdate();
    }

    @Override
    public void update() {
        super.update();
        this.betaCheckUpdate();
    }

    private void betaCheckUpdate() {
        int padButton = 20;
        int buttonOffsetX = this.x + this.width - 21;
        this.iconButtonHome.field_146125_m = true;
        this.iconButtonMyFiles.field_146125_m = false;
        this.iconButtonUploadSkin.field_146125_m = false;
        this.iconButtonJoin.field_146125_m = false;
        this.iconButtonInfo.field_146125_m = true;
        this.iconButtonModeration.field_146125_m = false;
        this.iconButtonHome.field_146128_h = buttonOffsetX;
        buttonOffsetX -= padButton;
        boolean isRemoteUser = PlushieAuth.isRemoteUser();
        boolean doneRemoteUserCheck = PlushieAuth.doneRemoteUserCheck();
        PlushieSession session = PlushieAuth.PLUSHIE_SESSION;
        if (doneRemoteUserCheck & !isRemoteUser) {
            this.iconButtonJoin.field_146125_m = true;
            this.iconButtonJoin.field_146128_h = buttonOffsetX;
            buttonOffsetX -= padButton;
        }
        if (session.hasServerId()) {
            this.iconButtonMyFiles.field_146125_m = isRemoteUser;
            this.iconButtonMyFiles.field_146128_h = buttonOffsetX;
            this.iconButtonUploadSkin.field_146125_m = isRemoteUser;
            this.iconButtonUploadSkin.field_146124_l = session.hasPermission(PermissionSystem.PlushieAction.SKIN_UPLOAD);
            this.iconButtonUploadSkin.field_146128_h = buttonOffsetX -= padButton;
            buttonOffsetX -= padButton;
            if (session.hasPermission(PermissionSystem.PlushieAction.GET_REPORT_LIST)) {
                this.iconButtonModeration.field_146125_m = true;
                this.iconButtonModeration.field_146128_h = buttonOffsetX;
                buttonOffsetX -= padButton;
            }
        }
        this.iconButtonInfo.field_146128_h = buttonOffsetX;
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.iconButtonHome) {
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.HOME);
            ((GuiGlobalLibrary)this.parent).panelHome.updateSkinPanels();
        }
        if (button == this.iconButtonFavourites) {
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.FAVOURITES);
        }
        if (button == this.iconButtonMyFiles) {
            GuiGlobalLibrary guiGlobalLibrary = (GuiGlobalLibrary)this.parent;
            int serverId = PlushieAuth.PLUSHIE_SESSION.getServerId();
            ((GuiGlobalLibrary)this.parent).panelUserSkins.clearResults();
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.USER_SKINS);
            ((GuiGlobalLibrary)this.parent).panelUserSkins.switchToUser(serverId);
        }
        if (button == this.iconButtonUploadSkin) {
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.UPLOAD);
        }
        if (button == this.iconButtonJoin) {
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.JOIN);
        }
        if (button == this.iconButtonInfo) {
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.INFO);
            ((GuiGlobalLibrary)this.parent).panelInfo.updateInfo();
        }
        if (button == this.iconButtonModeration) {
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.MODERATION);
        }
        if (button == this.iconButtonProfile) {
            ((GuiGlobalLibrary)this.parent).panelProfile.setProfileTarget(null);
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.PROFILE);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
        String titleText = ((GuiGlobalLibrary)this.parent).getGuiName();
        this.func_73732_a(this.fontRenderer, GuiHelper.getLocalizedControlName(titleText, "name", new Object[0]), this.x + this.width / 2, this.y + this.height / 2 - this.fontRenderer.field_78288_b / 2, -1118482);
        super.draw(mouseX, mouseY, partialTickTime);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void drawbuttons(int mouseX, int mouseY, float partialTickTime) {
        GameProfile gameProfile;
        if (this.insideCheck & !this.isInside(mouseX, mouseY)) {
            mouseX = -10;
            mouseY = -10;
        }
        for (int i = 0; i < this.buttonList.size(); ++i) {
            ((GuiButton)this.buttonList.get(i)).func_191745_a(this.mc, mouseX, mouseY, partialTickTime);
        }
        String username = "MissingNo";
        int colour = 0xFFFFFF;
        if (PlushieAuth.PLUSHIE_SESSION.hasServerId()) {
            colour = 0xFFFFAA;
        }
        if (PlushieAuth.PLUSHIE_SESSION.isAuthenticated()) {
            colour = 0xAAFFAA;
        }
        if ((gameProfile = this.mc.field_71439_g.func_146103_bH()) != null) {
            username = gameProfile.getName();
            GuiHelper.drawPlayerHead(this.x + 4, this.y + 4, 16, username);
            this.fontRenderer.func_78276_b(" - " + username, this.x + 24, this.y + this.height / 2 - this.fontRenderer.field_78288_b / 2, colour);
        } else {
            GuiHelper.drawPlayerHead(this.x + 4, this.y + 4, 16, null);
            colour = 0xFFAAAA;
            this.fontRenderer.func_78276_b(" - " + username, this.x + 24, this.y + this.height / 2 - this.fontRenderer.field_78288_b / 2, colour);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.buttonList.size(); ++i) {
            if (!(this.buttonList.get(i) instanceof GuiIconButton)) continue;
            ((GuiIconButton)((Object)this.buttonList.get(i))).drawRollover(this.mc, mouseX, mouseY);
        }
    }

    private void drawPlayerHead(String username) {
        ResourceLocation rl = DefaultPlayerSkin.func_177335_a();
        if (username != null) {
            rl = AbstractClientPlayer.func_110311_f((String)username);
            AbstractClientPlayer.func_110304_a((ResourceLocation)rl, (String)username);
        }
        this.mc.field_71446_o.func_110577_a(rl);
        int sourceSize = 8;
        int targetSize = 16;
        GuiGlobalLibraryPanelHeader.func_152125_a((int)(this.x + 5), (int)(this.y + 5), (float)8.0f, (float)8.0f, (int)sourceSize, (int)sourceSize, (int)targetSize, (int)targetSize, (float)64.0f, (float)32.0f);
        GuiGlobalLibraryPanelHeader.func_152125_a((int)(this.x + 4), (int)(this.y + 4), (float)40.0f, (float)8.0f, (int)sourceSize, (int)sourceSize, (int)(targetSize + 2), (int)(targetSize + 2), (float)64.0f, (float)32.0f);
    }
}

