/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.google.common.util.concurrent.FutureCallback;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiCustomLabel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiLabeledTextField;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTextFieldCustom;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.common.inventory.slot.SlotHidable;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieAuth;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieSession;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskResult;
import moe.plushie.armourers_workshop.common.library.global.task.user.GlobalTaskSkinUpload;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiButton;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.utils.ModLogger;
import moe.plushie.armourers_workshop.utils.SkinIOUtils;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class GuiGlobalLibraryPanelUpload
extends GuiPanel {
    private static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("armourers_workshop:textures/gui/global_library/global-library.png");
    private final String guiName;
    private GuiLabeledTextField textName;
    private GuiLabeledTextField textTags;
    private GuiTextFieldCustom textDescription;
    private GuiButtonExt buttonUpload;
    private GuiCustomLabel statsText;
    private String error = null;

    public GuiGlobalLibraryPanelUpload(GuiScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.guiName = ((GuiGlobalLibrary)parent).getGuiName() + ".upload";
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.textName = new GuiLabeledTextField(this.fontRenderer, this.x + 5, this.y + 35, this.width - 15 - 162, 12);
        this.textName.setEmptyLabel(GuiHelper.getLocalizedControlName(this.guiName, "enterName", new Object[0]));
        this.textName.func_146203_f(80);
        this.textTags = new GuiLabeledTextField(this.fontRenderer, this.x + 5, this.y + 65, this.width - 15 - 162, 12);
        this.textTags.setEmptyLabel(GuiHelper.getLocalizedControlName(this.guiName, "enterTags", new Object[0]));
        this.textDescription = new GuiTextFieldCustom(this.x + 5, this.y + 95, this.width - 15 - 162, this.height - 95 - 40);
        this.textDescription.setEmptyLabel(GuiHelper.getLocalizedControlName(this.guiName, "enterDescription", new Object[0]));
        this.textDescription.setMaxStringLength(255);
        this.buttonUpload = new GuiButtonExt(0, this.x + 23, this.y + this.height - 28, 96, 18, GuiHelper.getLocalizedControlName(this.guiName, "buttonUpload", new Object[0]));
        this.buttonUpload.field_146124_l = false;
        this.statsText = new GuiCustomLabel(this.fontRenderer, this.x + this.width - 162 - 5, this.y + 5, 162, this.height - 90);
        this.buttonList.add(this.buttonUpload);
        if (this.visible) {
            this.updatePlayerSlots();
        }
    }

    @Override
    public GuiPanel setVisible(boolean visible) {
        if (visible) {
            this.updatePlayerSlots();
        }
        return super.setVisible(visible);
    }

    private void updatePlayerSlots() {
        ((GuiGlobalLibrary)this.parent).setPlayerSlotLocation(this.x + this.width - 162 - 4, this.y + this.height - 81);
        ((GuiGlobalLibrary)this.parent).setInputSlotLocation(this.x + 3, this.y + this.height - 27);
        ((GuiGlobalLibrary)this.parent).setOutputSlotLocation(this.x + 127, this.y + this.height - 27);
    }

    @Override
    public boolean keyTyped(char c, int keycode) {
        if (!this.visible | !this.enabled) {
            return false;
        }
        if (this.textName.func_146201_a(c, keycode)) {
            return true;
        }
        if (this.textTags.func_146201_a(c, keycode)) {
            return true;
        }
        return this.textDescription.keyTyped(c, keycode);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.visible | !this.enabled) {
            return false;
        }
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        if (!clicked) {
            clicked = this.textName.func_146192_a(mouseX, mouseY, button);
            clicked = this.textTags.func_146192_a(mouseX, mouseY, button);
            clicked = this.textDescription.mouseClicked(mouseX, mouseY, button);
        }
        if (!clicked) {
            clicked = this.statsText.mouseClick(mouseX, mouseY, button);
        }
        if (button == 1) {
            if (this.textName.func_146206_l()) {
                this.textName.func_146180_a("");
            }
            if (this.textTags.func_146206_l()) {
                this.textTags.func_146180_a("");
            }
            if (this.textDescription.isFocused()) {
                this.textDescription.setText("");
            }
        }
        return clicked;
    }

    @Override
    public void update() {
        SlotHidable slot;
        super.update();
        this.buttonUpload.field_146124_l = false;
        if (!StringUtils.func_151246_b((String)this.textName.func_146179_b()) && SkinNBTHelper.stackHasSkinData((slot = ((GuiGlobalLibrary)this.parent).getInputSlot()).func_75211_c())) {
            this.buttonUpload.field_146124_l = true;
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.buttonUpload) {
            GameProfile gameProfile = this.mc.field_71439_g.func_146103_bH();
            PlushieSession plushieSession = PlushieAuth.PLUSHIE_SESSION;
            if (!plushieSession.isAuthenticated()) {
                JsonObject jsonObject = PlushieAuth.authenticateUser(gameProfile.getName(), gameProfile.getId().toString());
                plushieSession.authenticate(jsonObject);
            }
            if (!plushieSession.isAuthenticated()) {
                ModLogger.log(Level.ERROR, "Authentication failed.");
                return;
            }
            MessageClientGuiButton message = new MessageClientGuiButton(0);
            PacketHandler.networkWrapper.sendToServer((IMessage)message);
        }
    }

    public void uploadSkin(Skin skin) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SkinIOUtils.saveSkinToStream(outputStream, skin);
        byte[] fileBytes = outputStream.toByteArray();
        IOUtils.closeQuietly((OutputStream)outputStream);
        new GlobalTaskSkinUpload(fileBytes, this.textName.func_146179_b().trim(), this.textDescription.getText().trim()).createTaskAndRun(new FutureCallback<GlobalTaskSkinUpload.Result>(){

            public void onSuccess(final GlobalTaskSkinUpload.Result result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        if (result.getResult() == GlobalTaskResult.SUCCESS) {
                            ((GuiGlobalLibrary)((GuiGlobalLibraryPanelUpload)GuiGlobalLibraryPanelUpload.this).parent).panelHome.updateSkinPanels();
                            ((GuiGlobalLibrary)GuiGlobalLibraryPanelUpload.this.parent).switchScreen(GuiGlobalLibrary.Screen.HOME);
                        } else {
                            GuiGlobalLibraryPanelUpload.this.error = result.getMessage();
                        }
                    }
                });
            }

            public void onFailure(final Throwable t) {
                t.printStackTrace();
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        GuiGlobalLibraryPanelUpload.this.error = t.getMessage();
                    }
                });
            }
        });
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
        this.mc.field_71446_o.func_110577_a(BUTTON_TEXTURES);
        this.func_73729_b(this.x + this.width - 162 - 5, this.y + this.height - 82, 0, 180, 162, 76);
        this.func_73729_b(this.x + 2, this.y + this.height - 28, 0, 162, 18, 18);
        this.func_73729_b(this.x + 122, this.y + this.height - 32, 18, 154, 26, 26);
        super.draw(mouseX, mouseY, partialTickTime);
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "name", new Object[0]), this.x + 5, this.y + 5, 0xFFFFFF);
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "skinName", new Object[0]), this.x + 5, this.y + 25, 0xFFFFFF);
        this.textName.func_146194_f();
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "skinTags", new Object[0]), this.x + 5, this.y + 55, 0xFFFFFF);
        this.textTags.func_146194_f();
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "skinDescription", new Object[0]), this.x + 5, this.y + 85, 0xFFFFFF);
        this.textDescription.func_191745_a(this.mc, mouseX, mouseY, partialTickTime);
        this.statsText.clearText();
        this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "label.upload_warning", new Object[0]));
        this.statsText.addNewLine();
        this.statsText.addNewLine();
        if (!StringUtils.func_151246_b((String)this.error)) {
            this.statsText.addText(TextFormatting.RED.toString());
            this.statsText.addText("Error: " + this.error);
            this.statsText.addText(TextFormatting.RESET.toString());
            this.statsText.addNewLine();
            this.statsText.addNewLine();
        }
        this.statsText.draw(mouseX, mouseY);
    }
}

