/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.model.bake;

import java.awt.Point;
import java.awt.image.BufferedImage;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartTypeTextured;
import moe.plushie.armourers_workshop.client.model.bake.FaceRenderer;
import moe.plushie.armourers_workshop.client.render.IRenderBuffer;
import moe.plushie.armourers_workshop.client.render.SkinPartRenderData;
import moe.plushie.armourers_workshop.client.skin.ClientSkinPartData;
import moe.plushie.armourers_workshop.common.TextureHelper;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class ColouredFace {
    public final byte x;
    public final byte y;
    public final byte z;
    public final byte r;
    public final byte g;
    public final byte b;
    private final byte a;
    public final byte t;
    public final byte face;
    private final byte lodLevel;

    public ColouredFace(byte x, byte y, byte z, byte r, byte g, byte b, byte a, byte paintType, byte face, byte lodLevel) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.t = paintType;
        this.face = face;
        this.lodLevel = lodLevel;
    }

    public void renderVertex(IRenderBuffer renderBuffer, SkinPartRenderData renderData, ClientSkinPartData cspd) {
        byte[] dyedColour;
        int[] averageRGB;
        byte[] dye;
        byte r = this.r;
        byte g = this.g;
        byte b = this.b;
        IPaintType type = PaintTypeRegistry.getInstance().getPaintTypeFormByte(this.t);
        ISkinDye skinDye = renderData.getSkinDye();
        IExtraColours extraColours = renderData.getExtraColours();
        if (type == PaintTypeRegistry.PAINT_TYPE_NONE) {
            return;
        }
        int channelIndex = type.getChannelIndex();
        if (type.getId() >= 1 && type.getId() <= 8 && skinDye != null && skinDye.haveDyeInSlot(type.getId() - 1) && (dye = skinDye.getDyeColour(type.getId() - 1)).length == 4) {
            IPaintType dyeType = PaintTypeRegistry.getInstance().getPaintTypeFormByte(dye[3]);
            if (dyeType == PaintTypeRegistry.PAINT_TYPE_NONE) {
                return;
            }
            if (dyeType == PaintTypeRegistry.PAINT_TYPE_NORMAL) {
                byte[] extraColour;
                int[] averageRGB2 = cspd.getAverageDyeColour(channelIndex);
                byte[] dyedColour2 = null;
                dyedColour2 = dyeType.getColourType() != null & extraColours != null ? ((extraColour = extraColours.getColourBytes(dyeType.getColourType())).length == 4 && (extraColour[3] & 0xFF) != 0 ? ColouredFace.dyeColour(r, g, b, extraColours.getColourBytes(dyeType.getColourType()), averageRGB2) : ColouredFace.dyeColour(r, g, b, dye, averageRGB2)) : ColouredFace.dyeColour(r, g, b, dye, averageRGB2);
                r = dyedColour2[0];
                g = dyedColour2[1];
                b = dyedColour2[2];
            }
            type = dyeType;
        }
        if (type == PaintTypeRegistry.PAINT_TYPE_RAINBOW) {
            averageRGB = cspd.getAverageDyeColour(channelIndex);
            dyedColour = ColouredFace.dyeColour(r, g, b, new byte[]{127, 127, 127}, averageRGB);
            r = dyedColour[0];
            g = dyedColour[1];
            b = dyedColour[2];
        } else if (type == PaintTypeRegistry.PAINT_TYPE_TEXTURE & renderData.getEntityTexture() != null & ClientProxy.getTexturePaintType() != ClientProxy.TexturePaintType.TEXTURE_REPLACE) {
            BufferedImage image;
            if (renderData.getSkinPart().getPartType() instanceof ISkinPartTypeTextured && (image = TextureHelper.getBufferedImageSkin(renderData.getEntityTexture())) != null) {
                dyedColour = ColouredFace.getColourFromTexture(this.x, this.y, this.z, r, g, b, this.face, image, (ISkinPartTypeTextured)renderData.getSkinPart().getPartType(), false);
                r = dyedColour[0];
                g = dyedColour[1];
                b = dyedColour[2];
            }
        } else if (extraColours != null && type.getColourType() != null) {
            averageRGB = cspd.getAverageDyeColour(channelIndex);
            dyedColour = ColouredFace.dyeColour(r, g, b, extraColours.getColourBytes(type.getColourType()), averageRGB);
            r = dyedColour[0];
            g = dyedColour[1];
            b = dyedColour[2];
        }
        double paintScale = 0.00390625;
        FaceRenderer.renderFace(this.x, this.y, this.z, r, g, b, this.a, this.face, this.lodLevel, (double)type.getU() * paintScale, (double)type.getV() * paintScale, (double)type.getU() * paintScale + paintScale, (double)type.getV() * paintScale + paintScale);
    }

    public static byte[] getColourFromTexture(byte x, byte y, byte z, byte r, byte g, byte b, byte face, BufferedImage image, ISkinPartTypeTextured skinPartTex, boolean oldImage) {
        EnumFacing facing = EnumFacing.field_82609_l[face];
        Point posBase = skinPartTex.getTextureBasePos();
        if (oldImage) {
            posBase = skinPartTex.getTextureSkinPos();
        }
        int posX = posBase.x;
        int posY = posBase.y;
        int faceX = 0;
        int faceY = 0;
        int faceWidth = 0;
        int faceHeight = 0;
        int faceOffsetX = 0;
        int faceOffsetY = 0;
        if (skinPartTex.isTextureMirrored()) {
            // empty if block
        }
        switch (facing) {
            case NORTH: {
                faceX = skinPartTex.getGuideSpace().getDepth();
                faceY = skinPartTex.getGuideSpace().getDepth();
                faceWidth = skinPartTex.getGuideSpace().getWidth();
                faceHeight = skinPartTex.getGuideSpace().getHeight();
                faceOffsetX = skinPartTex.getGuideSpace().getX() + faceWidth + x;
                faceOffsetY = skinPartTex.getGuideSpace().getY() + faceHeight + y;
                break;
            }
            case EAST: {
                faceX = 0;
                faceY = skinPartTex.getGuideSpace().getDepth();
                faceWidth = skinPartTex.getGuideSpace().getDepth();
                faceHeight = skinPartTex.getGuideSpace().getHeight();
                faceOffsetX = skinPartTex.getGuideSpace().getZ() + faceWidth + z;
                faceOffsetX = faceWidth - faceOffsetX - 1;
                faceOffsetY = skinPartTex.getGuideSpace().getY() + faceHeight + y;
                break;
            }
            case SOUTH: {
                faceX = skinPartTex.getGuideSpace().getDepth() * 2 + skinPartTex.getGuideSpace().getWidth();
                faceY = skinPartTex.getGuideSpace().getDepth();
                faceWidth = skinPartTex.getGuideSpace().getWidth();
                faceHeight = skinPartTex.getGuideSpace().getHeight();
                faceOffsetX = faceWidth + skinPartTex.getGuideSpace().getX() + x;
                faceOffsetX = faceWidth - faceOffsetX - 1;
                faceOffsetY = skinPartTex.getGuideSpace().getY() + faceHeight + y;
                break;
            }
            case WEST: {
                faceX = skinPartTex.getGuideSpace().getDepth() + skinPartTex.getGuideSpace().getWidth();
                faceY = skinPartTex.getGuideSpace().getDepth();
                faceWidth = skinPartTex.getGuideSpace().getDepth();
                faceHeight = skinPartTex.getGuideSpace().getHeight();
                faceOffsetX = skinPartTex.getGuideSpace().getZ() + faceWidth + z;
                faceOffsetY = skinPartTex.getGuideSpace().getY() + faceHeight + y;
                break;
            }
            case UP: {
                faceX = skinPartTex.getGuideSpace().getDepth();
                faceY = 0;
                faceWidth = skinPartTex.getGuideSpace().getWidth();
                faceHeight = skinPartTex.getGuideSpace().getDepth();
                faceOffsetX = skinPartTex.getGuideSpace().getX() + faceWidth + x;
                faceOffsetY = skinPartTex.getGuideSpace().getZ() + faceHeight + z;
                break;
            }
            case DOWN: {
                faceX = skinPartTex.getGuideSpace().getDepth() + skinPartTex.getGuideSpace().getWidth();
                faceY = 0;
                faceWidth = skinPartTex.getGuideSpace().getWidth();
                faceHeight = skinPartTex.getGuideSpace().getDepth();
                faceOffsetX = skinPartTex.getGuideSpace().getX() + faceWidth + x;
                faceOffsetY = skinPartTex.getGuideSpace().getZ() + faceHeight + z;
                faceOffsetY = faceHeight - faceOffsetY - 1;
            }
        }
        int srcX = MathHelper.func_76125_a((int)(posX + faceX + faceOffsetX), (int)(posX + faceX), (int)(posX + faceX + faceWidth));
        int srcY = MathHelper.func_76125_a((int)(posY + faceY + faceOffsetY), (int)(posY + faceY), (int)(posY + faceY + faceHeight));
        Point p = new Point(srcX, srcY);
        if (p.x >= 0 & p.y >= 0 & p.x < image.getWidth() & p.y < image.getHeight()) {
            int rgb = image.getRGB(p.x, p.y);
            return PaintingHelper.intToBytes(rgb);
        }
        return new byte[]{r, g, b, 0};
    }

    public static byte[] dyeColour(byte r, byte g, byte b, byte[] dyeColour, int[] modelAverageColour) {
        if (dyeColour.length == 4 && (dyeColour[3] & 0xFF) == 0) {
            return new byte[]{r, g, b};
        }
        int average = ((r & 0xFF) + (g & 0xFF) + (b & 0xFF)) / 3;
        int modelAverage = (modelAverageColour[0] + modelAverageColour[1] + modelAverageColour[2]) / 3;
        int nR = average + (dyeColour[0] & 0xFF) - modelAverage;
        int nG = average + (dyeColour[1] & 0xFF) - modelAverage;
        int nB = average + (dyeColour[2] & 0xFF) - modelAverage;
        nR = MathHelper.func_76125_a((int)nR, (int)0, (int)255);
        nG = MathHelper.func_76125_a((int)nG, (int)0, (int)255);
        nB = MathHelper.func_76125_a((int)nB, (int)0, (int)255);
        return new byte[]{(byte)nR, (byte)nG, (byte)nB};
    }
}

