/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.model.skin;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.skin.Point3D;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.client.model.skin.ModelTypeHelper;
import moe.plushie.armourers_workshop.client.render.SkinPartRenderData;
import moe.plushie.armourers_workshop.client.render.SkinRenderData;
import moe.plushie.armourers_workshop.client.skin.SkinModelTexture;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinPaintCache;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinPart;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import org.lwjgl.opengl.GL11;

public class ModelSkinOutfit
extends ModelTypeHelper {
    @Override
    public void render(Entity entity, Skin skin, boolean showSkinPaint, ISkinDye skinDye, IExtraColours extraColours, boolean itemRender, double distance, boolean doLodLoading) {
        this.render(entity, skin, new SkinRenderData(SCALE, skinDye, extraColours, distance, doLodLoading, showSkinPaint, itemRender, null));
    }

    @Override
    public void render(Entity entity, Skin skin, SkinRenderData renderData) {
        if (skin == null) {
            return;
        }
        ArrayList<SkinPart> parts = skin.getParts();
        if (entity != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.field_78117_n = player.func_70093_af();
            this.field_78093_q = player.func_184218_aH();
        }
        GlStateManager.func_179123_a();
        RenderHelper.func_74520_c();
        if (skin.hasPaintData() & renderData.isShowSkinPaint() & ClientProxy.getTexturePaintType() == ClientProxy.TexturePaintType.TEXTURE_REPLACE) {
            SkinModelTexture st = ClientSkinPaintCache.INSTANCE.getTextureForSkin(skin, renderData.getSkinDye(), renderData.getExtraColours());
            st.bindTexture();
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3008);
            if (!renderData.isItemRender()) {
                GlStateManager.func_179088_q();
                GlStateManager.func_179136_a((float)-2.0f, (float)1.0f);
            }
            this.field_78116_c.func_78785_a(SCALE);
            this.field_78115_e.func_78785_a(SCALE);
            this.field_178724_i.func_78785_a(SCALE);
            this.field_178723_h.func_78785_a(SCALE);
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.005f);
            GL11.glTranslated((double)0.02f, (double)0.0, (double)0.0);
            this.field_178722_k.func_78785_a(SCALE);
            GL11.glTranslated((double)-0.02f, (double)0.0, (double)0.0);
            this.field_178721_j.func_78785_a(SCALE);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.005f);
            if (!renderData.isItemRender()) {
                GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
                GlStateManager.func_179113_r();
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        boolean overrideChest = SkinProperties.PROP_MODEL_OVERRIDE_CHEST.getValue(skin.getProperties());
        double angle = 45.0;
        for (int i = 0; i < parts.size(); ++i) {
            SkinPart part = parts.get(i);
            GL11.glPushMatrix();
            if (this.field_78091_s) {
                float f6 = 2.0f;
                GL11.glScalef((float)(1.0f / f6), (float)(1.0f / f6), (float)(1.0f / f6));
                GL11.glTranslatef((float)0.0f, (float)(24.0f * SCALE), (float)0.0f);
            }
            if (part.getPartType().getRegistryName().equals("armourers:head.base")) {
                boolean doHead = true;
                if (entity != null && entity.equals((Object)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    StackTraceElement[] traceElements = Thread.currentThread().getStackTrace();
                    for (int j = 0; j < traceElements.length; ++j) {
                        StackTraceElement traceElement = traceElements[j];
                        if (!(traceElement.toString().contains("realrender") | traceElement.toString().contains("rfpf"))) continue;
                        doHead = false;
                        break;
                    }
                }
                if (doHead) {
                    this.renderHead(new SkinPartRenderData(part, renderData));
                }
            }
            if (part.getPartType().getRegistryName().equals("armourers:chest.base")) {
                this.renderChest(new SkinPartRenderData(part, renderData));
            } else if (part.getPartType().getRegistryName().equals("armourers:chest.leftArm")) {
                this.renderLeftArm(new SkinPartRenderData(part, renderData), overrideChest);
            } else if (part.getPartType().getRegistryName().equals("armourers:chest.rightArm")) {
                this.renderRightArm(new SkinPartRenderData(part, renderData), overrideChest);
            }
            if (part.getPartType().getRegistryName().equals("armourers:legs.leftLeg")) {
                this.renderLeftLeg(new SkinPartRenderData(part, renderData));
            } else if (part.getPartType().getRegistryName().equals("armourers:legs.rightLeg")) {
                this.renderRightLeg(new SkinPartRenderData(part, renderData));
            } else if (part.getPartType().getRegistryName().equals("armourers:legs.skirt")) {
                this.renderSkirt(new SkinPartRenderData(part, renderData));
            }
            if (part.getPartType().getRegistryName().equals("armourers:feet.leftFoot")) {
                this.renderLeftFoot(new SkinPartRenderData(part, renderData));
            } else if (part.getPartType().getRegistryName().equals("armourers:feet.rightFoot")) {
                this.renderRightFoot(new SkinPartRenderData(part, renderData));
            }
            if (part.getPartType().getRegistryName().equals("armourers:wings.leftWing")) {
                angle = SkinUtils.getFlapAngleForWings(entity, skin, i);
                this.renderLeftWing(new SkinPartRenderData(part, renderData), angle);
            }
            if (part.getPartType().getRegistryName().equals("armourers:wings.rightWing")) {
                angle = SkinUtils.getFlapAngleForWings(entity, skin, i);
                this.renderRightWing(new SkinPartRenderData(part, renderData), -angle);
            }
            GL11.glPopMatrix();
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderHead(SkinPartRenderData partRenderData) {
        GL11.glPushMatrix();
        if (this.field_78117_n) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(1.0f * partRenderData.getScale()), (float)0.0f);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotated((double)Math.toDegrees(this.field_78116_c.field_78808_h), (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)Math.toDegrees(this.field_78116_c.field_78796_g), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)Math.toDegrees(this.field_78116_c.field_78795_f), (double)1.0, (double)0.0, (double)0.0);
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }

    private void renderChest(SkinPartRenderData partRenderData) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_78115_e.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.field_78117_n) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(this.field_78115_e.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }

    private void renderLeftArm(SkinPartRenderData partRenderData, boolean override) {
        GL11.glPushMatrix();
        if (this.field_78117_n) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_78115_e.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(5.0f * partRenderData.getScale()), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(2.0f * partRenderData.getScale()), (float)0.0f);
        if (this.slim & !override) {
            GlStateManager.func_179109_b((float)0.0f, (float)(partRenderData.getScale() * 0.5f), (float)0.0f);
        }
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178724_i.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178724_i.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178724_i.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.slim & !override) {
            GL11.glTranslatef((float)(-0.25f * partRenderData.getScale()), (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.75f, (float)1.0f, (float)1.0f);
        }
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }

    private void renderRightArm(SkinPartRenderData partRenderData, boolean override) {
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_78117_n) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_78115_e.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(-5.0f * partRenderData.getScale()), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(2.0f * partRenderData.getScale()), (float)0.0f);
        if (this.slim & !override) {
            GlStateManager.func_179109_b((float)0.0f, (float)(partRenderData.getScale() * 0.5f), (float)0.0f);
        }
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178723_h.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178723_h.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178723_h.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.slim & !override) {
            GL11.glTranslatef((float)(0.25f * partRenderData.getScale()), (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.75f, (float)1.0f, (float)1.0f);
        }
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }

    private void renderLeftLeg(SkinPartRenderData partRenderData) {
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_78117_n) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(-3.0f * partRenderData.getScale()), (float)(4.0f * partRenderData.getScale()));
        }
        GL11.glTranslated((double)0.0, (double)(12.0f * partRenderData.getScale()), (double)0.0);
        GL11.glTranslated((double)(2.0f * partRenderData.getScale()), (double)0.0, (double)0.0);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178722_k.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178722_k.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178722_k.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }

    private void renderRightLeg(SkinPartRenderData partRenderData) {
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_78117_n) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(-3.0f * partRenderData.getScale()), (float)(4.0f * partRenderData.getScale()));
        }
        GL11.glTranslated((double)0.0, (double)(12.0f * partRenderData.getScale()), (double)0.0);
        GL11.glTranslated((double)(-2.0f * partRenderData.getScale()), (double)0.0, (double)0.0);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178721_j.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178721_j.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178721_j.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }

    private void renderLeftFoot(SkinPartRenderData partRenderData) {
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_78117_n) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(-3.0f * partRenderData.getScale()), (float)(4.0f * partRenderData.getScale()));
        }
        GL11.glTranslated((double)0.0, (double)(12.0f * partRenderData.getScale()), (double)0.0);
        GL11.glTranslated((double)(2.0f * partRenderData.getScale()), (double)0.0, (double)0.0);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178722_k.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178722_k.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178722_k.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }

    private void renderRightFoot(SkinPartRenderData partRenderData) {
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_78117_n) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(-3.0f * partRenderData.getScale()), (float)(4.0f * partRenderData.getScale()));
        }
        GL11.glTranslated((double)0.0, (double)(12.0f * partRenderData.getScale()), (double)0.0);
        GL11.glTranslated((double)(-2.0f * partRenderData.getScale()), (double)0.0, (double)0.0);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178721_j.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178721_j.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_178721_j.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }

    private void renderSkirt(SkinPartRenderData partRenderData) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_78115_e.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_78117_n) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(-3.0f * partRenderData.getScale()), (float)(4.0f * partRenderData.getScale()));
        }
        GL11.glTranslated((double)0.0, (double)(12.0f * partRenderData.getScale()), (double)0.0);
        if (this.field_78093_q) {
            GL11.glRotated((double)-70.0, (double)1.0, (double)0.0, (double)0.0);
        }
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }

    private void renderLeftWing(SkinPartRenderData partRenderData, double angle) {
        GL11.glPushMatrix();
        if (this.field_78117_n) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(this.field_78115_e.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)(partRenderData.getScale() * 2.0f));
        Point3D point = new Point3D(0, 0, 0);
        EnumFacing axis = EnumFacing.DOWN;
        if (partRenderData.getSkinPart().getMarkerCount() > 0) {
            point = partRenderData.getSkinPart().getMarker(0);
            axis = partRenderData.getSkinPart().getMarkerSide(0);
        }
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_78115_e.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_78115_e.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)(partRenderData.getScale() * 0.5f), (double)(partRenderData.getScale() * 0.5f), (double)(partRenderData.getScale() * 0.5f));
        GL11.glTranslated((double)(partRenderData.getScale() * (float)point.getX()), (double)(partRenderData.getScale() * (float)point.getY()), (double)(partRenderData.getScale() * (float)point.getZ()));
        switch (axis) {
            case UP: {
                GL11.glRotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case DOWN: {
                GL11.glRotated((double)angle, (double)0.0, (double)-1.0, (double)0.0);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)-1.0);
                break;
            }
            case NORTH: {
                GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case EAST: {
                GL11.glRotated((double)angle, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case WEST: {
                GL11.glRotated((double)angle, (double)-1.0, (double)0.0, (double)0.0);
            }
        }
        GL11.glTranslated((double)(partRenderData.getScale() * (float)(-point.getX())), (double)(partRenderData.getScale() * (float)(-point.getY())), (double)(partRenderData.getScale() * (float)(-point.getZ())));
        GL11.glTranslated((double)(partRenderData.getScale() * -0.5f), (double)(partRenderData.getScale() * -0.5f), (double)(partRenderData.getScale() * -0.5f));
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }

    private void renderRightWing(SkinPartRenderData partRenderData, double angle) {
        GL11.glPushMatrix();
        if (this.field_78117_n) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(this.field_78115_e.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)(partRenderData.getScale() * 2.0f));
        Point3D point = new Point3D(0, 0, 0);
        EnumFacing axis = EnumFacing.DOWN;
        if (partRenderData.getSkinPart().getMarkerCount() > 0) {
            point = partRenderData.getSkinPart().getMarker(0);
            axis = partRenderData.getSkinPart().getMarkerSide(0);
        }
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_78115_e.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)Math.toDegrees(this.field_78115_e.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)(partRenderData.getScale() * 0.5f), (double)(partRenderData.getScale() * 0.5f), (double)(partRenderData.getScale() * 0.5f));
        GL11.glTranslated((double)(partRenderData.getScale() * (float)point.getX()), (double)(partRenderData.getScale() * (float)point.getY()), (double)(partRenderData.getScale() * (float)point.getZ()));
        switch (axis) {
            case UP: {
                GL11.glRotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case DOWN: {
                GL11.glRotated((double)angle, (double)0.0, (double)-1.0, (double)0.0);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)-1.0);
                break;
            }
            case NORTH: {
                GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case EAST: {
                GL11.glRotated((double)angle, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case WEST: {
                GL11.glRotated((double)angle, (double)-1.0, (double)0.0, (double)0.0);
            }
        }
        GL11.glTranslated((double)(partRenderData.getScale() * (float)(-point.getX())), (double)(partRenderData.getScale() * (float)(-point.getY())), (double)(partRenderData.getScale() * (float)(-point.getZ())));
        GL11.glTranslated((double)(partRenderData.getScale() * -0.5f), (double)(partRenderData.getScale() * -0.5f), (double)(partRenderData.getScale() * -0.5f));
        this.renderPart(partRenderData);
        GL11.glPopMatrix();
    }
}

