/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render.entity;

import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.capability.IWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.render.SkinPartRenderData;
import moe.plushie.armourers_workshop.client.render.SkinPartRenderer;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.capability.wardrobe.ExtraColours;
import moe.plushie.armourers_workshop.common.capability.wardrobe.WardrobeCap;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDye;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class SkinLayerRenderer<E extends EntityLivingBase, R extends RenderLivingBase>
implements LayerRenderer<E> {
    protected static final float SCALE = 0.0625f;
    protected final R renderer;

    public SkinLayerRenderer(R renderer) {
        this.renderer = renderer;
    }

    public void func_177141_a(E entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        IEntitySkinCapability skinCapability = EntitySkinCapability.get(entitylivingbaseIn);
        if (skinCapability == null) {
            return;
        }
        double distance = Minecraft.func_71410_x().field_71439_g.func_70011_f(((EntityLivingBase)entitylivingbaseIn).field_70165_t, ((EntityLivingBase)entitylivingbaseIn).field_70163_u, ((EntityLivingBase)entitylivingbaseIn).field_70161_v);
        if (distance > (double)ConfigHandlerClient.renderDistanceSkin) {
            return;
        }
        ISkinType[] skinTypes = skinCapability.getValidSkinTypes();
        for (int i = 0; i < skinTypes.length; ++i) {
            GlStateManager.func_179094_E();
            this.setRotTranForPartType(entitylivingbaseIn, skinTypes[i], limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            this.renderSkinType((EntityLivingBase)entitylivingbaseIn, skinTypes[i], skinCapability, WardrobeCap.get(entitylivingbaseIn));
            GlStateManager.func_179121_F();
        }
    }

    protected abstract void setRotTranForPartType(E var1, ISkinType var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    protected void renderSkinType(EntityLivingBase entity, ISkinType skinType, IEntitySkinCapability skinCapability, IWardrobeCap wardrobeCap) {
        double distance = entity.func_70032_d((Entity)Minecraft.func_71410_x().field_71439_g);
        for (int i = 0; i < skinCapability.getSlotCountForSkinType(skinType); ++i) {
            Skin skin;
            ISkinDescriptor skinDescriptor = skinCapability.getSkinDescriptor(skinType, i);
            if (skinDescriptor == null || (skin = ClientSkinCache.INSTANCE.getSkin(skinDescriptor)) == null) continue;
            IExtraColours extraColours = ExtraColours.EMPTY_COLOUR;
            ISkinDye dye = skinDescriptor.getSkinDye();
            if (wardrobeCap != null) {
                extraColours = wardrobeCap.getExtraColours();
                dye = new SkinDye(wardrobeCap.getDye());
                for (int dyeIndex = 0; dyeIndex < 8; ++dyeIndex) {
                    if (!skinDescriptor.getSkinDye().haveDyeInSlot(dyeIndex)) continue;
                    dye.addDye(dyeIndex, skinDescriptor.getSkinDye().getDyeColour(dyeIndex));
                }
            }
            GL11.glEnable((int)2977);
            for (int partIndex = 0; partIndex < skin.getParts().size(); ++partIndex) {
                SkinPartRenderer.INSTANCE.renderPart(new SkinPartRenderData(skin.getParts().get(partIndex), 0.0625f, dye, extraColours, distance, false, false, false, null));
            }
            GL11.glDisable((int)2977);
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

