/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render.tileentities;

import java.awt.Color;
import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.helper.MannequinTextureHelper;
import moe.plushie.armourers_workshop.client.model.ModelHelper;
import moe.plushie.armourers_workshop.client.model.ModelMannequin;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.client.render.tileentities.RenderBlockMannequinItems;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.client.texture.PlayerTexture;
import moe.plushie.armourers_workshop.common.Contributors;
import moe.plushie.armourers_workshop.common.data.type.BipedRotations;
import moe.plushie.armourers_workshop.common.holiday.ModHolidays;
import moe.plushie.armourers_workshop.common.inventory.MannequinSlotType;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityMannequin;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBlockMannequin
extends TileEntitySpecialRenderer<TileEntityMannequin> {
    private static final ResourceLocation circle = new ResourceLocation("armourers_workshop".toLowerCase(), "textures/other/nanoha-circle.png");
    private static RenderBlockMannequinItems renderItems = new RenderBlockMannequinItems();
    private static boolean isHalloweenSeason;
    private static boolean isHalloween;
    private static final float SCALE = 0.0625f;
    private static long lastTextureBuild;
    private final ModelMannequin modelSteve;
    private final ModelMannequin modelAlex;
    private final Minecraft mc = Minecraft.func_71410_x();

    public RenderBlockMannequin() {
        this.modelSteve = new ModelMannequin(false);
        this.modelAlex = new ModelMannequin(true);
    }

    public void render(TileEntityMannequin te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Contributors.Contributor contributor;
        this.mc.field_71424_I.func_76320_a("armourersMannequin");
        this.mc.field_71424_I.func_76320_a("holidayCheck");
        isHalloweenSeason = ModHolidays.HALLOWEEN_SEASON.isHolidayActive();
        isHalloween = ModHolidays.HALLOWEEN.isHolidayActive();
        this.mc.field_71424_I.func_76318_c("move");
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179091_B();
        int rotaion = te.PROP_ROTATION.get();
        GlStateManager.func_179137_b((double)(x + 0.5 + (double)te.PROP_OFFSET_X.get().floatValue()), (double)(y + 1.0 + (double)te.PROP_OFFSET_Y.get().floatValue()), (double)(z + 0.5 + (double)te.PROP_OFFSET_Z.get().floatValue()));
        BipedRotations rots = te.PROP_BIPED_ROTATIONS.get();
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(rots.getPartRotations(BipedRotations.BipedPart.CHEST)[0])), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(rots.getPartRotations(BipedRotations.BipedPart.CHEST)[1])), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(rots.getPartRotations(BipedRotations.BipedPart.CHEST)[2])), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)rotaion * 22.5f), (float)0.0f, (float)1.0f, (float)0.0f);
        if (te.PROP_DOLL.get().booleanValue()) {
            float dollScale = 0.5f;
            GL11.glScalef((float)dollScale, (float)dollScale, (float)dollScale);
            GL11.glTranslatef((float)0.0f, (float)1.5f, (float)0.0f);
        }
        this.mc.field_71424_I.func_76318_c("getTexture");
        boolean slimModel = false;
        PlayerTexture playerTexture = MannequinTextureHelper.getMannequinTexture(te);
        ResourceLocation rl = playerTexture.getResourceLocation();
        slimModel = playerTexture.isSlimModel();
        boolean download = playerTexture.isDownloaded();
        ModelMannequin model = this.modelSteve;
        if (slimModel) {
            model = this.modelAlex;
        }
        this.mc.field_71424_I.func_76318_c("fakePlayer");
        rots.applyRotationsToBiped(model);
        model.field_78115_e.field_78795_f = 0.0f;
        model.field_78115_e.field_78796_g = 0.0f;
        model.field_78115_e.field_78808_h = 0.0f;
        if (isHalloween) {
            double dX = -x - 0.5;
            double dY = -y - 0.0;
            double dZ = -z - 0.5;
            double yaw = Math.atan2(dZ, dX);
            double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
            model.field_78116_c.field_78795_f = (float)(pitch += 1.5707963267948966);
            model.field_78116_c.field_78796_g = (float)(yaw -= Math.toRadians((float)rotaion * 22.5f - 90.0f));
            model.field_78116_c.field_78808_h = 0.0f;
            model.field_178720_f.field_78795_f = model.field_78116_c.field_78795_f;
            model.field_178720_f.field_78796_g = model.field_78116_c.field_78796_g;
            model.field_178720_f.field_78808_h = 0.0f;
        }
        this.mc.field_71424_I.func_76318_c("textureBuild");
        this.mc.field_71424_I.func_76318_c("textureBind");
        this.func_147499_a(rl);
        this.mc.field_71424_I.func_76318_c("selectModelRender");
        this.mc.field_71424_I.func_76318_c("modelRender");
        if (te.PROP_VISIBLE.get() & (te.PROP_OWNER.get() == null || !te.PROP_OWNER.get().getName().equalsIgnoreCase("null"))) {
            this.renderModel(te, model);
            if (isHalloweenSeason) {
                GlStateManager.func_179094_E();
                if (model.field_78091_s) {
                    ModelHelper.enableChildModelScale(true, 0.0625f);
                }
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(model.field_78116_c.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(model.field_78116_c.field_78796_g)), (float)0.0f, (float)-1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(model.field_78116_c.field_78795_f)), (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.25f, (float)0.0f);
                this.mc.func_175599_af().func_181564_a(new ItemStack(Blocks.field_150423_aK), ItemCameraTransforms.TransformType.FIXED);
                if (model.field_78091_s) {
                    ModelHelper.disableChildModelScale();
                }
                GlStateManager.func_179121_F();
            }
        }
        this.mc.field_71424_I.func_76318_c("magicCircle");
        if (te.PROP_RENDER_EXTRAS.get() & te.PROP_VISIBLE.get() && (contributor = Contributors.INSTANCE.getContributor(te.PROP_OWNER.get())) != null) {
            int offset = te.func_174877_v().hashCode();
            RenderBlockMannequin.renderMagicCircle(this.mc, contributor.r, contributor.g, contributor.b, partialTicks, offset, te.PROP_BIPED_ROTATIONS.get().isChild());
        }
        this.mc.field_71424_I.func_76318_c("equippedItems");
        double distance = Minecraft.func_71410_x().field_71439_g.func_174818_b(te.func_174877_v());
        if (distance <= (double)ConfigHandlerClient.renderDistanceMannequinEquipment) {
            // empty if block
        }
        this.mc.field_71424_I.func_76318_c("reset");
        model.field_178722_k.field_78808_h = 0.0f;
        model.field_178721_j.field_78808_h = 0.0f;
        model.field_78116_c.field_78808_h = 0.0f;
        model.field_178720_f.field_78808_h = 0.0f;
        this.mc.field_71424_I.func_76318_c("pop");
        GlStateManager.func_179101_C();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        this.mc.field_71424_I.func_76319_b();
        this.mc.field_71424_I.func_76319_b();
    }

    public static void renderMagicCircle(Minecraft mc, byte r, byte g, byte b, float partialTickTime, int offset, boolean isChild) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        if (isChild) {
            ModelHelper.enableChildModelScale(false, 0.0625f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179109_b((float)0.0f, (float)1.48f, (float)0.0f);
        ModRenderHelper.disableLighting();
        float circleScale = 2.0f;
        GlStateManager.func_179152_a((float)circleScale, (float)circleScale, (float)circleScale);
        float rotation = (float)((double)(mc.field_71441_e.func_82737_E() + (long)offset) / 0.8 % 360.0) + partialTickTime;
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        mc.field_71446_o.func_110577_a(circle);
        Tessellator tess = Tessellator.func_178181_a();
        tess.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        tess.func_178180_c().func_181662_b(-1.0, 0.0, -1.0).func_187315_a(1.0, 0.0).func_181669_b(r & 0xFF, g & 0xFF, b & 0xFF, 255).func_181675_d();
        tess.func_178180_c().func_181662_b(1.0, 0.0, -1.0).func_187315_a(0.0, 0.0).func_181669_b(r & 0xFF, g & 0xFF, b & 0xFF, 255).func_181675_d();
        tess.func_178180_c().func_181662_b(1.0, 0.0, 1.0).func_187315_a(0.0, 1.0).func_181669_b(r & 0xFF, g & 0xFF, b & 0xFF, 255).func_181675_d();
        tess.func_178180_c().func_181662_b(-1.0, 0.0, 1.0).func_187315_a(1.0, 1.0).func_181669_b(r & 0xFF, g & 0xFF, b & 0xFF, 255).func_181675_d();
        tess.func_78381_a();
        ModRenderHelper.enableLighting();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isChild) {
            ModelHelper.disableChildModelScale();
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    private void renderModel(TileEntityMannequin te, ModelBiped targetBiped) {
        if (!this.hasCustomHead(te)) {
            if (te.PROP_BIPED_ROTATIONS.get().isChild()) {
                ModelHelper.enableChildModelScale(true, 0.0625f);
            }
            targetBiped.field_78116_c.func_78785_a(0.0625f);
            GL11.glDisable((int)2884);
            targetBiped.field_178720_f.func_78785_a(0.0625f);
            GL11.glEnable((int)2884);
            if (te.PROP_BIPED_ROTATIONS.get().isChild()) {
                ModelHelper.disableChildModelScale();
            }
        }
        if (te.PROP_BIPED_ROTATIONS.get().isChild()) {
            ModelHelper.enableChildModelScale(false, 0.0625f);
        }
        targetBiped.field_78115_e.func_78785_a(0.0625f);
        targetBiped.field_178723_h.func_78785_a(0.0625f);
        targetBiped.field_178724_i.func_78785_a(0.0625f);
        targetBiped.field_178721_j.func_78785_a(0.0625f);
        targetBiped.field_178722_k.func_78785_a(0.0625f);
        if (te.PROP_BIPED_ROTATIONS.get().isChild()) {
            ModelHelper.disableChildModelScale();
        }
    }

    private Color getColourAtPos(int x, int y) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)3);
        GL11.glReadPixels((int)x, (int)y, (int)1, (int)1, (int)6407, (int)5126, (FloatBuffer)buffer);
        int r = Math.round(buffer.get() * 255.0f);
        int g = Math.round(buffer.get() * 255.0f);
        int b = Math.round(buffer.get() * 255.0f);
        return new Color(r, g, b);
    }

    public ItemStack getStackInMannequinSlot(IInventory inventory, MannequinSlotType slot) {
        return inventory.func_70301_a(slot.ordinal());
    }

    private boolean hasCustomHead(IInventory inventory) {
        Skin skin;
        ItemStack stack = this.getStackInMannequinSlot(inventory, MannequinSlotType.HEAD);
        if (stack != null && stack.func_77973_b() instanceof ItemBlock) {
            return true;
        }
        if (isHalloweenSeason) {
            return true;
        }
        SkinDescriptor skinPointer = SkinNBTHelper.getSkinDescriptorFromStack(stack);
        if (skinPointer != null && (skin = ClientSkinCache.INSTANCE.getSkin(skinPointer, false)) != null) {
            return SkinProperties.PROP_MODEL_OVERRIDE_HEAD.getValue(skin.getProperties());
        }
        return false;
    }

    private ISkinDescriptor[] getSkinPointers(TileEntityMannequin te) {
        ISkinDescriptor[] skinPointers = new ISkinDescriptor[20];
        for (int i = 0; i < 5; ++i) {
            skinPointers[0 + i * 4] = this.getSkinPointerForSlot(te, 0 + i * 7);
            skinPointers[1 + i * 4] = this.getSkinPointerForSlot(te, 1 + i * 7);
            skinPointers[2 + i * 4] = this.getSkinPointerForSlot(te, 2 + i * 7);
            skinPointers[3 + i * 4] = this.getSkinPointerForSlot(te, 3 + i * 7);
        }
        return skinPointers;
    }

    private ISkinDescriptor getSkinPointerForSlot(TileEntityMannequin te, MannequinSlotType slotType) {
        return SkinNBTHelper.getSkinDescriptorFromStack(this.getStackInMannequinSlot(te, slotType));
    }

    private ISkinDescriptor getSkinPointerForSlot(TileEntityMannequin te, int slotIndex) {
        return SkinNBTHelper.getSkinDescriptorFromStack(te.func_70301_a(slotIndex));
    }

    static {
        lastTextureBuild = 0L;
    }
}

