/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render.tileentities;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.client.model.block.ModelBlockSkinnable;
import moe.plushie.armourers_workshop.client.render.SkinPartRenderData;
import moe.plushie.armourers_workshop.client.render.SkinPartRenderer;
import moe.plushie.armourers_workshop.client.render.item.RenderItemEquipmentSkin;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.init.blocks.BlockSkinnable;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinPart;
import moe.plushie.armourers_workshop.common.tileentities.TileEntitySkinnable;
import moe.plushie.armourers_workshop.common.tileentities.TileEntitySkinnableChild;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBlockSkinnable
extends TileEntitySpecialRenderer<TileEntitySkinnable> {
    private static final ModelBlockSkinnable loadingModel = new ModelBlockSkinnable();
    private static final float SCALE = 0.0625f;
    private ArrayList<RenderLast> renderList;

    public RenderBlockSkinnable() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.renderList = new ArrayList();
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
    }

    public void render(TileEntitySkinnable te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        ISkinDescriptor skinPointer = te.getSkinPointer();
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockSkinnable)) {
            return;
        }
        if (skinPointer != null) {
            Skin skin = ClientSkinCache.INSTANCE.getSkin(skinPointer);
            if (skin != null) {
                if (te.isParent()) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179123_a();
                    GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockSkinnable.STATE_FACING);
                    if (facing == EnumFacing.EAST) {
                        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    if (facing == EnumFacing.SOUTH) {
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    if (facing == EnumFacing.WEST) {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    double distance = Minecraft.func_71410_x().field_71439_g.func_70011_f((double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p());
                    GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
                    for (int i = 0; i < skin.getParts().size(); ++i) {
                        SkinPart skinPart = skin.getParts().get(i);
                        SkinPartRenderer.INSTANCE.renderPart(new SkinPartRenderData(skinPart, 0.0625f, te.getSkinPointer().getSkinDye(), null, distance, true, true, true, null));
                    }
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179099_b();
                    GlStateManager.func_179121_F();
                    return;
                }
                if (!((TileEntitySkinnableChild)te).isParentValid()) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
                    RenderItemEquipmentSkin.renderLoadingIcon(te.getSkinPointer());
                    GlStateManager.func_179121_F();
                }
                return;
            }
            ClientSkinCache.INSTANCE.requestSkinFromServer(skinPointer);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        RenderItemEquipmentSkin.renderLoadingIcon(te.getSkinPointer());
        GlStateManager.func_179121_F();
    }

    private class RenderLast
    implements Comparable<RenderLast> {
        public final TileEntity tileEntity;
        public final double x;
        public final double y;
        public final double z;

        public RenderLast(TileEntity tileEntity, double x, double y, double z) {
            this.tileEntity = tileEntity;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public int compareTo(RenderLast o) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            double dist = this.getDistanceFrom(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            double otherDist = o.getDistanceFrom(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            return (int)((otherDist - dist) * 128.0);
        }

        public double getDistanceFrom(double x, double y, double z) {
            double d3 = (double)this.tileEntity.func_174877_v().func_177958_n() + 0.5 - x;
            double d4 = (double)this.tileEntity.func_174877_v().func_177956_o() + 0.5 - y;
            double d5 = (double)this.tileEntity.func_174877_v().func_177952_p() + 0.5 - z;
            return d3 * d3 + d4 * d4 + d5 * d5;
        }
    }
}

