/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.skin;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.model.SkinModel;
import moe.plushie.armourers_workshop.client.model.bake.ColouredFace;
import moe.plushie.armourers_workshop.client.render.SkinPartRenderData;
import moe.plushie.armourers_workshop.common.skin.data.SkinDye;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientSkinPartData
implements RemovalListener<ModelKey, SkinModel> {
    public static final SkinDye BLANK_DYE = new SkinDye();
    public ArrayList<ColouredFace>[] vertexLists;
    public final LoadingCache<ModelKey, SkinModel> modelCache;
    public int[] totalCubesInPart;
    private int[] averageR = new int[12];
    private int[] averageG = new int[12];
    private int[] averageB = new int[12];

    public ClientSkinPartData() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.removalListener((RemovalListener)this);
        if (ConfigHandlerClient.modelPartCacheExpireTime > 0) {
            builder.expireAfterAccess((long)ConfigHandlerClient.modelPartCacheExpireTime, TimeUnit.SECONDS);
        }
        if (ConfigHandlerClient.modelPartCacheMaxSize > 0) {
            builder.maximumSize((long)ConfigHandlerClient.skinCacheMaxSize);
        }
        this.modelCache = builder.build((CacheLoader)new ModelLoader());
    }

    public SkinModel getModelForDye(SkinPartRenderData renderData) {
        ModelKey modelKey = new ModelKey(renderData.getSkinDye(), renderData.getExtraColours(), renderData.getEntityTexture());
        return (SkinModel)this.modelCache.getUnchecked((Object)modelKey);
    }

    public void cleanUpDisplayLists() {
        this.modelCache.invalidateAll();
    }

    public int getModelCount() {
        return (int)this.modelCache.size();
    }

    public void setVertexLists(ArrayList<ColouredFace>[] vertexLists) {
        this.vertexLists = vertexLists;
    }

    public void setAverageDyeValues(int[] r, int[] g, int[] b) {
        this.averageR = r;
        this.averageG = g;
        this.averageB = b;
    }

    public int[] getAverageDyeColour(int dyeNumber) {
        return new int[]{this.averageR[dyeNumber], this.averageG[dyeNumber], this.averageB[dyeNumber]};
    }

    public void onRemoval(RemovalNotification<ModelKey, SkinModel> notification) {
        ((SkinModel)notification.getValue()).cleanUpDisplayLists();
    }

    public static class ModelKey {
        private ISkinDye skinDye;
        private IExtraColours extraColours;
        private ResourceLocation entityTexture;

        public ModelKey(ISkinDye skinDye, IExtraColours extraColours, ResourceLocation entityTexture) {
            this.skinDye = skinDye;
            this.extraColours = extraColours;
            this.entityTexture = entityTexture;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.entityTexture == null ? 0 : this.entityTexture.hashCode());
            result = 31 * result + (this.extraColours == null ? 0 : this.extraColours.hashCode());
            result = 31 * result + (this.skinDye == null ? 0 : this.skinDye.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModelKey other = (ModelKey)obj;
            if (this.entityTexture == null ? other.entityTexture != null : !this.entityTexture.equals((Object)other.entityTexture)) {
                return false;
            }
            if (this.extraColours == null ? other.extraColours != null : !this.extraColours.equals(other.extraColours)) {
                return false;
            }
            return !(this.skinDye == null ? other.skinDye != null : !this.skinDye.equals(other.skinDye));
        }
    }

    private class ModelLoader
    extends CacheLoader<ModelKey, SkinModel> {
        private ModelLoader() {
        }

        public SkinModel load(ModelKey key) throws Exception {
            return new SkinModel(ClientSkinPartData.this.vertexLists);
        }
    }
}

