/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.skin;

import java.awt.image.BufferedImage;
import java.io.IOException;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.client.model.bake.ColouredFace;
import moe.plushie.armourers_workshop.client.skin.SkinTextureKey;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.utils.BitwiseUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SkinModelTexture
extends AbstractTexture {
    private final BufferedImage texture = new BufferedImage(64, 32, 2);

    public void createTextureForColours(Skin skin, SkinTextureKey cmk) {
        for (int ix = 0; ix < 64; ++ix) {
            for (int iy = 0; iy < 32; ++iy) {
                int paintColour = skin.getPaintData()[ix + iy * 64];
                IPaintType paintType = PaintTypeRegistry.getInstance().getPaintTypeFromColour(paintColour);
                if (cmk != null) {
                    int dyeNumber;
                    if (paintType == PaintTypeRegistry.PAINT_TYPE_NORMAL) {
                        this.texture.setRGB(ix, iy, BitwiseUtils.setUByteToInt(paintColour, 0, 255));
                        continue;
                    }
                    if (paintType.getColourType() != null) {
                        int colour = this.dyeColour(cmk.getExtraColours().getColourBytes(paintType.getColourType()), paintColour, paintType.getChannelIndex(), skin, cmk);
                        this.texture.setRGB(ix, iy, BitwiseUtils.setUByteToInt(colour, 0, 255));
                        continue;
                    }
                    if (!(paintType.getId() >= 1 & paintType.getId() <= 8)) continue;
                    ISkinDye skinDye = cmk.getSkinDye();
                    if (skinDye.haveDyeInSlot(dyeNumber = paintType.getId() - 1)) {
                        byte[] dye = skinDye.getDyeColour(dyeNumber);
                        IPaintType dyeType = PaintTypeRegistry.getInstance().getPaintTypeFormByte(dye[3]);
                        if (dyeType == PaintTypeRegistry.PAINT_TYPE_NONE) continue;
                        int colour = this.dyeColour(dye, paintColour, paintType.getChannelIndex(), skin, cmk);
                        this.texture.setRGB(ix, iy, colour);
                        continue;
                    }
                    this.texture.setRGB(ix, iy, BitwiseUtils.setUByteToInt(paintColour, 0, 255));
                    continue;
                }
                if (paintType == PaintTypeRegistry.PAINT_TYPE_NORMAL) {
                    this.texture.setRGB(ix, iy, BitwiseUtils.setUByteToInt(paintColour, 0, 255));
                }
                if (!(paintType.getId() >= 1 & paintType.getId() <= 8)) continue;
                this.texture.setRGB(ix, iy, BitwiseUtils.setUByteToInt(paintColour, 0, 255));
            }
        }
    }

    private int dyeColour(byte[] dye, int colour, int dyeIndex, Skin skin, SkinTextureKey cmk) {
        IPaintType t;
        byte r = (byte)(colour >>> 16 & 0xFF);
        byte g = (byte)(colour >>> 8 & 0xFF);
        byte b = (byte)(colour & 0xFF);
        if (dye.length <= 3 || (t = PaintTypeRegistry.getInstance().getPaintTypeFormByte(dye[3])).getColourType() != null) {
            // empty if block
        }
        int[] average = new int[]{127, 127, 127};
        if (skin != null) {
            average = skin.getAverageDyeColour(dyeIndex);
        }
        dye = ColouredFace.dyeColour(r, g, b, dye, average);
        return -16777216 + ((dye[0] & 0xFF) << 16) + ((dye[1] & 0xFF) << 8) + (dye[2] & 0xFF);
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
    }

    public void bindTexture() {
        if (this.field_110553_a == -1) {
            this.func_110552_b();
            TextureUtil.func_110987_a((int)this.field_110553_a, (BufferedImage)this.texture);
        }
        GlStateManager.func_179144_i((int)this.field_110553_a);
    }
}

